/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.FallingBlock;
import org.bukkit.inventory.ItemStack;

public class DropAction
extends BaseSpellAction {
    private static Material defaultTool = Material.DIAMOND_PICKAXE;
    private int dropCount;
    private boolean falling = true;
    private Collection<ItemStack> drops;
    private ItemStack toolItem;
    private boolean giveToCaster;

    @Override
    public void finish(CastContext context) {
        super.finish(context);
        Location target = context.getTargetLocation();
        if (target == null || this.drops == null) {
            return;
        }
        for (ItemStack drop : this.drops) {
            if (this.giveToCaster) {
                context.getMage().giveItem(drop);
                continue;
            }
            target.getWorld().dropItemNaturally(target, drop);
        }
        this.drops = null;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.dropCount = parameters.getInt("drop_count", -1);
        this.falling = parameters.getBoolean("falling", true);
        this.giveToCaster = parameters.getBoolean("give_to_caster", false);
        String toolMaterialName = parameters.getString("tool", defaultTool.name());
        this.toolItem = null;
        try {
            ItemData toolData = context.getController().getOrCreateItem(toolMaterialName);
            if (toolData == null) {
                if (!toolMaterialName.isEmpty()) {
                    context.getLogger().warning("Invalid tool in drop action: " + toolMaterialName);
                }
            } else {
                this.toolItem = toolData.getItemStack();
            }
        }
        catch (Throwable ex) {
            context.getLogger().warning("Invalid tool in drop action: " + toolMaterialName);
        }
        if (this.toolItem == null) {
            this.toolItem = new ItemStack(defaultTool);
        }
        this.drops = new ArrayList<ItemStack>();
    }

    @Override
    public SpellResult perform(CastContext context) {
        Block block = context.getTargetBlock();
        if (!context.hasBreakPermission(block)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (!context.isDestructible(block)) {
            return SpellResult.NO_TARGET;
        }
        UndoList blockUndoList = com.elmakers.mine.bukkit.block.UndoList.getUndoList(block.getLocation());
        if (blockUndoList != null && blockUndoList.isScheduled()) {
            return SpellResult.NO_TARGET;
        }
        if (this.dropCount < 0 || this.drops.size() < this.dropCount) {
            this.drops.addAll(block.getDrops(this.toolItem));
        } else if (this.falling) {
            Location blockLocation = block.getLocation();
            Location blockCenter = new Location(blockLocation.getWorld(), blockLocation.getX() + 0.5, blockLocation.getY() + 0.5, blockLocation.getZ() + 0.5);
            FallingBlock falling = block.getWorld().spawnFallingBlock(blockCenter, block.getType(), block.getData());
            falling.setDropItem(false);
        }
        UndoList undoList = context.getUndoList();
        if (!undoList.isBypass()) {
            context.registerForUndo(block);
            context.clearAttachables(block);
        }
        BlockState prior = block.getState();
        block.setType(Material.AIR);
        if (undoList != null && !undoList.isScheduled()) {
            context.getController().logBlockChange(context.getMage(), prior, block.getState());
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean requiresBreakPermission() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }
}

