/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.populator.builtin;

import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import com.elmakers.mine.bukkit.world.populator.MagicChunkPopulator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class ChestPopulator
extends MagicChunkPopulator {
    private final Deque<WeightedPair<Integer>> baseProbability = new ArrayDeque<WeightedPair<Integer>>();
    private final Deque<WeightedPair<String>> itemProbability = new ArrayDeque<WeightedPair<String>>();
    private int maxY = 255;
    private int minY = 0;

    @Override
    public boolean onLoad(ConfigurationSection config) {
        ConfigurationSection wands;
        this.baseProbability.clear();
        this.itemProbability.clear();
        this.maxY = config.getInt("max_y", this.maxY);
        this.minY = config.getInt("min_y", this.minY);
        ConfigurationSection base = config.getConfigurationSection("base_probability");
        if (base != null) {
            RandomUtils.populateIntegerProbabilityMap(this.baseProbability, base);
        }
        if ((wands = config.getConfigurationSection("item_probability")) != null) {
            RandomUtils.populateStringProbabilityMap(this.itemProbability, wands);
        }
        return this.baseProbability.size() > 0 && this.itemProbability.size() > 0;
    }

    protected String[] populateChest(Chest chest) {
        Integer wandCount = (Integer)RandomUtils.weightedRandom(this.baseProbability);
        String[] wandNames = new String[wandCount.intValue()];
        for (int i = 0; i < wandCount; ++i) {
            String wandName = (String)RandomUtils.weightedRandom(this.itemProbability);
            ItemStack item = this.controller.createItem(wandName);
            if (item != null) {
                chest.getInventory().addItem(new ItemStack[]{item});
            } else {
                wandName = "*" + wandName;
            }
            wandNames[i] = wandName;
        }
        return wandNames;
    }

    public void setMaxY(int maxY) {
        this.maxY = maxY;
    }

    public void populate(World world, Random random, Chunk chunk) {
        BlockState[] tiles;
        for (BlockState block : tiles = chunk.getTileEntities()) {
            Object[] wandNames;
            if (block.getType() != Material.CHEST || !(block instanceof Chest) || block.getY() < this.minY || block.getY() > this.maxY) continue;
            Chest chest = (Chest)block;
            if (block.getType() != Material.CHEST || (wandNames = this.populateChest(chest)).length <= 0 || this.controller == null) continue;
            Location location = block.getLocation();
            this.controller.info("Added items to chest: " + StringUtils.join((Object[])wandNames, (String)", ") + " at " + location.getWorld().getName() + "," + location.toVector());
        }
    }
}

