/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.MaterialSetManager;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.materials.MaterialSets;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public class BlockSpell
extends UndoableSpell {
    @Nonnull
    private MaterialSet indestructible = MaterialSets.empty();
    private MaterialSet destructible;
    private MaterialSet destructibleOverride;
    protected boolean checkDestructible = true;
    protected boolean checkIndestructible = true;
    protected float destructibleDurability = 0.0f;
    public static final String[] BLOCK_PARAMETERS = new String[]{"indestructible", "destructible", "check_destructible", "bypass_undo", "undo", "destructible_durability", "check_indestructible"};

    @Override
    public boolean isIndestructible(Block block) {
        if (!this.checkIndestructible) {
            return false;
        }
        if (this.mage.isSuperPowered()) {
            return false;
        }
        if (this.controller.hasBypassPermission((CommandSender)this.mage.getPlayer())) {
            return false;
        }
        if (this.controller.isLocked(block)) {
            return true;
        }
        return this.indestructible.testBlock(block) || this.mage.isIndestructible(block);
    }

    @Override
    public boolean isDestructible(Block block) {
        if (this.isIndestructible(block)) {
            return false;
        }
        if (!this.checkDestructible) {
            return true;
        }
        if (this.destructibleOverride != null && this.destructibleOverride.testBlock(block)) {
            return true;
        }
        if (this.destructibleDurability > 0.0f && CompatibilityUtils.getDurability(block.getType()) > this.destructibleDurability) {
            return false;
        }
        if (this.targetBreakables > 0.0 && this.currentCast.isBreakable(block)) {
            return true;
        }
        if (this.destructible == null) {
            return this.mage.isDestructible(block);
        }
        return this.destructible.testBlock(block);
    }

    @Nonnull
    public MaterialSet getDestructible() {
        if (this.destructible != null) {
            return this.destructible;
        }
        return this.controller.getDestructibleMaterialSet();
    }

    public boolean areAnyDestructible(Block block) {
        if (this.isIndestructible(block)) {
            return false;
        }
        if (!this.checkDestructible) {
            return true;
        }
        if (this.targetBreakables > 0.0 && this.currentCast.isBreakable(block)) {
            return true;
        }
        MaterialSet allDestructible = this.destructible;
        if (allDestructible == null) {
            allDestructible = this.controller.getDestructibleMaterialSet();
        }
        if (allDestructible == null) {
            return true;
        }
        if (allDestructible.testBlock(block)) {
            return true;
        }
        BlockData blockData = UndoList.getBlockData(block.getLocation());
        return blockData != null && blockData.containsAny(allDestructible);
    }

    protected void addDestructible(MaterialAndData material) {
        MaterialSet current = this.getDestructible();
        this.destructible = MaterialSets.union(current, material);
    }

    @Override
    public void processParameters(ConfigurationSection parameters) {
        String destructibleKey;
        super.processParameters(parameters);
        MaterialSetManager materials = this.controller.getMaterialSetManager();
        this.indestructible = MaterialSets.empty();
        this.indestructible = materials.fromConfig(parameters.getString("id"), this.indestructible);
        this.indestructible = materials.fromConfig(parameters.getString("indestructible"), this.indestructible);
        this.destructible = materials.fromConfig(parameters.getString("destructible", parameters.getString("modifiable")));
        this.destructibleOverride = parameters.getBoolean("destructible_override", false) ? ((destructibleKey = this.controller.getDestructibleMaterials(this.mage, this.mage.getLocation())) == null ? null : materials.fromConfig(destructibleKey)) : null;
        this.checkDestructible = parameters.getBoolean("check_destructible", true);
        this.checkDestructible = parameters.getBoolean("cd", this.checkDestructible);
        this.checkIndestructible = parameters.getBoolean("check_indestructible", true);
        this.destructibleDurability = (float)parameters.getDouble("destructible_durability", 0.0);
    }

    @Override
    public String getMessage(String messageKey, String def) {
        String message = super.getMessage(messageKey, def);
        if (!this.getVariables().contains("count") && !this.mage.getVariables().contains("count")) {
            message = message.replace("$count", Integer.toString(this.getModifiedCount()));
        }
        message = message.replace("@blocks", Integer.toString(this.getModifiedCount()));
        return message;
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        parameters.addAll(Arrays.asList(BLOCK_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("undo")) {
            examples.addAll(Arrays.asList(EXAMPLE_DURATIONS));
        } else if (parameterKey.equals("indestructible") || parameterKey.equals("destructible")) {
            examples.addAll(this.controller.getMaterialSetManager().getMaterialSets());
        } else if (parameterKey.equals("check_destructible") || parameterKey.equals("bypass_undo")) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        }
    }

    public static BlockFace goLeft(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    public static BlockFace goRight(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    @Override
    public boolean requiresBuildPermission() {
        return true;
    }

    @Override
    public boolean requiresBreakPermission() {
        return false;
    }
}

