/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.automata.Automaton;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.EntityMetadataUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.utility.Targeting;
import com.elmakers.mine.bukkit.utility.TextUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.TippedArrow;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.projectiles.ProjectileSource;

public class EntityController
implements Listener {
    private final MagicController controller;
    private double meleeDamageReduction = 0.0;
    private boolean preventMeleeDamage = false;
    private boolean keepWandsOnDeath = true;
    private boolean disableItemSpawn = false;
    private boolean forceSpawn = false;
    private boolean preventWandMeleeDamage = true;
    private int ageDroppedItems = 0;
    private Map<EntityType, Double> entityDamageReduction;

    public void loadProperties(ConfigurationSection properties) {
        this.preventMeleeDamage = properties.getBoolean("prevent_melee_damage", false);
        this.meleeDamageReduction = properties.getDouble("melee_damage_reduction", 0.0);
        this.keepWandsOnDeath = properties.getBoolean("keep_wands_on_death", true);
        this.preventWandMeleeDamage = properties.getBoolean("prevent_wand_melee_damage", true);
        this.ageDroppedItems = properties.getInt("age_dropped_items", 0);
        ConfigurationSection entityReduction = properties.getConfigurationSection("entity_damage_reduction");
        if (entityReduction != null) {
            Set keys = entityReduction.getKeys(false);
            this.entityDamageReduction = new HashMap<EntityType, Double>();
            for (String key : keys) {
                try {
                    EntityType entityType = EntityType.valueOf((String)key.toUpperCase());
                    this.entityDamageReduction.put(entityType, entityReduction.getDouble(key));
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning("Invalid entity type found in entity_damage_reduction: " + key);
                }
            }
        } else {
            this.entityDamageReduction = null;
        }
    }

    public EntityController(MagicController controller) {
        this.controller = controller;
    }

    public void setDisableItemSpawn(boolean disable) {
        this.disableItemSpawn = disable;
    }

    public void setForceSpawn(boolean forceSpawn) {
        this.forceSpawn = forceSpawn;
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (this.forceSpawn) {
            event.setCancelled(false);
        }
    }

    @EventHandler
    public void onItemMerge(ItemMergeEvent event) {
        Item itemOne = event.getEntity();
        Item itemTwo = event.getTarget();
        if (EntityMetadataUtils.instance().getBoolean((Entity)itemOne, "temporary") || EntityMetadataUtils.instance().getBoolean((Entity)itemTwo, "temporary")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        Targeting.checkTracking((Entity)projectile, null, CompatibilityUtils.getHitBlock(event));
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent event) {
        UndoList undoList;
        Entity entity = event.getEntity();
        if (this.controller.isMagicNPC(entity)) {
            event.setCancelled(true);
            return;
        }
        Mage mage = this.controller.getRegisteredMage(entity);
        if (mage != null) {
            mage.onCombust(event);
        }
        if (this.checkSuperProtection(entity)) {
            event.setCancelled(true);
            return;
        }
        if (!event.isCancelled() && (undoList = this.controller.getPendingUndo(entity.getLocation())) != null) {
            undoList.modify(entity);
        }
    }

    private boolean checkSuperProtection(Entity entity) {
        EntityData mob = this.controller.getMob(entity);
        if (mob != null && mob.isSuperProtected()) {
            if (entity.getFireTicks() > 0) {
                entity.setFireTicks(0);
            }
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Mage mage;
        UndoList undoList;
        Entity entity = event.getEntity();
        Entity damager = event.getDamager();
        if (entity instanceof Projectile || entity instanceof TNTPrimed) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_ATTACK && (undoList = this.controller.getEntityUndo(damager)) != null) {
            if (undoList.isScheduled()) {
                undoList.damage(entity);
                if (!entity.isValid()) {
                    event.setCancelled(true);
                }
            } else {
                undoList.modify(entity);
            }
        }
        if ((mage = this.controller.getRegisteredMage(damager = CompatibilityUtils.getSource(damager))) != null && mage instanceof Mage) {
            mage.onDamageDealt((EntityDamageEvent)event);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityPreDamageByEntity(EntityDamageByEntityEvent event) {
        Double reduction;
        Entity damager;
        EntityData entityData;
        Entity entity = event.getEntity();
        if (entity instanceof Projectile || entity instanceof TNTPrimed) {
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && (entityData = this.controller.getMob(damager = event.getDamager())) != null && entityData.isPreventMelee()) {
            event.setCancelled(true);
            return;
        }
        Mage entityMage = this.controller.getRegisteredMage(entity);
        if (entityMage != null) {
            com.elmakers.mine.bukkit.api.wand.Wand damagedWand;
            Player damaged;
            entityMage.damagedBy(event.getDamager(), event.getDamage());
            if (entity instanceof Player && (damaged = (Player)entity).isBlocking() && (damagedWand = entityMage.getActiveWand()) != null) {
                damagedWand.playEffects("hit_blocked");
            }
            if (entityMage.isSuperProtected()) {
                event.setCancelled(true);
                return;
            }
        }
        if (this.checkSuperProtection(entity)) {
            event.setCancelled(true);
            return;
        }
        Entity damager2 = event.getDamager();
        if (this.entityDamageReduction != null && (reduction = this.entityDamageReduction.get(damager2.getType())) != null) {
            if (reduction >= 1.0) {
                event.setCancelled(true);
                return;
            }
            event.setDamage(event.getDamage() * (1.0 - reduction));
        }
        if (damager2 instanceof Player) {
            boolean isMelee;
            Mage damagerMage = this.controller.getRegisteredMage(damager2);
            com.elmakers.mine.bukkit.api.wand.Wand activeWand = null;
            boolean bl = isMelee = event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK && !CompatibilityUtils.isDamaging();
            if (isMelee && this.meleeDamageReduction > 0.0) {
                if (this.meleeDamageReduction >= 1.0) {
                    event.setCancelled(true);
                    return;
                }
                event.setDamage(event.getDamage() * (1.0 - this.meleeDamageReduction));
            }
            if (isMelee && damagerMage != null && (activeWand = damagerMage.getActiveWand()) != null) {
                activeWand.playEffects("hit_entity");
                activeWand.damageDealt(event.getDamage(), entity);
            }
            if (this.preventWandMeleeDamage) {
                boolean hasWand = activeWand != null;
                Player player = (Player)damager2;
                ItemStack itemInHand = player.getInventory().getItemInMainHand();
                boolean isMeleeWeapon = this.controller.isMeleeWeapon(itemInHand);
                if (isMelee && hasWand && !isMeleeWeapon) {
                    event.setCancelled(true);
                } else if (!hasWand && this.preventMeleeDamage && isMelee && !isMeleeWeapon) {
                    event.setCancelled(true);
                }
            }
        } else {
            Targeting.checkTracking(damager2, entity, null);
        }
    }

    public void handlePlayerDeath(Player player, Mage mage, List<ItemStack> drops, boolean isKeepInventory) {
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            if (mage.hasStoredInventory()) {
                this.controller.info("** Wand inventory was open, clearing drops: " + drops.size(), 15);
                drops.clear();
                wand.deactivate();
                if (!isKeepInventory) {
                    ItemStack[] stored;
                    for (ItemStack stack : stored = player.getInventory().getContents()) {
                        if (stack == null) continue;
                        drops.add(stack);
                    }
                }
                this.controller.info("** Restored inventory added to drops: " + drops.size(), 15);
            } else {
                wand.deactivate();
            }
        }
        if (isKeepInventory) {
            this.controller.info("** Keep inventory is set,", 15);
            return;
        }
        int dropSize = drops.size();
        mage.addRespawnInventories(drops);
        mage.restoreRespawnInventories();
        dropSize = drops.size() - dropSize;
        this.controller.info("** Dropping " + dropSize + " items that were given on death, drops now: " + drops.size(), 15);
        PlayerInventory inventory = player.getInventory();
        ItemStack[] contents = inventory.getContents();
        for (int index = 0; index < contents.length; ++index) {
            ItemStack itemStack = contents[index];
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            if (NMSUtils.isTemporary(itemStack)) {
                drops.remove(itemStack);
                this.controller.info("** Removing temporary item from drops: " + TextUtils.nameItem(itemStack) + ", drops now: " + drops.size(), 15);
                contents[index] = null;
                continue;
            }
            boolean keepItem = InventoryUtils.getMetaBoolean(itemStack, "keep", false);
            if (!keepItem && this.keepWandsOnDeath && Wand.isWand(itemStack)) {
                keepItem = true;
            }
            if (keepItem) {
                mage.addToRespawnInventory(index, itemStack);
                contents[index] = null;
                drops.remove(itemStack);
                this.controller.info("** Removing keep item from drops: " + TextUtils.nameItem(itemStack) + ", drops now: " + drops.size(), 15);
                continue;
            }
            if (!Wand.isSkill(itemStack)) continue;
            drops.remove(itemStack);
            contents[index] = null;
            this.controller.info("** Removing skill item from drops: " + TextUtils.nameItem(itemStack) + ", drops now: " + drops.size(), 15);
        }
        inventory.setContents(contents);
        this.controller.info("** Done processing death with drops remaining: " + drops.size(), 15);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDeath(EntityDeathEvent event) {
        Mage mage;
        Mage damagerMage;
        EntityDamageByEntityEvent dbe;
        Entity damager;
        EntityDamageEvent damageEvent;
        Automaton automaton;
        Long spawnerId;
        LivingEntity entity = event.getEntity();
        boolean isPlayer = entity instanceof Player;
        if (isPlayer) {
            EntityDamageEvent.DamageCause cause = entity.getLastDamageCause() == null ? null : entity.getLastDamageCause().getCause();
            this.controller.info("* Processing death of " + entity.getName() + " from " + cause + " with drops: " + event.getDrops().size(), 15);
        }
        if ((spawnerId = EntityMetadataUtils.instance().getLong((Entity)entity, "automaton")) != null && (automaton = this.controller.getActiveAutomaton(spawnerId)) != null) {
            automaton.onSpawnDeath();
        }
        if (EntityMetadataUtils.instance().getBoolean((Entity)entity, "nodrops")) {
            event.setDroppedExp(0);
            event.getDrops().clear();
            if (isPlayer) {
                this.controller.info("** Player had nodrops tag!", 5);
            }
        } else {
            UndoList pendingUndo = this.controller.getEntityUndo((Entity)entity);
            if (pendingUndo != null && pendingUndo.isUndoType(entity.getType())) {
                event.getDrops().clear();
                if (isPlayer) {
                    this.controller.info("** Player was in undoEntityTypes list on death!", 5);
                }
            }
        }
        if ((damageEvent = event.getEntity().getLastDamageCause()) instanceof EntityDamageByEntityEvent && (damager = (dbe = (EntityDamageByEntityEvent)damageEvent).getDamager()) != null && (damagerMage = this.controller.getRegisteredMage(damager)) != null) {
            damagerMage.trigger("kill");
        }
        if ((mage = this.controller.getRegisteredMage((Entity)entity)) == null) {
            return;
        }
        mage.deactivateAllSpells();
        mage.onDeath(event);
        if (isPlayer) {
            this.controller.info("* Mage class handled death, drops now: " + event.getDrops().size(), 15);
        }
        if (event instanceof PlayerDeathEvent) {
            PlayerDeathEvent playerDeath = (PlayerDeathEvent)event;
            this.handlePlayerDeath(playerDeath.getEntity(), mage, playerDeath.getDrops(), playerDeath.getKeepInventory());
        }
    }

    @EventHandler
    public void onItemDespawn(ItemDespawnEvent event) {
        Item entity = event.getEntity();
        ItemStack itemStack = entity.getItemStack();
        if (Wand.isWand(itemStack)) {
            boolean immortal = this.controller.getWandProperty(itemStack, "immortal", false);
            if (immortal) {
                event.getEntity().setTicksLived(1);
                event.setCancelled(true);
            } else {
                this.controller.removeLostWand(Wand.getWandId(itemStack));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemSpawn(ItemSpawnEvent event) {
        if (this.disableItemSpawn || BlockData.undoing) {
            this.controller.info("*** Trying to spawn item but skipping due to disableItemSpawn?" + this.disableItemSpawn + " undoing?" + BlockData.undoing + ": " + TextUtils.nameItem(event.getEntity().getItemStack()), 18);
            event.setCancelled(true);
            return;
        }
        Item itemEntity = event.getEntity();
        ItemStack spawnedItem = itemEntity.getItemStack();
        if (InventoryUtils.isTemporary(spawnedItem)) {
            this.controller.info("*** Trying to drop a temporary item: " + TextUtils.nameItem(event.getEntity().getItemStack()), 18);
            event.setCancelled(true);
            return;
        }
        if (Wand.isSkill(spawnedItem)) {
            this.controller.info("*** Trying to drop a skill item: " + TextUtils.nameItem(event.getEntity().getItemStack()), 18);
            event.setCancelled(true);
            return;
        }
        if (Wand.isWand(spawnedItem)) {
            boolean trackWand;
            boolean invulnerable = this.controller.getWandProperty(spawnedItem, "invulnerable", false);
            if (invulnerable) {
                CompatibilityUtils.setInvulnerable((Entity)event.getEntity());
            }
            if (trackWand = this.controller.getWandProperty(spawnedItem, "track", false).booleanValue()) {
                Wand wand = this.controller.getWand(spawnedItem);
                this.controller.addLostWand(wand, event.getEntity().getLocation());
            }
        } else if (this.ageDroppedItems > 0) {
            int ticks = this.ageDroppedItems * 20 / 1000;
            Item item = event.getEntity();
            CompatibilityUtils.ageItem(item, ticks);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEntityDamage(EntityDamageEvent event) {
        Item item;
        ItemStack itemStack;
        Entity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (this.controller.isMagicNPC(event.getEntity())) {
            event.setCancelled(true);
            return;
        }
        Mage mage = this.controller.getRegisteredMage(entity);
        if (mage != null) {
            mage.onDamage(event);
        } else {
            Mage mountMage;
            Entity passenger = DeprecatedUtils.getPassenger(entity);
            Mage mage2 = mountMage = passenger == null ? null : this.controller.getRegisteredMage(passenger);
            if (mountMage != null) {
                mountMage.onDamage(event);
            }
        }
        if (this.checkSuperProtection(entity)) {
            event.setCancelled(true);
            return;
        }
        if (entity instanceof Item && Wand.isWand(itemStack = (item = (Item)entity).getItemStack())) {
            boolean invulnerable = this.controller.getWandProperty(itemStack, "invulnerable", false);
            if (invulnerable) {
                event.setCancelled(true);
            } else if (event.getDamage() >= (double)itemStack.getDurability()) {
                String wandId = Wand.getWandId(itemStack);
                this.controller.removeLostWand(wandId);
            }
        }
    }

    @EventHandler
    public void onEntityShootBow(EntityShootBowEvent event) {
        LivingEntity shooter = event.getEntity();
        Mage mage = this.controller.getRegisteredMage((Entity)shooter);
        if (mage == null || mage.isLaunchingProjectile()) {
            return;
        }
        mage.setLastBowPull(Math.max(0.0, Math.min(1.0, (double)event.getForce())));
        mage.setLastBowUsed(event.getBow());
    }

    public void checkArrowLaunch(Mage mage, Projectile projectile, ProjectileLaunchEvent event) {
        if (!mage.isPlayer()) {
            return;
        }
        if (!(projectile instanceof Arrow || projectile instanceof TippedArrow || projectile instanceof SpectralArrow)) {
            return;
        }
        Integer slot = mage.getArrowToLaunch();
        if (slot == null) {
            return;
        }
        ItemStack itemStack = mage.getItemInSlot(slot);
        mage.useArrow(itemStack, slot, event);
    }

    @EventHandler
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        EntityData entityData;
        if (event.isCancelled()) {
            return;
        }
        Projectile projectile = event.getEntity();
        ProjectileSource shooter = projectile.getShooter();
        if (!(shooter instanceof Entity)) {
            return;
        }
        Mage mage = this.controller.getRegisteredMage((Entity)shooter);
        if (mage != null) {
            if (mage.isLaunchingProjectile()) {
                return;
            }
            mage.setLastProjectileType(projectile.getType());
            if (mage.trigger("launch") && mage.isCancelLaunch()) {
                event.setCancelled(true);
            }
        }
        if ((entityData = this.controller.getMob((Entity)shooter)) != null && entityData.isPreventProjectiles()) {
            event.setCancelled(true);
            return;
        }
        if (mage == null) {
            return;
        }
        Wand wand = mage.getActiveWand();
        if (wand == null) {
            this.checkArrowLaunch(mage, projectile, event);
            return;
        }
        Material wandIcon = wand.getIcon().getMaterial();
        if (wandIcon != Material.BOW && !wandIcon.name().equals("CROSSBOW")) {
            return;
        }
        double minPull = wand.getDouble("cast_min_bowpull");
        double pull = mage.getLastBowPull();
        if (minPull > 0.0 && pull < minPull) {
            if (wand.isInventoryOpen()) {
                event.setCancelled(true);
            }
            return;
        }
        Spell spell = wand.getActiveSpell();
        if (spell == null) {
            if (wand.isInventoryOpen()) {
                event.setCancelled(true);
            }
            return;
        }
        event.setCancelled(true);
        try {
            wand.cast();
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.SEVERE, "Error casting bow spell", ex);
        }
    }
}

