/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.automata.Automaton;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.SelectionManager;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AutomatonSelectionManager
extends SelectionManager<Automaton> {
    public AutomatonSelectionManager(MagicController controller) {
        super(controller);
    }

    @Override
    @Nonnull
    public Collection<Automaton> getAll() {
        return this.controller.getAutomata();
    }

    @Override
    @Nonnull
    protected String getTypeNamePlural() {
        return "automata";
    }

    @Override
    protected void showListItem(CommandSender sender, Automaton automaton, SelectionManager.ListType listType) {
        String effectsKey;
        switch (listType) {
            case TARGET: {
                effectsKey = "blocktarget";
                break;
            }
            case SELECTED: {
                effectsKey = "blockselected";
                break;
            }
            case INACTIVE: {
                return;
            }
            default: {
                effectsKey = "blockitem";
            }
        }
        this.playEffects(sender, automaton, effectsKey);
    }

    @Override
    @Nullable
    protected Automaton getTarget(CommandSender sender, List<Automaton> sorted) {
        return sorted.isEmpty() ? null : sorted.get(0);
    }

    public void playEffects(CommandSender sender, Automaton automaton, String effectsKey) {
        int maxRangeSquared = 4096;
        if (sender instanceof Player) {
            double distance;
            Location location = ((Player)sender).getLocation();
            Location automatonLocation = automaton.getLocation();
            if (location.getWorld().equals(automatonLocation.getWorld()) && (distance = location.distanceSquared(automatonLocation)) < (double)maxRangeSquared) {
                this.controller.playEffects(effectsKey, location, automatonLocation);
            }
        }
    }
}

