/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.block.builtin;

import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.automata.Automaton;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import com.elmakers.mine.bukkit.world.BlockResult;
import com.elmakers.mine.bukkit.world.block.BlockRule;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Random;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class AutomatonRule
extends BlockRule {
    private MaterialSet replace;
    private Deque<WeightedPair<String>> automatonProbability = new ArrayDeque<WeightedPair<String>>();
    private ConfigurationSection parameters;

    @Override
    public boolean onLoad(ConfigurationSection parameters) {
        RandomUtils.populateStringProbabilityMap(this.automatonProbability, parameters, "automaton");
        this.parameters = parameters.getConfigurationSection("automaton_parameters");
        this.replace = this.controller.getMaterialSetManager().fromConfig(parameters.getString("replace"));
        this.logBlockRule("Creating automata " + StringUtils.join(RandomUtils.getValues(this.automatonProbability), (String)","));
        return !this.automatonProbability.isEmpty();
    }

    @Override
    @Nonnull
    public BlockResult onHandle(Block block, Random random, Player cause) {
        if (this.replace != null && !this.replace.testBlock(block)) {
            return BlockResult.SKIP;
        }
        String automatonKey = (String)RandomUtils.weightedRandom(this.automatonProbability);
        if (automatonKey.equalsIgnoreCase("none")) {
            return BlockResult.SKIP;
        }
        try {
            BlockResult result = BlockResult.valueOf(automatonKey.toUpperCase());
            return result;
        }
        catch (Exception result) {
            Mage mage = this.controller.getMage(cause);
            Location location = block.getLocation();
            Automaton automaton = this.controller.addAutomaton(location, automatonKey, mage.getId(), mage.getName(), this.parameters);
            String message = " automaton: " + automatonKey + " at " + location.getWorld().getName() + "," + location.toVector();
            message = automaton == null ? "Failed to create" + message : "Created" + message;
            this.controller.info(message);
            return automaton == null ? BlockResult.SKIP : BlockResult.REMOVE_DROPS;
        }
    }
}

