/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityExtraData;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import java.util.Arrays;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;

public class EntityVillagerData
extends EntityExtraData {
    protected Villager.Profession profession;
    protected boolean randomProfession;

    public EntityVillagerData() {
    }

    public EntityVillagerData(ConfigurationSection parameters, MageController controller) {
        String professionKey = parameters.getString("villager_profession");
        if (professionKey != null && !professionKey.isEmpty()) {
            if ((professionKey = professionKey.toUpperCase()).startsWith("RAND")) {
                this.randomProfession = true;
            } else {
                try {
                    this.profession = Villager.Profession.valueOf((String)professionKey);
                }
                catch (Exception ex) {
                    controller.getLogger().warning("Invalid villager_profession: " + professionKey);
                }
            }
        }
    }

    public EntityVillagerData(Villager villager) {
        this.profession = villager.getProfession();
        this.randomProfession = false;
    }

    @Override
    public void apply(Entity entity) {
        if (!(entity instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)entity;
        if (this.randomProfession) {
            Villager.Profession profession = RandomUtils.getRandom(Arrays.asList(Villager.Profession.values()), 1);
            villager.setProfession(profession);
        } else if (this.profession != null) {
            villager.setProfession(this.profession);
        }
    }
}

