/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.TriggerType;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageConversation;
import com.elmakers.mine.bukkit.magic.MobTrigger;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class EntityMageData {
    private static final String[] MAGE_PROPERTIES = new String[]{"protection", "weakness", "strength"};
    protected long tickInterval;
    protected long lifetime;
    @Nullable
    protected Multimap<String, MobTrigger> triggers;
    private final Set<String> triggering = new HashSet<String>();
    protected ConfigurationSection mageProperties;
    protected boolean requiresTarget;
    protected ItemData requiresWand;
    protected boolean aggro;
    protected double trackRadiusSquared;
    protected boolean isCancelLaunch = true;
    protected List<String> dialog;
    protected double dialogRadius;

    public EntityMageData(@Nonnull MageController controller, @Nonnull ConfigurationSection parameters) {
        Set triggerKeys;
        this.requiresWand = controller.getOrCreateItem(parameters.getString("cast_requires_item"));
        this.mageProperties = parameters.getConfigurationSection("mage");
        for (String mageProperty : MAGE_PROPERTIES) {
            ConfigurationSection mageConfig = parameters.getConfigurationSection(mageProperty);
            if (mageConfig == null) continue;
            if (this.mageProperties == null) {
                this.mageProperties = ConfigurationUtils.newConfigurationSection();
            }
            this.mageProperties.set(mageProperty, (Object)mageConfig);
        }
        this.lifetime = parameters.getInt("lifetime", 0);
        this.tickInterval = parameters.getLong("interval", parameters.getLong("cast_interval", 0L));
        this.requiresTarget = parameters.getBoolean("cast_requires_target", parameters.getBoolean("interval_requires_target", true));
        this.trackRadiusSquared = parameters.getDouble("track_radius", 128.0);
        this.trackRadiusSquared *= this.trackRadiusSquared;
        this.dialog = ConfigurationUtils.getStringList(parameters, "dialog");
        this.dialogRadius = parameters.getDouble("dialog_range", 3.0);
        int dialogInterval = parameters.getInt("dialog_interval", 2000);
        if (this.hasDialog()) {
            this.tickInterval = Math.max(this.tickInterval, (long)dialogInterval);
        }
        ConfigurationSection triggerConfig = parameters.getConfigurationSection("triggers");
        if (parameters.contains("cast")) {
            if (triggerConfig == null) {
                triggerConfig = ConfigurationUtils.newConfigurationSection();
            }
            ConfigurationSection castSection = triggerConfig.createSection("interval");
            castSection.set("cast", (Object)parameters.getConfigurationSection("cast"));
        }
        Set set = triggerKeys = triggerConfig == null ? null : triggerConfig.getKeys(false);
        if (triggerKeys != null) {
            this.triggers = ArrayListMultimap.create();
            for (String triggerKey : triggerKeys) {
                MobTrigger trigger = new MobTrigger(controller, triggerKey, triggerConfig.getConfigurationSection(triggerKey));
                this.triggers.put((Object)trigger.getTrigger(), (Object)trigger);
            }
        }
        if (this.triggers != null && this.tickInterval <= 0L && this.triggers.containsKey((Object)TriggerType.INTERVAL.name().toLowerCase())) {
            this.tickInterval = 1000L;
        }
        if (this.tickInterval < this.lifetime / 2L) {
            this.tickInterval = this.lifetime / 2L;
        }
        this.aggro = parameters.getBoolean("aggro", !this.isEmpty());
    }

    public boolean isEmpty() {
        boolean hasTriggers = this.triggers != null;
        boolean hasProperties = this.mageProperties != null;
        boolean hasLifetime = this.lifetime > 0L;
        return !hasProperties && !hasTriggers && !this.aggro && !hasLifetime && !this.hasDialog();
    }

    public boolean hasDialog() {
        return this.dialog != null && !this.dialog.isEmpty();
    }

    @Nullable
    private Collection<MobTrigger> getTriggers(TriggerType type) {
        return this.getTriggers(type.name());
    }

    @Nullable
    private Collection<MobTrigger> getTriggers(String type) {
        return this.triggers == null ? null : this.triggers.get((Object)type.toLowerCase());
    }

    public void resetTriggers() {
        this.triggering.clear();
    }

    public boolean trigger(com.elmakers.mine.bukkit.api.magic.Mage mage, String triggerKey) {
        if (this.triggering.contains(triggerKey)) {
            return false;
        }
        this.triggering.add(triggerKey);
        Collection<MobTrigger> triggers = this.getTriggers(triggerKey);
        if (triggers == null || triggers.isEmpty()) {
            return false;
        }
        boolean activated = false;
        this.isCancelLaunch = false;
        for (MobTrigger trigger : triggers) {
            if (trigger.execute(mage)) {
                this.isCancelLaunch = this.isCancelLaunch || trigger.isCancelLaunch();
            }
            activated = true;
        }
        return activated;
    }

    public void tick(com.elmakers.mine.bukkit.api.magic.Mage mage) {
        this.triggering.clear();
        if (this.lifetime > 0L && System.currentTimeMillis() > mage.getCreatedTime() + this.lifetime) {
            this.trigger(mage, "death");
            mage.getEntity().remove();
            return;
        }
        Collection<MobTrigger> intervalTriggers = this.getTriggers(TriggerType.INTERVAL);
        if (intervalTriggers != null) {
            LivingEntity li;
            ItemStack itemInHand;
            Creature creature;
            boolean isValid = true;
            LivingEntity entity = mage.getLivingEntity();
            Creature creature2 = creature = entity instanceof Creature ? (Creature)entity : null;
            if (this.requiresTarget && (creature == null || creature.getTarget() == null)) {
                isValid = false;
            }
            if (isValid && this.requiresWand != null && entity instanceof LivingEntity && ((itemInHand = (li = entity).getEquipment().getItemInMainHand()) == null || itemInHand.getType() != this.requiresWand.getType())) {
                isValid = false;
            }
            if (isValid) {
                for (MobTrigger trigger : intervalTriggers) {
                    trigger.execute(mage);
                }
            }
        }
        if (this.hasDialog() && mage instanceof Mage) {
            Entity entity;
            Mage speaker = (Mage)mage;
            HashMap<Player, MageConversation> conversations = speaker.getConversations();
            HashMap<Player, MageConversation> progress = conversations.isEmpty() ? conversations : new HashMap<Player, MageConversation>(conversations);
            conversations.clear();
            Location targetLocation = null;
            Collection nearby = mage.getLocation().getWorld().getNearbyEntities(mage.getLocation(), this.dialogRadius, this.dialogRadius, this.dialogRadius);
            for (Entity targetEntity : nearby) {
                if (!(targetEntity instanceof Player) || mage.getController().isNPC(targetEntity)) continue;
                Player targetPlayer = (Player)targetEntity;
                MageConversation conversation = (MageConversation)progress.get(targetPlayer);
                if (conversation == null) {
                    conversation = new MageConversation(speaker, targetPlayer);
                }
                conversation.sayNextLine(this.dialog);
                conversations.put(targetPlayer, conversation);
                if (targetLocation == null) {
                    targetLocation = targetPlayer.getLocation().clone();
                    continue;
                }
                targetLocation.add(targetPlayer.getLocation()).multiply(0.5);
            }
            if (targetLocation != null && (entity = mage.getEntity()) != null && entity.isValid()) {
                Location location = entity.getLocation();
                Vector direction = targetLocation.toVector().subtract(location.toVector());
                location.setDirection(direction);
                entity.teleport(location);
            }
        }
    }

    public double getTrackRadiusSquared() {
        return this.trackRadiusSquared;
    }
}

