/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action;

import com.elmakers.mine.bukkit.action.ActionHandlerContext;
import com.elmakers.mine.bukkit.api.action.ActionHandler;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MageModifier;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.VariableScope;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.effect.WandContext;
import com.elmakers.mine.bukkit.materials.MaterialSets;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class CastContext
extends WandContext
implements com.elmakers.mine.bukkit.api.action.CastContext {
    protected static Random random;
    private final WeakReference<Entity> entity;
    @Nullable
    private WeakReference<Entity> targetEntity;
    @Nullable
    private Location targetLocation;
    @Nullable
    private Location targetSourceLocation;
    @Nullable
    private Location targetCenterLocation;
    @Nullable
    private Block targetBlock;
    private Block previousBlock;
    private com.elmakers.mine.bukkit.api.block.UndoList undoList;
    private String targetName = null;
    private SpellResult result = SpellResult.NO_ACTION;
    private SpellResult initialResult = SpellResult.CAST;
    private SpellResult alternateResult = SpellResult.CAST;
    private Vector direction = null;
    private Boolean targetCaster = null;
    private long startTime;
    private ConfigurationSection workingParameters;
    private Map<String, Object> castData;
    private Set<UUID> targetMessagesSent = null;
    @Nonnull
    private Spell spell;
    private BaseSpell baseSpell;
    private BlockSpell blockSpell;
    private BrushSpell brushSpell;
    private TargetingSpell targetingSpell;
    private UndoableSpell undoSpell;
    private MaterialBrush brush;
    private CastContext base;
    private MageClass mageClass;
    private ConfigurationSection variables;
    private MaterialSet destructible;
    private MaterialSet indestructible;
    private List<ActionHandlerContext> handlers = null;
    private List<ActionHandlerContext> finishedHandlers = null;
    private Map<String, String> messageParameters = null;
    private ActionHandler rootHandler = null;
    private int workAllowed = 500;
    private int actionsPerformed;
    private boolean finished = false;

    public CastContext(@Nonnull MageSpell spell, @Nullable Wand wand) {
        super(spell.getMage(), wand);
        this.spell = this.setSpell(spell);
        this.location = null;
        this.entity = null;
        this.base = this;
        this.result = SpellResult.NO_ACTION;
        this.startTime = System.currentTimeMillis();
        this.targetMessagesSent = new HashSet<UUID>();
        this.messageParameters = new HashMap<String, String>();
    }

    public CastContext(@Nonnull MageSpell spell) {
        this(spell, spell.getMage().getActiveWand());
    }

    public CastContext(com.elmakers.mine.bukkit.api.action.CastContext copy) {
        this(copy, copy.getEntity(), copy instanceof CastContext ? ((CastContext)copy).location : null);
    }

    public CastContext(com.elmakers.mine.bukkit.api.action.CastContext copy, Mage sourceMage, Entity sourceEntity, Location sourceLocation) {
        super(sourceMage, sourceMage.getActiveWand());
        this.location = sourceLocation == null ? null : sourceLocation.clone();
        this.entity = sourceEntity == null ? null : new WeakReference<Entity>(sourceEntity);
        this.copyFrom(copy);
    }

    public CastContext(com.elmakers.mine.bukkit.api.action.CastContext copy, Entity sourceEntity, Location sourceLocation) {
        super(copy.getMage(), copy.getWand());
        this.location = sourceLocation == null ? null : sourceLocation.clone();
        this.entity = sourceEntity == null ? null : new WeakReference<Entity>(sourceEntity);
        this.copyFrom(copy);
    }

    protected void copyFrom(com.elmakers.mine.bukkit.api.action.CastContext copy) {
        this.spell = this.setSpell((MageSpell)copy.getSpell());
        this.setTargetEntity(copy.getTargetEntity());
        this.targetLocation = copy.getTargetLocation();
        if (this.targetLocation != null) {
            this.targetLocation = this.targetLocation.clone();
        }
        this.undoList = copy.getUndoList();
        this.targetName = copy.getTargetName();
        this.targetMessagesSent = copy.getTargetMessagesSent();
        this.currentEffects = copy.getCurrentEffects();
        this.result = copy.getResult();
        this.mageClass = copy.getMageClass();
        this.startTime = copy.getStartTime();
        this.workingParameters = copy.getWorkingParameters();
        this.rootHandler = copy.getRootHandler();
        Location centerLocation = copy.getTargetCenterLocation();
        if (centerLocation != null) {
            this.targetCenterLocation = centerLocation.clone();
        }
        if (copy instanceof CastContext) {
            this.variables = ((CastContext)copy).variables;
            this.base = ((CastContext)copy).base;
            this.initialResult = ((CastContext)copy).initialResult;
            this.alternateResult = ((CastContext)copy).alternateResult;
            this.direction = ((CastContext)copy).direction;
            this.messageParameters = ((CastContext)copy).messageParameters;
            this.targetCaster = ((CastContext)copy).targetCaster;
            this.brush = ((CastContext)copy).brush;
            this.previousBlock = ((CastContext)copy).previousBlock;
            this.destructible = ((CastContext)copy).destructible;
            this.indestructible = ((CastContext)copy).indestructible;
        } else {
            this.base = this;
        }
    }

    @Nonnull
    private MageSpell setSpell(MageSpell spell) {
        Preconditions.checkNotNull((Object)spell);
        this.spell = spell;
        MageClass mageClass = this.mageClass = this.wand == null ? this.mage.getActiveClass() : this.wand.getMageClass();
        if (spell instanceof BaseSpell) {
            this.baseSpell = (BaseSpell)spell;
        }
        if (spell instanceof UndoableSpell) {
            this.undoSpell = (UndoableSpell)spell;
        }
        if (spell instanceof TargetingSpell) {
            this.targetingSpell = (TargetingSpell)spell;
        }
        if (spell instanceof BlockSpell) {
            this.blockSpell = (BlockSpell)spell;
        }
        if (spell instanceof BrushSpell) {
            this.brushSpell = (BrushSpell)spell;
        }
        return spell;
    }

    public void initialize() {
        if (this.undoSpell != null) {
            this.undoList = this.undoSpell.createUndoList();
        }
    }

    @Override
    @Nullable
    public Location getCastLocation() {
        Location castLocation;
        if (this.location != null) {
            return this.location;
        }
        Location location = castLocation = this.wand == null ? null : this.wand.getLocation();
        if (castLocation == null) {
            Location location2 = castLocation = this.baseSpell != null ? this.baseSpell.getCastLocation() : this.getEyeLocation();
        }
        if (castLocation != null && this.direction != null) {
            castLocation.setDirection(this.direction);
        }
        return castLocation;
    }

    @Override
    public Location getEyeLocation() {
        if (this.location != null) {
            return this.location;
        }
        Entity entity = this.getContextEntity();
        if (entity != null) {
            if (entity instanceof LivingEntity) {
                return ((LivingEntity)entity).getEyeLocation();
            }
            return entity.getLocation();
        }
        return this.spell.getEyeLocation();
    }

    @Nullable
    protected Entity getContextEntity() {
        return this.entity == null ? null : (Entity)this.entity.get();
    }

    protected boolean hasContextEntity() {
        return this.entity != null;
    }

    @Override
    @Nullable
    public Entity getEntity() {
        if (this.hasContextEntity()) {
            return this.getContextEntity();
        }
        return this.spell.getEntity();
    }

    @Override
    @Nullable
    public LivingEntity getLivingEntity() {
        Entity entity = this.getEntity();
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    @Override
    @Nullable
    public Location getLocation() {
        if (this.location != null) {
            return this.location;
        }
        Entity entity = this.getContextEntity();
        if (entity != null) {
            return entity.getLocation();
        }
        return this.spell.getLocation();
    }

    @Nullable
    public Location getSelectedLocation() {
        if (this.targetingSpell == null) {
            return null;
        }
        return this.targetingSpell.getSelectedLocation();
    }

    @Override
    @Nullable
    public Location getTargetLocation() {
        return this.targetLocation;
    }

    @Override
    @Nullable
    public Location getTargetSourceLocation() {
        return this.targetSourceLocation == null ? this.targetLocation : this.targetSourceLocation;
    }

    @Override
    @Nullable
    public Block getTargetBlock() {
        if (this.targetBlock != null) {
            return this.targetBlock;
        }
        return this.targetLocation == null ? null : this.targetLocation.getBlock();
    }

    @Override
    @Nullable
    public Entity getTargetEntity() {
        return this.targetEntity == null ? null : (Entity)this.targetEntity.get();
    }

    @Override
    @Nullable
    public Vector getDirection() {
        if (this.direction != null) {
            return this.direction.clone();
        }
        Location location = this.getLocation();
        if (location == null) {
            return null;
        }
        return location.getDirection();
    }

    @Override
    public BlockFace getFacingDirection() {
        if (this.baseSpell != null) {
            return BaseSpell.getFacing(this.getLocation());
        }
        return BlockFace.UP;
    }

    @Override
    public void setDirection(Vector direction) {
        this.direction = direction;
    }

    @Override
    @Nullable
    public World getWorld() {
        Location location = this.getLocation();
        return location == null ? null : location.getWorld();
    }

    @Override
    public void setTargetEntity(Entity targetEntity) {
        this.targetEntity = new WeakReference<Entity>(targetEntity);
    }

    @Override
    public void setTargetLocation(Location targetLocation) {
        this.targetLocation = targetLocation;
    }

    @Override
    public void setTargetBlock(Block targetBlock) {
        this.targetBlock = targetBlock;
    }

    @Override
    public void setTargetSourceLocation(Location targetLocation) {
        this.targetSourceLocation = targetLocation;
    }

    @Override
    public Spell getSpell() {
        return this.spell;
    }

    @Override
    @Nullable
    public MageClass getMageClass() {
        return this.mageClass;
    }

    @Override
    @Nonnull
    public CasterProperties getActiveProperties() {
        if (this.wand != null) {
            return (CasterProperties)Verify.verifyNotNull((Object)this.wand);
        }
        return this.mage.getActiveProperties();
    }

    @Override
    public void registerForUndo(Runnable runnable) {
        this.addWork(1);
        if (this.undoList != null) {
            this.undoList.add(runnable);
        }
    }

    @Override
    public void registerForUndo(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.add(entity);
        }
    }

    @Override
    public void registerForUndo(Block block) {
        this.addWork(10);
        if (this.undoList != null) {
            this.undoList.add(block);
        }
    }

    @Override
    public void registerModified(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.modify(entity);
        }
    }

    @Override
    public void registerDamaged(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.damage(entity);
        }
    }

    @Override
    public void clearAttachables(Block block) {
        this.addWork(50);
        if (this.undoList != null) {
            this.undoList.clearAttachables(block);
        }
    }

    @Override
    public void updateBlock(Block block) {
        MageController controller = this.getController();
        controller.updateBlock(block);
    }

    @Override
    public void registerVelocity(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.modifyVelocity(entity);
        }
    }

    @Override
    public void registerMoved(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.move(entity);
        }
    }

    @Override
    public void registerPotionEffects(Entity entity) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.addPotionEffects(entity);
        }
    }

    @Override
    public void registerPotionEffectForRemoval(Entity entity, PotionEffectType effectType) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.addPotionEffectForRemoval(entity, effectType);
        }
    }

    @Override
    public void registerModifier(Entity entity, MageModifier modifier) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.addModifier(entity, modifier);
        }
    }

    @Override
    public void registerModifierForRemoval(Entity entity, String modifierKey) {
        this.addWork(5);
        if (this.undoList != null) {
            this.undoList.addModifierForRemoval(entity, modifierKey);
        }
    }

    @Override
    @Nullable
    public Block getPreviousBlock() {
        if (this.previousBlock != null) {
            return this.previousBlock;
        }
        return this.targetingSpell != null ? this.targetingSpell.getPreviousBlock() : null;
    }

    @Override
    @Nullable
    public Block getPreviousPreviousBlock() {
        return this.targetingSpell != null ? this.targetingSpell.getPreviousPreviousBlock() : null;
    }

    @Override
    public boolean isIndestructible(Block block) {
        if (this.indestructible != null) {
            return this.indestructible.testBlock(block);
        }
        return this.blockSpell != null ? this.blockSpell.isIndestructible(block) : true;
    }

    @Override
    public boolean hasBuildPermission(Block block) {
        return this.baseSpell != null ? this.baseSpell.hasBuildPermission(block) : false;
    }

    @Override
    public boolean hasBreakPermission(Block block) {
        return this.baseSpell != null ? this.baseSpell.hasBreakPermission(block) : false;
    }

    @Override
    public boolean hasEffects(String key) {
        return this.baseSpell != null ? this.baseSpell.hasEffects(key) : false;
    }

    private void multiplyParameter(String key, ConfigurationSection parameterMap, ConfigurationSection configuration, ConfigurationSection baseConfiguration) {
        String multiplyKey = key + "_multiplier";
        if (configuration.contains(multiplyKey)) {
            double baseValue = baseConfiguration != null ? (double)baseConfiguration.getInt(key) : 0.0;
            double value = configuration.getDouble(key, baseValue);
            double multiplier = configuration.getDouble(multiplyKey, 1.0);
            if (multiplier != 1.0) {
                value = multiplier * value;
            }
            parameterMap.set("$duration", (Object)value);
        }
    }

    private void addParameters(ConfigurationSection parameterMap, ConfigurationSection configuration, ConfigurationSection baseConfiguration) {
        if (configuration == null) {
            return;
        }
        Set keys = configuration.getKeys(false);
        for (String key : keys) {
            parameterMap.set("$" + key, configuration.get(key));
        }
        this.multiplyParameter("duration", parameterMap, configuration, baseConfiguration);
        this.multiplyParameter("damage", parameterMap, configuration, baseConfiguration);
    }

    @Override
    public Collection<EffectPlayer> getEffects(String effectKey) {
        Collection<EffectPlayer> effects = this.spell.getEffects(effectKey);
        if (effects.size() == 0) {
            return effects;
        }
        ConfigurationSection parameterMap = null;
        ConfigurationSection handlerParameters = this.spell.getHandlerParameters(effectKey);
        if (handlerParameters != null || this.workingParameters != null) {
            parameterMap = this.workingParameters != null ? ConfigurationUtils.cloneEmptyConfiguration(this.workingParameters) : ConfigurationUtils.cloneEmptyConfiguration(handlerParameters);
            this.addParameters(parameterMap, this.workingParameters, null);
            this.addParameters(parameterMap, handlerParameters, this.workingParameters);
        }
        for (EffectPlayer player : effects) {
            this.trackEffects(player);
            player.setMaterial(this.brush != null ? this.brush : this.spell.getEffectMaterial());
            player.setColor(this.getEffectColor());
            player.setParticleOverride(this.getEffectParticle());
            player.setParameterMap(parameterMap);
        }
        return effects;
    }

    @Override
    @Nullable
    public Color getEffectColor() {
        Color color;
        Color color2 = color = this.wand == null ? null : this.wand.getEffectColor();
        if (color == null) {
            color = this.spell.getEffectColor();
        }
        return color;
    }

    @Override
    @Nullable
    public String getEffectParticle() {
        String particle;
        String string = particle = this.wand == null ? null : this.wand.getEffectParticleName();
        if (particle == null) {
            particle = this.spell.getEffectParticle();
        }
        return particle;
    }

    @Override
    public void playEffects(String key) {
        this.playEffects(key, 1.0f);
    }

    @Override
    public void playEffects(String effectName, float scale) {
        this.playEffects(effectName, scale, null, this.getEntity(), null, this.getTargetEntity());
    }

    @Override
    public void playEffects(String effectName, float scale, Block sourceBlock) {
        this.playEffects(effectName, scale, null, this.getEntity(), null, this.getTargetEntity(), sourceBlock);
    }

    @Override
    public void playEffects(String effectName, float scale, Location sourceLocation, Entity sourceEntity, Location targetLocation, Entity targetEntity) {
        this.playEffects(effectName, scale, sourceLocation, sourceEntity, targetLocation, targetEntity, null);
    }

    @Override
    public void playEffects(String effectName, float scale, Location sourceLocation, Entity sourceEntity, Location targetLocation, Entity targetEntity, Block sourceBlock) {
        Collection<EffectPlayer> effects;
        if (targetEntity != null) {
            String entityKey = effectName + "_" + targetEntity.getType().name().toLowerCase();
            if (this.baseSpell != null && this.baseSpell.hasEffects(entityKey)) {
                effectName = entityKey;
            }
        }
        if ((effects = this.getEffects(effectName)).size() > 0) {
            Location location = this.getLocation();
            Collection<Entity> targeted = this.getTargetedEntities();
            for (EffectPlayer player : effects) {
                Location target;
                player.setScale(scale);
                player.setSelection(this.getSelectedLocation());
                Mage mage = this.getMage();
                Location source = sourceLocation;
                if (source == null) {
                    source = mage.getEntity() == sourceEntity && player.playsAtOrigin() ? player.getSourceLocation(this) : location;
                }
                if ((target = targetLocation) == null) {
                    target = player.getTargetLocation(this);
                }
                if (sourceBlock != null) {
                    player.setMaterial(sourceBlock);
                }
                player.start(source, sourceEntity, target, targetEntity, targeted);
            }
        }
    }

    @Override
    public String getMessage(String key, String def) {
        return this.baseSpell != null ? this.baseSpell.getMessage(key, def) : def;
    }

    @Override
    @Nullable
    public Location findPlaceToStand(Location target, int verticalSearchDistance, boolean goUp) {
        return this.baseSpell != null ? this.baseSpell.findPlaceToStand(target, goUp, verticalSearchDistance) : this.location;
    }

    @Override
    @Nullable
    public Location findPlaceToStand(Location targetLoc, int verticalSearchDistance) {
        return this.baseSpell != null ? this.baseSpell.findPlaceToStand(targetLoc, verticalSearchDistance, verticalSearchDistance) : this.location;
    }

    @Override
    public int getVerticalSearchDistance() {
        return this.baseSpell != null ? this.baseSpell.getVerticalSearchDistance() : 4;
    }

    @Override
    @Deprecated
    public boolean isOkToStandIn(Material material) {
        return this.baseSpell == null || this.baseSpell.isOkToStandIn(material);
    }

    @Override
    public boolean isOkToStandIn(Block block) {
        return this.baseSpell == null || this.baseSpell.isOkToStandIn(block);
    }

    @Override
    public boolean isWater(Material mat) {
        return DefaultMaterials.isWater(mat);
    }

    @Override
    @Deprecated
    public boolean isOkToStandOn(Material material) {
        return this.isOkToStandOn0(material);
    }

    @Override
    public boolean isOkToStandOn(Block block) {
        return this.isOkToStandOn0(block.getType());
    }

    private boolean isOkToStandOn0(Material material) {
        return material != Material.AIR && !DefaultMaterials.isLava(material);
    }

    @Override
    @Deprecated
    public boolean allowPassThrough(Material material) {
        return this.baseSpell == null || this.baseSpell.allowPassThrough(material);
    }

    @Override
    public boolean allowPassThrough(Block block) {
        return this.baseSpell == null || this.baseSpell.allowPassThrough(block);
    }

    @Override
    public void castMessageKey(String key, String message) {
        if (this.baseSpell != null) {
            this.baseSpell.castMessageKey(key, message);
        }
    }

    @Override
    public void castMessageKey(String key) {
        this.castMessageKey(key, null);
    }

    @Override
    public void sendMessageKey(String key, String message) {
        if (this.baseSpell != null) {
            this.baseSpell.sendMessageKey(this.mage, key, message);
        }
    }

    @Override
    public void sendMessageKey(String key) {
        this.sendMessageKey(key, null);
    }

    @Override
    public void showMessage(String key, String def) {
        Mage mage = this.getMage();
        mage.sendMessage(this.getMessage(key, def));
    }

    @Override
    public void showMessage(String message) {
        Mage mage = this.getMage();
        mage.sendMessage(message);
    }

    @Override
    public void castMessage(String message) {
        if (this.baseSpell != null) {
            this.baseSpell.castMessage(message);
        }
    }

    @Override
    public void sendMessage(String message) {
        if (this.baseSpell != null) {
            this.baseSpell.sendMessage(this.mage, message);
        }
    }

    @Override
    public void setTargetedLocation(Location location) {
        if (this.targetingSpell != null) {
            this.targetingSpell.setTarget(location);
        }
    }

    @Override
    public Block findBlockUnder(Block block) {
        if (this.targetingSpell != null) {
            block = this.targetingSpell.findBlockUnder(block);
        }
        return block;
    }

    @Override
    public Block findSpaceAbove(Block block) {
        if (this.targetingSpell != null) {
            block = this.targetingSpell.findSpaceAbove(block);
        }
        return block;
    }

    @Override
    @Deprecated
    public boolean isTransparent(Material material) {
        if (this.targetingSpell != null) {
            return this.targetingSpell.isTransparent(material);
        }
        return material.isTransparent();
    }

    @Override
    public boolean isTransparent(Block block) {
        if (this.targetingSpell != null) {
            return this.targetingSpell.isTransparent(block);
        }
        return block.getType().isTransparent();
    }

    @Override
    @Deprecated
    public boolean isPassthrough(Material material) {
        if (this.baseSpell != null) {
            return this.baseSpell.isPassthrough(material);
        }
        return material.isTransparent();
    }

    @Override
    public boolean isPassthrough(Block block) {
        if (this.baseSpell != null) {
            return this.baseSpell.isPassthrough(block);
        }
        return block.getType().isTransparent();
    }

    @Override
    public boolean isDestructible(Block block) {
        if (this.destructible != null) {
            return this.destructible.testBlock(block);
        }
        if (this.blockSpell != null) {
            return this.blockSpell.isDestructible(block);
        }
        return true;
    }

    @Override
    public boolean areAnyDestructible(Block block) {
        if (this.blockSpell != null) {
            return this.blockSpell.areAnyDestructible(block);
        }
        return true;
    }

    @Override
    public boolean isTargetable(Block block) {
        if (this.targetingSpell != null) {
            return this.targetingSpell.isTargetable(this, block);
        }
        return true;
    }

    @Override
    public TargetType getTargetType() {
        TargetType targetType = TargetType.NONE;
        if (this.targetingSpell != null) {
            targetType = this.targetingSpell.getTargetType();
        }
        return targetType;
    }

    @Override
    public boolean getTargetsCaster() {
        if (this.targetCaster != null) {
            return this.targetCaster;
        }
        if (this.baseSpell != null) {
            return this.baseSpell.getTargetsCaster();
        }
        return false;
    }

    @Override
    public void setTargetsCaster(boolean target) {
        this.targetCaster = target;
    }

    @Override
    public boolean isConsumeFree() {
        if (this.baseSpell != null) {
            return this.baseSpell.getConsumeReduction() >= 1.0f;
        }
        return false;
    }

    @Override
    public boolean canTarget(Entity entity) {
        return this.canTarget(entity, null);
    }

    @Override
    public boolean canTarget(Entity entity, Class<?> targetType) {
        if (!this.getTargetsCaster() && entity != null && this.getEntity() != null && this.getEntity().equals(entity)) {
            return false;
        }
        return this.targetingSpell == null ? true : this.targetingSpell.canTarget(entity, targetType);
    }

    @Override
    @Nullable
    public MaterialBrush getBrush() {
        if (this.brush == null && this.brushSpell != null) {
            MaterialBrush spellBrush = this.brushSpell.getBrush();
            this.brush = spellBrush == null ? null : spellBrush.getCopy();
        }
        return this.brush;
    }

    @Override
    public void setBrush(MaterialBrush brush) {
        this.brush = brush;
    }

    @Override
    public Collection<Entity> getTargetedEntities() {
        if (this.undoList == null) {
            return new ArrayList<Entity>();
        }
        return this.undoList.getAllEntities();
    }

    @Override
    public void messageTargets(String messageKey) {
        Mage mage = this.getMage();
        if (mage.isStealth()) {
            return;
        }
        Collection<Entity> targets = this.getTargetedEntities();
        if (targets == null || targets.isEmpty()) {
            return;
        }
        MageController controller = this.getController();
        LivingEntity sourceEntity = mage.getLivingEntity();
        String playerMessage = this.getMessage(messageKey);
        if (playerMessage.length() > 0) {
            playerMessage = this.parameterizeMessage(playerMessage);
            for (Entity target : targets) {
                UUID targetUUID = target.getUniqueId();
                if (!(target instanceof Player) || target == sourceEntity || this.targetMessagesSent.contains(targetUUID)) continue;
                this.targetMessagesSent.add(targetUUID);
                Mage targetMage = controller.getRegisteredMage(target);
                if (targetMage == null) continue;
                targetMage.sendMessage(playerMessage);
            }
        }
    }

    @Override
    @Nullable
    public Block getInteractBlock() {
        Location location = this.getEyeLocation();
        if (location == null) {
            return null;
        }
        Block playerBlock = location.getBlock();
        if (this.isTargetable(playerBlock)) {
            return playerBlock;
        }
        Vector direction = location.getDirection().normalize();
        return location.add(direction).getBlock();
    }

    @Override
    public Random getRandom() {
        if (random == null) {
            random = new Random();
        }
        return random;
    }

    @Override
    public com.elmakers.mine.bukkit.api.block.UndoList getUndoList() {
        return this.undoList;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public void setTargetName(String name) {
        this.targetName = name;
    }

    @Override
    public int getWorkAllowed() {
        return this.base.workAllowed;
    }

    @Override
    public void setWorkAllowed(int work) {
        this.base.workAllowed = work;
    }

    @Override
    public void addWork(int work) {
        this.base.workAllowed -= work;
    }

    @Override
    public void performedActions(int count) {
        this.base.actionsPerformed += count;
    }

    @Override
    public int getActionsPerformed() {
        return this.base.actionsPerformed;
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        Mage mage = this.getMage();
        if (this.finishedHandlers != null) {
            for (ActionHandlerContext context : this.finishedHandlers) {
                context.finish();
            }
            this.finishedHandlers = null;
        }
        if (this.handlers != null) {
            for (ActionHandlerContext context : this.handlers) {
                context.finish();
            }
            this.handlers = null;
        }
        if (this.undoSpell != null && this.undoSpell.isUndoable()) {
            if (!this.undoList.isScheduled()) {
                this.getController().update(this.undoList);
            }
            mage.registerForUndo(this.undoList);
        }
        this.result = this.result.max(this.initialResult);
        mage.sendDebugMessage(ChatColor.WHITE + "Finish " + ChatColor.GOLD + this.spell.getName() + ChatColor.WHITE + ": " + ChatColor.AQUA + this.result.name().toLowerCase(), 2);
        this.spell.finish(this);
        String resultName = this.result.name().toLowerCase();
        this.castMessageKey(resultName + "_finish");
        this.playEffects(resultName + "_finish");
    }

    @Override
    public void retarget(double range, double fov, double closeRange, double closeFOV, boolean useHitbox) {
        if (this.targetingSpell != null) {
            this.targetingSpell.retarget(this, range, fov, closeRange, closeFOV, useHitbox);
            this.setTargetEntity(this.targetingSpell.getTargetEntity());
            this.setTargetLocation(this.targetingSpell.getTargetLocation());
        }
    }

    @Override
    public void retarget(double range, double fov, double closeRange, double closeFOV, boolean useHitbox, int yOffset, boolean targetSpaceRequired, int targetMinOffset) {
        if (this.targetingSpell != null) {
            this.targetingSpell.retarget(range, fov, closeRange, closeFOV, useHitbox, yOffset, targetSpaceRequired, targetMinOffset);
            this.setTargetEntity(this.targetingSpell.getTargetEntity());
            this.setTargetLocation(this.targetingSpell.getTargetLocation());
        }
    }

    @Override
    public com.elmakers.mine.bukkit.api.action.CastContext getBaseContext() {
        return this.base;
    }

    @Override
    @Nullable
    public Location getTargetCenterLocation() {
        return this.targetCenterLocation == null ? this.targetLocation : this.targetCenterLocation;
    }

    @Override
    public void setTargetCenterLocation(Location location) {
        this.targetCenterLocation = location;
    }

    @Override
    public Set<UUID> getTargetMessagesSent() {
        return this.targetMessagesSent;
    }

    @Override
    @Nullable
    public Plugin getPlugin() {
        MageController controller = this.getController();
        return controller.getPlugin();
    }

    @Override
    public boolean teleport(Entity entity, Location location, int verticalSearchDistance, boolean preventFall) {
        return this.teleport(entity, location, verticalSearchDistance, preventFall, true);
    }

    @Override
    public boolean teleport(Entity entity, Location location, int verticalSearchDistance, boolean preventFall, boolean safe) {
        Location targetLocation;
        Chunk chunk = location.getBlock().getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
        }
        if ((targetLocation = this.findPlaceToStand(location, verticalSearchDistance)) == null && !preventFall) {
            Block block = location.getBlock();
            Block blockOneUp = block.getRelative(BlockFace.UP);
            if (!safe || this.isOkToStandIn(blockOneUp.getType()) && this.isOkToStandIn(block.getType())) {
                targetLocation = location;
            }
        }
        if (targetLocation != null) {
            targetLocation.setX(location.getX() - (double)location.getBlockX() + (double)targetLocation.getBlockX());
            targetLocation.setZ(location.getZ() - (double)location.getBlockZ() + (double)targetLocation.getBlockZ());
            this.registerMoved(entity);
            boolean isWorldChange = !targetLocation.getWorld().equals(entity.getWorld());
            entity.teleport(targetLocation);
            if (isWorldChange) {
                entity.teleport(targetLocation);
            }
        } else {
            this.castMessageKey("teleport_failed");
            this.playEffects("teleport_failed");
            return false;
        }
        this.setTargetLocation(targetLocation);
        this.castMessageKey("teleport");
        this.playEffects("teleport");
        return true;
    }

    @Override
    public boolean teleport(Entity entity, Location location, int verticalSearchDistance) {
        return this.teleport(entity, location, verticalSearchDistance, true);
    }

    @Override
    public void setSpellParameters(ConfigurationSection parameters) {
        if (this.baseSpell != null) {
            this.baseSpell.processParameters(parameters);
        }
    }

    @Override
    @Nullable
    @Deprecated
    public Set<Material> getMaterialSet(String key) {
        return MaterialSets.toLegacy(this.getController().getMaterialSetManager().fromConfig(key));
    }

    @Override
    public SpellResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(SpellResult result) {
        this.result = result;
    }

    @Override
    public void addResult(SpellResult result) {
        if (result != SpellResult.PENDING && result != SpellResult.NO_ACTION) {
            this.result = this.result.min(result);
        }
    }

    @Override
    public void setInitialResult(SpellResult result) {
        this.initialResult = result;
    }

    public SpellResult getInitialResult() {
        return this.initialResult;
    }

    public void setAlternateResult(SpellResult result) {
        this.alternateResult = result;
    }

    public SpellResult getAlternateResult() {
        return this.alternateResult;
    }

    @Override
    public boolean canCast(Location location) {
        if (this.baseSpell != null) {
            return this.baseSpell.canCast(location);
        }
        return true;
    }

    @Override
    public boolean canContinue(Location location) {
        if (this.baseSpell != null) {
            return this.baseSpell.canContinue(location);
        }
        return true;
    }

    @Override
    public boolean isBreakable(Block block) {
        return UndoList.getRegistry().isBreakable(block);
    }

    @Override
    @Nullable
    public Double getBreakable(Block block) {
        return UndoList.getRegistry().getBreakable(block);
    }

    @Override
    public void clearBreakable(Block block) {
        UndoList.getRegistry().unregisterBreakable(block);
    }

    @Override
    public void clearReflective(Block block) {
        UndoList.getRegistry().unregisterReflective(block);
    }

    @Override
    public boolean isReflective(Block block) {
        if (block == null) {
            return false;
        }
        if (this.targetingSpell != null && this.targetingSpell.isReflective(block)) {
            return true;
        }
        return UndoList.getRegistry().isReflective(block);
    }

    @Override
    @Nullable
    public Double getReflective(Block block) {
        if (block == null) {
            return null;
        }
        if (this.targetingSpell != null && this.targetingSpell.isReflective(block)) {
            return 1.0;
        }
        return UndoList.getRegistry().getReflective(block);
    }

    @Override
    public void registerBreakable(Block block, double breakable) {
        UndoList.getRegistry().registerBreakable(block, breakable);
        this.undoList.setUndoBreakable(true);
    }

    @Override
    public void registerReflective(Block block, double reflectivity) {
        UndoList.getRegistry().registerReflective(block, reflectivity);
        this.undoList.setUndoReflective(true);
    }

    @Override
    public double registerBreaking(Block block, double addAmount) {
        double breakAmount = UndoList.getRegistry().registerBreaking(block, addAmount);
        this.undoList.addDamage(block, addAmount);
        return breakAmount;
    }

    @Override
    public void registerFakeBlock(Block block, Collection<WeakReference<Player>> players) {
        this.undoList.registerFakeBlock(block, players);
    }

    @Override
    public void unregisterBreaking(Block block) {
        UndoList.getRegistry().unregisterBreaking(block);
    }

    @Override
    public String parameterizeMessage(String message) {
        return this.parameterize(message, "$");
    }

    @Override
    public String parameterize(String command) {
        return this.parameterize(command, "@");
    }

    private String parameterize(String command, String prefix) {
        Entity entity;
        Location targetLocation;
        Double value;
        if (command == null || command.isEmpty()) {
            return "";
        }
        Location location = this.getLocation();
        Mage mage = this.getMage();
        MageController controller = this.getController();
        ConfigurationSection variables = this.getAllVariables();
        ArrayList keys = new ArrayList(variables.getKeys(false));
        Collections.sort(keys, (o1, o2) -> o2.length() - o1.length());
        for (Iterator<Object> key : keys) {
            command = command.replace("$" + (String)((Object)key), variables.getString((String)((Object)key)));
        }
        for (Iterator<Object> key : keys) {
            command = command.replace("@" + (String)((Object)key), Integer.toString(variables.getInt((String)((Object)key))));
        }
        ArrayList<String> attributes = new ArrayList<String>(controller.getAttributes());
        Collections.sort(attributes, (o1, o2) -> o2.length() - o1.length());
        for (String string : attributes) {
            value = this.getAttribute(string);
            command = command.replace("$" + string, value == null ? "?" : Double.toString(value));
        }
        for (String string : attributes) {
            value = this.getAttribute(string);
            command = command.replace("@" + string, value == null ? "?" : Integer.toString((int)value.doubleValue()));
        }
        for (Map.Entry entry : this.messageParameters.entrySet()) {
            command = command.replace(prefix + (String)entry.getKey(), (CharSequence)entry.getValue());
        }
        command = mage.parameterize(command, prefix);
        command = command.replace(prefix + "spell", this.getSpell().getName());
        if (location != null) {
            command = command.replace(prefix + "world", location.getWorld().getName()).replace("$x", Double.toString(location.getX())).replace("$y", Double.toString(location.getY())).replace("$z", Double.toString(location.getZ())).replace("@x", Integer.toString(location.getBlockX())).replace("@y", Integer.toString(location.getBlockY())).replace("@z", Integer.toString(location.getBlockZ()));
        }
        if ((targetLocation = this.getTargetLocation()) != null) {
            command = command.replace(prefix + "tworld", targetLocation.getWorld().getName()).replace("$tx", Double.toString(targetLocation.getX())).replace("$ty", Double.toString(targetLocation.getY())).replace("$tz", Double.toString(targetLocation.getZ())).replace("@tx", Integer.toString(targetLocation.getBlockX())).replace("@ty", Integer.toString(targetLocation.getBlockY())).replace("@tz", Integer.toString(targetLocation.getBlockZ()));
        }
        if ((entity = this.getTargetEntity()) != null) {
            if (controller.isMage(entity)) {
                Mage targetMage = controller.getMage(entity);
                command = command.replace(prefix + "td", targetMage.getDisplayName()).replace(prefix + "tn", targetMage.getName()).replace(prefix + "tuuid", targetMage.getId()).replace(prefix + "t", targetMage.getName());
            } else {
                command = command.replace(prefix + "td", controller.getEntityDisplayName(entity)).replace(prefix + "tn", controller.getEntityName(entity)).replace(prefix + "tuuid", entity.getUniqueId().toString()).replace(prefix + "t", controller.getEntityName(entity));
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)command);
    }

    @Nullable
    public LivingEntity getTargetLivingEntity() {
        Entity entity = this.getTargetEntity();
        return entity != null && entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    @Nullable
    public Player getTargetPlayer() {
        Entity entity = this.getTargetEntity();
        return entity != null && entity instanceof Player ? (Player)entity : null;
    }

    @Nullable
    public Mage getTargetMage() {
        Entity entity = this.getTargetEntity();
        return entity == null ? null : this.controller.getRegisteredMage(entity);
    }

    @Override
    @Nullable
    public Double getAttribute(String attributeKey) {
        Double value = this.baseSpell.getAttribute(attributeKey);
        if (value != null) {
            return value;
        }
        switch (attributeKey) {
            case "target_health": {
                LivingEntity living = this.getTargetLivingEntity();
                return living == null ? null : Double.valueOf(living.getHealth());
            }
            case "target_health_max": {
                LivingEntity living = this.getTargetLivingEntity();
                return living == null ? null : Double.valueOf(CompatibilityUtils.getMaxHealth((Damageable)living));
            }
            case "target_air": {
                LivingEntity living = this.getTargetLivingEntity();
                return living == null ? null : Double.valueOf(living.getRemainingAir());
            }
            case "target_air_max": {
                LivingEntity living = this.getTargetLivingEntity();
                return living == null ? null : Double.valueOf(living.getMaximumAir());
            }
            case "target_hunger": {
                Player player = this.getTargetPlayer();
                return player == null ? null : Double.valueOf(player.getFoodLevel());
            }
            case "target_location_x": {
                Location location = this.getTargetLocation();
                return location == null ? null : Double.valueOf(location.getX());
            }
            case "target_location_y": {
                Location location = this.getTargetLocation();
                return location == null ? null : Double.valueOf(location.getY());
            }
            case "target_location_z": {
                Location location = this.getTargetLocation();
                return location == null ? null : Double.valueOf(location.getZ());
            }
            case "target_mana": {
                Mage targetMage = this.getTargetMage();
                return targetMage == null ? null : Double.valueOf(targetMage.getMana());
            }
            case "target_mana_max": {
                Mage targetMage = this.getTargetMage();
                return targetMage == null ? null : Double.valueOf(targetMage.getManaMax());
            }
        }
        return value;
    }

    @Override
    public void addHandler(ActionHandler handler) {
        if (this.base.handlers == null) {
            this.base.handlers = new ArrayList<ActionHandlerContext>();
        }
        this.base.handlers.add(new ActionHandlerContext(handler, this));
    }

    @Override
    public boolean hasHandlers() {
        return this.handlers != null;
    }

    @Override
    public SpellResult processHandlers() {
        SpellResult result = SpellResult.NO_ACTION;
        if (this.handlers == null) {
            return result;
        }
        if (this.finishedHandlers == null) {
            this.finishedHandlers = new ArrayList<ActionHandlerContext>();
        }
        int startingWork = this.getWorkAllowed();
        int splitWork = Math.max(1, startingWork / this.handlers.size());
        Iterator<ActionHandlerContext> iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            ActionHandlerContext handler = iterator.next();
            handler.setWorkAllowed(splitWork);
            SpellResult actionResult = handler.perform();
            if (actionResult == SpellResult.PENDING) continue;
            result = result.min(actionResult);
            this.finishedHandlers.add(handler);
            iterator.remove();
        }
        if (this.handlers.isEmpty()) {
            this.handlers = null;
            return result;
        }
        return SpellResult.PENDING;
    }

    @Override
    public void setPreviousBlock(Block block) {
        this.previousBlock = block;
    }

    @Override
    public void addMessageParameter(String key, String value) {
        this.messageParameters.put(key, value);
    }

    @Override
    public ConfigurationSection getAllVariables() {
        ConfigurationSection combinedVariables = ConfigurationUtils.newConfigurationSection();
        if (this.variables != null) {
            ConfigurationUtils.addConfigurations(combinedVariables, this.variables, false);
        }
        if (this.baseSpell != null) {
            ConfigurationUtils.addConfigurations(combinedVariables, this.baseSpell.getVariables(), false);
        }
        if (this.mage != null) {
            ConfigurationUtils.addConfigurations(combinedVariables, this.mage.getVariables(), false);
        }
        return combinedVariables;
    }

    @Override
    public ConfigurationSection getVariables() {
        if (this.variables == null) {
            this.variables = ConfigurationUtils.newConfigurationSection();
        }
        return this.variables;
    }

    @Override
    @Nonnull
    public ConfigurationSection getVariables(VariableScope scope) {
        switch (scope) {
            case SPELL: {
                return this.baseSpell == null ? this.getVariables() : this.baseSpell.getVariables();
            }
            case MAGE: {
                return this.mage == null ? this.getVariables() : this.mage.getVariables();
            }
        }
        return this.getVariables();
    }

    @Override
    @Nullable
    public Double getVariable(String variable) {
        ConfigurationSection mageVariables;
        ConfigurationSection spellVariables;
        if (this.variables != null && this.variables.contains(variable)) {
            return this.variables.getDouble(variable);
        }
        if (this.baseSpell != null && (spellVariables = this.baseSpell.getVariables()) != null && spellVariables.contains(variable)) {
            return spellVariables.getDouble(variable);
        }
        if (this.mage != null && (mageVariables = this.mage.getVariables()) != null && mageVariables.contains(variable)) {
            return mageVariables.getDouble(variable);
        }
        return null;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public ConfigurationSection getWorkingParameters() {
        return this.workingParameters;
    }

    public void setWorkingParameters(ConfigurationSection workingParameters) {
        this.workingParameters = workingParameters;
    }

    public void setRootHandler(ActionHandler handler) {
        this.rootHandler = handler;
    }

    @Override
    public ActionHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setCastData(@Nonnull String key, Object value) {
        if (this.castData == null) {
            this.castData = new HashMap<String, Object>();
        }
        this.castData.put(key, value);
    }

    @Override
    @Nullable
    public Object getCastData(@Nonnull String key) {
        return this.castData == null ? null : this.castData.get(key);
    }

    @Override
    public void setDestructible(MaterialSet destructible) {
        this.destructible = destructible;
    }

    @Override
    public void setIndestructible(MaterialSet indestructible) {
        this.indestructible = indestructible;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.spell.getName() + " of " + super.getName();
    }
}

