/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command.config;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.config.HttpGet;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;

public class FetchExampleRunnable
extends HttpGet {
    private final String exampleKey;

    public FetchExampleRunnable(MagicController controller, CommandSender sender, String exampleKey, String url) {
        super(controller, sender, url);
        this.exampleKey = exampleKey;
    }

    @Override
    public void processResponse(InputStream response) {
        byte[] buffer = new byte[2048];
        File examplesFolder = new File(this.controller.getPlugin().getDataFolder(), "examples");
        examplesFolder = new File(examplesFolder, this.exampleKey);
        ArrayList<String> messages = new ArrayList<String>();
        if (examplesFolder.exists()) {
            File backupFolder = new File(examplesFolder.getPath() + ".bak");
            if (backupFolder.exists()) {
                messages.add(this.controller.getMessages().get("commands.mconfig.example.fetch.overwrite_backup").replace("$backup", backupFolder.getName()));
                ConfigurationUtils.deleteDirectory(backupFolder);
                examplesFolder.renameTo(backupFolder);
            } else {
                messages.add(this.controller.getMessages().get("commands.mconfig.example.fetch.backup").replace("$backup", backupFolder.getName()));
                examplesFolder.renameTo(backupFolder);
            }
        }
        try (ZipInputStream zip = new ZipInputStream(response);){
            ZipEntry entry;
            boolean empty = true;
            boolean testedForRootFolder = false;
            String rootFolder = null;
            while ((entry = zip.getNextEntry()) != null) {
                File filePath;
                File folder;
                String entryName = entry.getName();
                if (!testedForRootFolder) {
                    testedForRootFolder = true;
                    if (entryName.contains("/")) {
                        rootFolder = StringUtils.split((String)entryName, (String)"/")[0] + "/";
                    }
                }
                if (entry.isDirectory()) continue;
                if (rootFolder != null) {
                    entryName = entryName.replace(rootFolder, "");
                }
                if ((folder = (filePath = new File(examplesFolder, entryName)).getParentFile()) != null) {
                    folder.mkdirs();
                }
                try (FileOutputStream fos = new FileOutputStream(filePath);
                     BufferedOutputStream outputBuffer = new BufferedOutputStream(fos, buffer.length);){
                    int len;
                    while ((len = zip.read(buffer)) > 0) {
                        outputBuffer.write(buffer, 0, len);
                        empty = false;
                    }
                }
            }
            if (empty) {
                throw new IllegalArgumentException("Empty zip file");
            }
        }
        catch (Exception ex) {
            this.fail(messages, this.controller.getMessages().get("commands.mconfig.example.fetch.error"), "Error reading zip file", ex);
            ex.printStackTrace();
            return;
        }
        try {
            response.close();
        }
        catch (IOException ex) {
            this.controller.getLogger().log(Level.WARNING, "Error closing http connection", ex);
        }
        File urlFile = new File(examplesFolder, "url.txt");
        if (urlFile.exists()) {
            messages.add(this.controller.getMessages().get("commands.mconfig.example.fetch.url_exists").replace("$example", this.exampleKey));
        } else {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(urlFile), StandardCharsets.UTF_8);){
                writer.write(this.url);
                messages.add(this.controller.getMessages().get("commands.mconfig.example.fetch.url_write").replace("$example", this.exampleKey));
            }
            catch (IOException ex) {
                messages.add(this.controller.getMessages().get("commands.mconfig.example.fetch.url_write_failed").replace("$example", this.exampleKey));
                this.controller.getLogger().log(Level.WARNING, "Error writing url file to example " + urlFile.getAbsolutePath(), ex);
            }
        }
        String message = this.controller.getMessages().get("commands.mconfig.example.fetch.success");
        message = message.replace("$url", this.url).replace("$example", this.exampleKey);
        this.success(messages, message);
    }
}

