/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.integration.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;

@Name(value="Cast")
@Description(value={"Cast a spell, from a player or the console"})
@Examples(value={"make player cast the spell \"fling\"", "cast \"day\""})
public class EffCast
extends Effect {
    private Expression<CommandSender> senders;
    private Expression<String> spell;
    private Expression<String> arguments;

    public static void register() {
        Skript.registerEffect(EffCast.class, (String[])new String[]{"cast [the] [spell] %string% [by %-commandsenders%] [with %-string%]", "(let|make) %commandsenders% cast [[the] spell] %string% [with %-string%]"});
    }

    protected void execute(Event event) {
        String[] parameters;
        String spellKey = (String)this.spell.getSingle(event);
        String parameterString = this.arguments == null ? null : (String)this.arguments.getSingle(event);
        String[] stringArray = parameters = parameterString == null ? null : StringUtils.split((String)parameterString, (char)' ');
        if (this.senders != null) {
            for (CommandSender sender : (CommandSender[])this.senders.getArray(event)) {
                MageSpell spell;
                if (sender == null || (spell = MagicPlugin.getAPI().getController().getMage(sender).getSpell(spellKey)) == null) continue;
                spell.cast(parameters);
            }
        } else {
            MageSpell spell = MagicPlugin.getAPI().getController().getMage((CommandSender)Bukkit.getConsoleSender()).getSpell(spellKey);
            if (spell != null) {
                spell.cast(parameters);
            }
        }
    }

    public String toString(Event event, boolean debug) {
        String parameters = "";
        if (this.arguments != null) {
            parameters = " with parameters " + this.arguments.toString(event, debug);
        }
        return "make " + (this.senders != null ? this.senders.toString(event, debug) : "the console") + " cast the spell " + this.spell.toString(event, debug) + parameters;
    }

    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (matchedPattern == 0) {
            this.spell = vars[0];
            this.senders = vars[1];
        } else {
            this.senders = vars[0];
            this.spell = vars[1];
        }
        this.arguments = vars[2];
        return true;
    }
}

