/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseProjectileAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.magic.SourceLocation;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.EntityMetadataUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class ProjectileAction
extends BaseProjectileAction {
    private int defaultSize = 1;
    private int count;
    private int size;
    private double damage;
    private float speed;
    private float spread;
    private boolean useFire;
    private boolean breakBlocks;
    private int tickIncrease;
    private String projectileTypeName;
    private int startDistance;
    private SourceLocation sourceLocation;
    private String pickupStatus;
    private String color;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.breakBlocks = parameters.getBoolean("break_blocks", false);
        this.useFire = parameters.getBoolean("fire", false);
    }

    @Override
    public boolean requiresBuildPermission() {
        return this.useFire;
    }

    @Override
    public boolean requiresBreakPermission() {
        return this.breakBlocks;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.track = true;
        super.prepare(context, parameters);
        this.count = parameters.getInt("count", 1);
        this.size = parameters.getInt("size", this.defaultSize);
        this.damage = parameters.getDouble("damage", 0.0);
        this.damage = parameters.getDouble("arrow_damage", this.damage);
        this.speed = (float)parameters.getDouble("speed", (double)0.6f);
        this.spread = (float)parameters.getDouble("spread", 12.0);
        this.useFire = parameters.getBoolean("fire", false);
        this.tickIncrease = parameters.getInt("tick_increase", 1180);
        this.projectileTypeName = parameters.getString("projectile", "TippedArrow");
        this.breakBlocks = parameters.getBoolean("break_blocks", false);
        this.startDistance = parameters.getInt("start", 0);
        this.pickupStatus = parameters.getString("pickup", "disallowed");
        this.color = parameters.getString("color");
        this.sourceLocation = new SourceLocation(parameters);
    }

    @Override
    public SpellResult start(CastContext context) {
        MageController controller = context.getController();
        Mage mage = context.getMage();
        int size = (int)(mage.getRadiusMultiplier() * (float)this.size);
        double damageMultiplier = mage.getDamageMultiplier("projectile");
        double damage = damageMultiplier * this.damage;
        float radiusMultiplier = mage.getRadiusMultiplier();
        float spread = this.spread;
        if (radiusMultiplier > 1.0f) {
            spread /= radiusMultiplier;
        }
        Random random = context.getRandom();
        Class<?> projectileType = NMSUtils.getBukkitClass("net.minecraft.server.Entity" + this.projectileTypeName);
        if (!CompatibilityUtils.isValidProjectileClass(projectileType)) {
            controller.getLogger().warning("Bad projectile class: " + this.projectileTypeName);
            return SpellResult.FAIL;
        }
        Location location = this.sourceLocation.getLocation(context);
        Vector direction = location.getDirection();
        if (this.startDistance > 0) {
            location = location.clone().add(direction.clone().multiply(this.startDistance));
        }
        LivingEntity shootingEntity = context.getLivingEntity();
        LivingEntity source = null;
        if (shootingEntity != null) {
            source = shootingEntity;
        }
        mage.setLaunchingProjectile(true);
        for (int i = 0; i < this.count; ++i) {
            try {
                Projectile projectile = CompatibilityUtils.spawnProjectile(projectileType, location, direction, (ProjectileSource)source, this.speed, spread, i > 0 ? spread : 0.0f, random);
                if (projectile == null) {
                    return SpellResult.FAIL;
                }
                if (shootingEntity != null) {
                    projectile.setShooter((ProjectileSource)shootingEntity);
                }
                if (projectile instanceof ThrownPotion && this.color != null && !this.color.isEmpty()) {
                    ThrownPotion potion = (ThrownPotion)projectile;
                    if (this.color.startsWith("#")) {
                        this.color = this.color.substring(1);
                    }
                    try {
                        Color potionColor = Color.fromRGB((int)Integer.parseInt(this.color, 16));
                        ItemStack itemStack = new ItemStack(Material.SPLASH_POTION);
                        ItemMeta meta = itemStack.getItemMeta();
                        if (meta != null && meta instanceof PotionMeta) {
                            CompatibilityUtils.setColor((PotionMeta)meta, potionColor);
                            itemStack.setItemMeta(meta);
                            potion.setItem(itemStack);
                        }
                    }
                    catch (Exception ex) {
                        context.getLogger().warning("Invalid potion color in Projectile action: " + this.color);
                    }
                }
                if (projectile instanceof Fireball) {
                    Fireball fireball = (Fireball)projectile;
                    fireball.setIsIncendiary(this.useFire);
                    fireball.setYield((float)size);
                }
                if (projectile instanceof Arrow) {
                    Arrow arrow = (Arrow)projectile;
                    if (this.useFire) {
                        arrow.setFireTicks(300);
                    }
                    if (damage > 0.0) {
                        CompatibilityUtils.setDamage(projectile, damage);
                    }
                    if (this.tickIncrease > 0) {
                        CompatibilityUtils.decreaseLifespan(projectile, this.tickIncrease);
                    }
                    if (this.pickupStatus != null && !this.pickupStatus.isEmpty()) {
                        CompatibilityUtils.setPickupStatus(arrow, this.pickupStatus);
                    }
                }
                if (!this.breakBlocks) {
                    EntityMetadataUtils.instance().setBoolean((Entity)projectile, "cancel_explosion", true);
                }
                this.track(context, (Entity)projectile);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        mage.setLaunchingProjectile(false);
        return this.checkTracking(context);
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("count");
        parameters.add("size");
        parameters.add("damage");
        parameters.add("speed");
        parameters.add("spread");
        parameters.add("start");
        parameters.add("projectile");
        parameters.add("fire");
        parameters.add("tick_increase");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("undo_interval")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_DURATIONS));
        } else if (parameterKey.equals("count") || parameterKey.equals("size") || parameterKey.equals("speed") || parameterKey.equals("spread") || parameterKey.equals("tick_increase") || parameterKey.equals("damage") || parameterKey.equals("start")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else if (parameterKey.equals("fire")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("projectile")) {
            examples.add("LargeFireball");
            examples.add("SmallFireball");
            examples.add("WitherSkull");
            examples.add("TippedArrow");
            examples.add("SpectralArrow");
            examples.add("Snowball");
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

