/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.world.BlockResult;
import com.elmakers.mine.bukkit.world.block.MagicBlockHandler;
import com.elmakers.mine.bukkit.world.populator.MagicChunkHandler;
import com.elmakers.mine.bukkit.world.spawn.MagicSpawnHandler;
import com.elmakers.mine.bukkit.world.tasks.CheckWorldCreateTask;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MagicWorld {
    private final MagicController controller;
    private final MagicChunkHandler chunkHandler;
    private final MagicSpawnHandler spawnHandler;
    private final MagicBlockHandler blockPlaceHandler;
    private final MagicBlockHandler blockBreakHandler;
    private String copyFrom = "";
    private boolean autoLoad = false;
    private boolean cancelSpellsOnSave = true;
    private World.Environment worldEnvironment = World.Environment.NORMAL;
    private World.Environment appearanceEnvironment = null;
    private WorldType worldType = WorldType.NORMAL;
    private String worldName;
    private String resourcePack;
    private long seed;
    private boolean synchronizeTime = true;
    private long synchronizedTimeOffset = 0L;
    private static Random random = new Random();
    private WorldState state = WorldState.UNLOADED;
    private Integer maxHeight;

    public MagicWorld(MagicController controller) {
        this.controller = controller;
        this.seed = random.nextLong();
        this.chunkHandler = new MagicChunkHandler(controller);
        this.spawnHandler = new MagicSpawnHandler(controller);
        this.blockPlaceHandler = new MagicBlockHandler(controller);
        this.blockBreakHandler = new MagicBlockHandler(controller);
    }

    public void load(String name, ConfigurationSection config) {
        String typeString;
        this.worldName = name;
        if (config.contains("max_height")) {
            this.maxHeight = config.getInt("max_height");
        }
        this.copyFrom = config.getString("copy", this.copyFrom);
        this.synchronizeTime = config.getBoolean("synchronize_time", this.synchronizeTime);
        this.synchronizedTimeOffset = config.getLong("time_offset", this.synchronizedTimeOffset);
        this.resourcePack = config.getString("resource_pack", this.resourcePack);
        if (config.contains("environment")) {
            typeString = config.getString("environment");
            try {
                this.worldEnvironment = World.Environment.valueOf((String)typeString.toUpperCase());
            }
            catch (Exception ex) {
                this.controller.getLogger().warning("Invalid world environment: " + typeString);
            }
        }
        if (config.contains("appearance")) {
            typeString = config.getString("appearance");
            try {
                this.appearanceEnvironment = World.Environment.valueOf((String)typeString.toUpperCase());
            }
            catch (Exception ex) {
                this.controller.getLogger().warning("Invalid world appearance: " + typeString);
            }
        }
        if (config.contains("type")) {
            typeString = config.getString("type");
            try {
                this.worldType = WorldType.valueOf((String)typeString.toUpperCase());
            }
            catch (Exception ex) {
                this.controller.getLogger().warning("Invalid world type: " + typeString);
            }
        }
        this.seed = config.getLong("seed", this.seed);
        this.autoLoad = config.getBoolean("autoload", this.autoLoad);
        this.chunkHandler.load(this.worldName, config.getConfigurationSection("chunk_generate"));
        this.blockBreakHandler.load(this.worldName, "break", config.getConfigurationSection("block_break"));
        this.blockPlaceHandler.load(this.worldName, "place", config.getConfigurationSection("block_place"));
        this.spawnHandler.load(this.worldName, config.getConfigurationSection("entity_spawn"));
        this.cancelSpellsOnSave = config.getBoolean("cancel_spells_on_save", this.cancelSpellsOnSave);
    }

    public void finalizeLoad() {
        if (this.autoLoad) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.controller.getPlugin(), (Runnable)new CheckWorldCreateTask(this), 1L);
        }
        this.spawnHandler.finalizeLoad();
    }

    public void checkWorldCreate() {
        if (this.state != WorldState.UNLOADED) {
            return;
        }
        if (this.copyFrom.isEmpty()) {
            this.createWorld();
        } else {
            World targetWorld = this.controller.getPlugin().getServer().getWorld(this.copyFrom);
            if (targetWorld != null) {
                this.copyWorld(targetWorld);
            }
        }
    }

    public void createWorld() {
        this.state = WorldState.LOADING;
        World world = Bukkit.getWorld((String)this.worldName);
        if (world == null) {
            this.controller.info("Loading " + this.worldName + " as " + this.worldEnvironment + " (" + this.worldType + ")");
            WorldCreator worldCreator = WorldCreator.name((String)this.worldName);
            worldCreator.seed(this.seed);
            worldCreator.environment(this.worldEnvironment);
            worldCreator.type(this.worldType);
            worldCreator.generateStructures(true);
            try {
                world = worldCreator.createWorld();
            }
            catch (Exception ex) {
                world = null;
                ex.printStackTrace();
            }
            if (world == null) {
                this.controller.getLogger().warning("Failed to create world: " + this.worldName);
            }
        }
        if (world != null && this.appearanceEnvironment != null) {
            NMSUtils.setEnvironment(world, this.appearanceEnvironment);
            this.controller.info("Changed " + this.worldName + " appearance to " + this.appearanceEnvironment);
        }
    }

    public void installPopulators(World world) {
        if (this.chunkHandler.isEmpty()) {
            return;
        }
        this.controller.info("Installing Populators in " + world.getName());
        world.getPopulators().addAll(this.chunkHandler.getPopulators());
    }

    public boolean processEntitySpawn(Plugin plugin, LivingEntity entity) {
        return this.spawnHandler.process(plugin, entity);
    }

    public BlockResult processBlockBreak(Block block, Player player) {
        return this.blockBreakHandler.handleBlock(block, player);
    }

    public BlockResult processBlockPlace(Block block, Player player) {
        return this.blockPlaceHandler.handleBlock(block, player);
    }

    public void onWorldInit(World initWorld) {
        if (initWorld.getName().equals(this.worldName)) {
            this.state = WorldState.LOADED;
            this.updateTime();
            return;
        }
        if (this.state != WorldState.UNLOADED) {
            return;
        }
        this.copyWorld(initWorld);
    }

    public void copyWorld(World targetWorld) {
        if (this.copyFrom.isEmpty() || !targetWorld.getName().equals(this.copyFrom)) {
            return;
        }
        this.state = WorldState.LOADING;
        World world = Bukkit.getWorld((String)this.worldName);
        if (world == null) {
            this.controller.info("Loading " + this.worldName + " using settings copied from " + targetWorld.getName());
            world = Bukkit.createWorld((WorldCreator)new WorldCreator(this.worldName).copy(targetWorld));
            if (world == null) {
                this.controller.getLogger().warning("Failed to create world: " + this.worldName);
            } else if (this.appearanceEnvironment != null) {
                NMSUtils.setEnvironment(world, this.appearanceEnvironment);
                this.controller.info("Changed " + this.worldName + " appearance to " + this.appearanceEnvironment);
            }
        }
    }

    public void playerEntered(Player player) {
        if (this.resourcePack != null) {
            player.setResourcePack(this.resourcePack);
        }
    }

    public void updateTime() {
        this.updateTimeFrom(null, 0L);
    }

    public boolean updateTimeFrom(World changedWorld, long skipAmount) {
        if (!this.synchronizeTime || this.copyFrom.isEmpty() || this.state != WorldState.LOADED) {
            return true;
        }
        if (changedWorld != null && this.worldName.equals(changedWorld.getName())) {
            return false;
        }
        if (changedWorld == null) {
            changedWorld = Bukkit.getWorld((String)this.copyFrom);
        } else if (!changedWorld.getName().equals(this.copyFrom)) {
            return true;
        }
        if (changedWorld == null) {
            return true;
        }
        World world = Bukkit.getWorld((String)this.worldName);
        if (world != null) {
            world.setTime(changedWorld.getTime() + this.synchronizedTimeOffset + skipAmount);
        }
        return true;
    }

    public boolean isCancelSpellsOnSave() {
        return this.cancelSpellsOnSave;
    }

    public int getMaxHeight(int defaultHeight) {
        return this.maxHeight != null ? this.maxHeight : defaultHeight;
    }

    private static enum WorldState {
        UNLOADED,
        LOADING,
        LOADED;

    }
}

