/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class GotoSpell
extends UndoableSpell {
    LivingEntity targetEntity = null;
    int playerIndex = 0;
    private Color effectColor = null;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        String playerName;
        boolean allowSelection;
        Player player = this.mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        this.effectColor = this.mage.getEffectColor();
        if (this.effectColor == null) {
            this.effectColor = Color.fromRGB((int)Integer.parseInt(parameters.getString("effect_color", "FF0000"), 16));
        }
        boolean bl = allowSelection = parameters.getBoolean("allow_selection", false) || this.mage.isSuperPowered();
        if (this.targetEntity != null) {
            if (!allowSelection || !this.targetEntity.isValid() || this.targetEntity.isDead()) {
                this.releaseTarget();
            }
            if (this.isSuperProtected((Entity)this.targetEntity)) {
                this.releaseTarget();
            }
        }
        if (!allowSelection) {
            Location location = this.getLocation();
            ArrayList<Target> allTargets = new ArrayList<Target>();
            List players = player.getWorld().getPlayers();
            for (Player targetPlayer : players) {
                if (targetPlayer == player || targetPlayer.hasPotionEffect(PotionEffectType.INVISIBILITY) || !this.canTarget((Entity)targetPlayer)) continue;
                allTargets.add(new Target(location, (Entity)targetPlayer, 512, Math.PI));
            }
            if (allTargets.size() == 0) {
                return SpellResult.NO_TARGET;
            }
            this.registerMoved((Entity)player);
            this.registerForUndo();
            Collections.sort(allTargets);
            Entity targetEntity = ((Target)allTargets.get(0)).getEntity();
            this.getCurrentTarget().setEntity(targetEntity);
            this.registerModified((Entity)player);
            this.teleportTo((Entity)player, targetEntity);
            this.castMessageKey("cast_to_player", this.getMessage("cast_to_player").replace("$target", this.controller.getEntityDisplayName(targetEntity)));
            return SpellResult.CAST;
        }
        if (!this.isLookingUp() && !this.isLookingDown()) {
            Target target = this.getTarget();
            if (this.targetEntity != null) {
                if (this.isSuperProtected((Entity)this.targetEntity)) {
                    return SpellResult.NO_TARGET;
                }
                return this.teleportTarget(target.getLocation()) ? SpellResult.CAST : SpellResult.NO_TARGET;
            }
            if (!target.hasEntity() || !(target.getEntity() instanceof LivingEntity)) {
                return SpellResult.NO_TARGET;
            }
            this.selectTarget((LivingEntity)target.getEntity());
            this.activate();
            return SpellResult.TARGET_SELECTED;
        }
        if (this.isLookingUp() && this.targetEntity != null) {
            this.getCurrentTarget().setEntity((Entity)this.targetEntity);
            this.registerModified((Entity)player);
            this.teleportTo((Entity)player, (Entity)this.targetEntity);
            this.castMessageKey("cast_to_player", this.getMessage("cast_to_player").replace("$target", this.controller.getEntityDisplayName((Entity)this.targetEntity)));
            this.releaseTarget();
            this.registerForUndo();
            return SpellResult.CAST;
        }
        ArrayList<String> playerNames = new ArrayList<String>(this.controller.getPlayerNames());
        if (playerNames.size() == 1) {
            return SpellResult.NO_TARGET;
        }
        if (this.playerIndex < 0) {
            this.playerIndex = playerNames.size() - 1;
        }
        if (this.playerIndex >= playerNames.size()) {
            this.playerIndex = 0;
        }
        if ((playerName = (String)playerNames.get(this.playerIndex)).equals(player.getName())) {
            this.playerIndex = (this.playerIndex + 1) % playerNames.size();
            playerName = (String)playerNames.get(this.playerIndex);
        }
        ++this.playerIndex;
        Player targetPlayer = DeprecatedUtils.getPlayer(playerName);
        if (targetPlayer == null) {
            return SpellResult.NO_TARGET;
        }
        this.selectTarget((LivingEntity)targetPlayer);
        this.activate();
        return SpellResult.TARGET_SELECTED;
    }

    protected boolean teleportTarget(Location location) {
        if (this.targetEntity == null || location == null) {
            return false;
        }
        this.registerMoved((Entity)this.targetEntity);
        location.setY(location.getY() + 1.0);
        this.targetEntity.teleport(location);
        this.getCurrentTarget().setEntity((Entity)this.targetEntity);
        this.registerForUndo();
        return true;
    }

    protected void teleportTo(Entity sourceEntity, Entity targetEntity) {
        Location targetLocation = targetEntity.getLocation();
        BlockFace targetFacing = GotoSpell.getFacing(targetEntity.getLocation());
        Location candidate = this.findPlaceToStand(targetLocation.getBlock().getRelative(targetFacing).getRelative(targetFacing).getLocation(), 4, 4);
        if (candidate != null) {
            candidate.setPitch(0.0f);
            candidate.setYaw(360.0f - targetLocation.getYaw());
            targetLocation = candidate;
        }
        sourceEntity.teleport(targetLocation);
    }

    protected void selectTarget(LivingEntity entity) {
        this.releaseTarget();
        this.targetEntity = entity;
        this.getCurrentTarget().setEntity((Entity)entity);
    }

    protected void releaseTarget() {
        this.targetEntity = null;
    }

    @Override
    public void onDeactivate() {
        this.releaseTarget();
    }

    @Override
    public boolean onCancelSelection() {
        return this.targetEntity != null;
    }
}

