/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.item;

import com.elmakers.mine.bukkit.api.item.ItemUpdatedCallback;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.item.InvalidMaterialException;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

public class ItemData
implements com.elmakers.mine.bukkit.api.item.ItemData,
ItemUpdatedCallback {
    public static final String MINECRAFT_ITEM_PREFIX = "minecraft:";
    public static double EARN_SCALE = 0.5;
    private final MageController controller;
    private String key;
    private String materialKey;
    private ItemStack item;
    private double worth;
    private Double earns;
    private Set<String> categories = ImmutableSet.of();
    private String creatorId;
    private String creator;
    private boolean locked;
    private boolean loaded;
    private boolean replaceOnEquip;
    private List<PendingUpdate> pending = null;

    public ItemData(ItemStack itemStack, MageController controller) {
        this.controller = controller;
        this.item = NMSUtils.getCopy(itemStack);
        this.key = itemStack.getType().toString();
        this.locked = Wand.getLockKey(itemStack) != null;
    }

    public ItemData(String materialKey, MageController controller) {
        this(materialKey, materialKey, controller);
    }

    public ItemData(String key, String materialKey, MageController controller) {
        this.controller = controller;
        this.key = key;
        this.materialKey = materialKey;
    }

    public ItemData(String key, ConfigurationSection configuration, MageController controller) throws InvalidMaterialException {
        List lore;
        String customName;
        ConfigurationSection tagSection;
        this.controller = controller;
        if (configuration.isItemStack("item")) {
            this.item = configuration.getItemStack("item");
        } else if (configuration.isConfigurationSection("item")) {
            ConfigurationSection itemConfiguration = configuration.getConfigurationSection("item");
            String materialKey = itemConfiguration.getString("type", key);
            MaterialAndData material = new MaterialAndData(materialKey = ItemData.cleanMinecraftItemName(materialKey));
            if (material.isValid()) {
                this.item = material.getItemStack(1);
            }
            if (this.item == null) {
                throw new InvalidMaterialException("Invalid item key: " + materialKey);
            }
            ConfigurationSection tagSection2 = itemConfiguration.getConfigurationSection("tags");
            if (tagSection2 != null) {
                this.item = CompatibilityUtils.makeReal(this.item);
                InventoryUtils.saveTagsToItem(tagSection2, this.item);
            }
        } else {
            String materialKey = configuration.getString("item", key);
            MaterialAndData material = new MaterialAndData(materialKey = ItemData.cleanMinecraftItemName(materialKey));
            if (material.isValid()) {
                this.item = material.getItemStack(1);
            }
            if (this.item == null) {
                throw new InvalidMaterialException("Invalid item key: " + materialKey);
            }
        }
        if (this.item == null) {
            throw new InvalidMaterialException("Invalid item configuration: " + key);
        }
        this.key = key;
        this.materialKey = key;
        this.worth = configuration.getDouble("worth", 0.0);
        this.earns = configuration.contains("earns") ? Double.valueOf(configuration.getDouble("earns")) : null;
        this.creator = configuration.getString("creator");
        this.creatorId = configuration.getString("creator_id");
        Collection<ConfigurationSection> attributes = ConfigurationUtils.getNodeList(configuration, "attributes");
        if (attributes != null && !attributes.isEmpty()) {
            this.item = InventoryUtils.makeReal(this.item);
            for (ConfigurationSection attributeConfig : attributes) {
                String attributeKey = attributeConfig.getString("type");
                attributeKey = attributeConfig.getString("attribute", attributeKey);
                try {
                    int operation;
                    Attribute attribute = Attribute.valueOf((String)attributeKey.toUpperCase());
                    double value = attributeConfig.getDouble("amount");
                    value = attributeConfig.getDouble("value", value);
                    String slot = attributeConfig.getString("slot");
                    String uuidString = attributeConfig.getString("uuid");
                    UUID uuid = null;
                    if (uuidString != null) {
                        try {
                            uuid = UUID.fromString(uuidString);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (uuid == null) {
                        uuid = UUID.randomUUID();
                    }
                    if (CompatibilityUtils.setItemAttribute(this.item, attribute, value, slot, operation = attributeConfig.getInt("operation", 0), uuid)) continue;
                    Bukkit.getLogger().warning("Failed to set attribute: " + attributeKey);
                }
                catch (Exception ex) {
                    Bukkit.getLogger().warning("Invalid attribute: " + attributeKey);
                }
            }
        } else {
            ConfigurationSection simpleAttributes = configuration.getConfigurationSection("attributes");
            if (simpleAttributes != null) {
                InventoryUtils.applyAttributes(this.item, simpleAttributes, configuration.getString("attribute_slot"));
            }
        }
        if ((tagSection = configuration.getConfigurationSection("tags")) != null) {
            this.item = CompatibilityUtils.makeReal(this.item);
            InventoryUtils.saveTagsToItem(tagSection, this.item);
        }
        if ((customName = configuration.getString("name")) != null) {
            ItemMeta meta = this.item.getItemMeta();
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)customName));
            this.item.setItemMeta(meta);
        }
        if ((lore = configuration.getStringList("lore")) != null && !lore.isEmpty()) {
            ItemMeta meta = this.item.getItemMeta();
            for (int i = 0; i < lore.size(); ++i) {
                lore.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)((String)lore.get(i))));
            }
            meta.setLore(lore);
            this.item.setItemMeta(meta);
        }
        if (configuration.getBoolean("locked")) {
            this.locked = true;
            InventoryUtils.setMetaBoolean(this.item, "locked", true);
            InventoryUtils.setMeta(this.item, "magic_key", key);
        }
        this.replaceOnEquip = configuration.getBoolean("replace_on_equip");
        List<String> categoriesList = ConfigurationUtils.getStringList(configuration, "categories");
        if (categoriesList != null) {
            this.categories = ImmutableSet.copyOf(categoriesList);
        }
    }

    public ItemData(String key, ItemStack item, double worth, MageController controller) throws Exception {
        this.controller = controller;
        if (item == null) {
            throw new Exception("Invalid item");
        }
        this.key = key;
        this.materialKey = key;
        this.item = item;
        this.worth = worth;
    }

    public static String cleanMinecraftItemName(String materialKey) {
        if (materialKey.startsWith(MINECRAFT_ITEM_PREFIX)) {
            materialKey = materialKey.substring(MINECRAFT_ITEM_PREFIX.length());
        }
        return materialKey;
    }

    public ItemData createVariant(String key, short damage) throws Exception {
        ItemData copy = new ItemData(key, this.item.clone(), this.worth, this.controller);
        copy.categories = this.categories;
        copy.item.setDurability(damage);
        return copy;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public double getWorth() {
        return this.worth;
    }

    @Override
    public double getEarns() {
        return this.earns == null ? this.worth * EARN_SCALE : this.earns;
    }

    @Override
    public boolean hasCustomEarns() {
        return this.earns != null;
    }

    @Override
    public Set<String> getCategories() {
        return this.categories;
    }

    @Override
    @Nullable
    public ItemStack getItemStack(int amount) {
        return this.getItemStack(amount, null);
    }

    @Override
    @Nullable
    public ItemStack getItemStack(int amount, ItemUpdatedCallback callback) {
        ItemStack newItem = InventoryUtils.getCopy(this.getOrCreateItemStack());
        if (newItem == null) {
            if (callback != null) {
                callback.updated(null);
            }
            return null;
        }
        if (this.pending != null) {
            this.pending.add(new PendingUpdate(newItem, callback));
        } else if (callback != null) {
            callback.updated(newItem);
        }
        newItem.setAmount(amount);
        return newItem;
    }

    @Override
    @Nullable
    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    @Nonnull
    private ItemStack getOrCreateItemStack() {
        if (this.item == null) {
            this.item = this.controller.createItem(this.materialKey, null, false, this);
            if (!this.loaded && InventoryUtils.isSkull(this.item)) {
                this.pending = new ArrayList<PendingUpdate>();
            }
        }
        if (this.item == null) {
            this.controller.getLogger().warning("Invalid material key: " + this.materialKey);
            this.item = new ItemStack(Material.AIR);
        }
        return this.item;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    public Material getType() {
        return this.getOrCreateItemStack().getType();
    }

    public int getCustomModelData() {
        return InventoryUtils.getMetaInt(this.getOrCreateItemStack(), "CustomModelData", 0);
    }

    @Override
    @Nullable
    @Deprecated
    public MaterialData getMaterialData() {
        ItemStack item = this.getOrCreateItemStack();
        MaterialData materialData = item.getData();
        materialData.setData((byte)item.getDurability());
        return materialData;
    }

    @Override
    public int getDurability() {
        return this.getOrCreateItemStack().getDurability();
    }

    @Override
    @Nullable
    public ItemMeta getItemMeta() {
        return this.getOrCreateItemStack().getItemMeta();
    }

    @Override
    @Nullable
    public MaterialAndData getMaterialAndData() {
        return new MaterialAndData(this.getOrCreateItemStack());
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public boolean isReplaceOnEquip() {
        return this.replaceOnEquip;
    }

    @Override
    public void updated(@Nullable ItemStack itemStack) {
        this.loaded = true;
        if (this.pending != null && itemStack != null) {
            this.item = itemStack;
            ItemMeta populatedMeta = itemStack.getItemMeta();
            Object profile = InventoryUtils.getSkullProfile(populatedMeta);
            for (PendingUpdate update : this.pending) {
                if (profile != null) {
                    ItemStack item = update.item;
                    ItemMeta meta = item.getItemMeta();
                    InventoryUtils.setSkullProfile(meta, profile);
                    item.setItemMeta(meta);
                }
                if (update.callback == null) continue;
                update.callback.updated(update.item);
            }
        }
        this.pending = null;
    }

    private static class PendingUpdate {
        public ItemStack item;
        public ItemUpdatedCallback callback;

        public PendingUpdate(ItemStack item, ItemUpdatedCallback callback) {
            this.item = item;
            this.callback = callback;
        }
    }
}

