/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.item;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import org.bukkit.inventory.Inventory;

public enum InventorySlot {
    HELMET(39),
    CHESTPLATE(38),
    LEGGINGS(37),
    BOOTS(36),
    MAIN_HAND,
    OFF_HAND,
    FREE,
    RIGHT_ARM;

    private final int slot;

    private InventorySlot() {
        this(-1);
    }

    private InventorySlot(int slot) {
        this.slot = slot;
    }

    public static InventorySlot getArmorSlot(int slot) {
        slot = Math.max(Math.min(slot, 3), 0);
        switch (slot) {
            case 0: {
                return BOOTS;
            }
            case 1: {
                return LEGGINGS;
            }
            case 2: {
                return CHESTPLATE;
            }
            case 3: {
                return HELMET;
            }
        }
        return HELMET;
    }

    public int getArmorSlot() {
        return this.slot - 36;
    }

    public boolean isArmorSlot() {
        return this.slot != -1;
    }

    public int getSlot() {
        return this.slot;
    }

    public int getSlot(Mage mage) {
        if (this.slot != -1 || !mage.isPlayer()) {
            return this.slot;
        }
        switch (this) {
            case MAIN_HAND: {
                return mage.getPlayer().getInventory().getHeldItemSlot();
            }
            case OFF_HAND: {
                return 40;
            }
            case FREE: {
                Inventory inventory = mage.getInventory();
                for (int i = 0; i < inventory.getSize(); ++i) {
                    if (!CompatibilityUtils.isEmpty(inventory.getItem(i))) continue;
                    return i;
                }
                break;
            }
            default: {
                return -1;
            }
        }
        return -1;
    }
}

