/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.batch;

import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.magic.MaterialMap;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.MaterialSetManager;
import com.elmakers.mine.bukkit.batch.BrushBatch;
import com.elmakers.mine.bukkit.block.ConstructionType;
import com.elmakers.mine.bukkit.block.UndoList;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Button;
import org.bukkit.material.Lever;
import org.bukkit.material.MaterialData;
import org.bukkit.material.PistonBaseMaterial;
import org.bukkit.material.PoweredRail;
import org.bukkit.material.RedstoneWire;
import org.bukkit.util.Vector;

public class ConstructBatch
extends BrushBatch {
    private final Location center;
    private Vector orient = null;
    private int radius;
    private final ConstructionType type;
    private final int thickness;
    private final boolean spawnFallingBlocks;
    private float fallingBlockSpeed = 0.0f;
    private Vector fallingDirection = null;
    private final Map<Long, com.elmakers.mine.bukkit.block.BlockData> attachedBlockMap = new HashMap<Long, com.elmakers.mine.bukkit.block.BlockData>();
    private final List<com.elmakers.mine.bukkit.block.BlockData> attachedBlockList = new ArrayList<com.elmakers.mine.bukkit.block.BlockData>();
    private final List<com.elmakers.mine.bukkit.block.BlockData> delayedBlocks = new ArrayList<com.elmakers.mine.bukkit.block.BlockData>();
    @Nonnull
    private final MaterialSet attachables;
    @Nonnull
    private final MaterialSet attachablesWall;
    @Nonnull
    private final MaterialSet attachablesDouble;
    @Nonnull
    private final MaterialSet delayed;
    @Nonnull
    private final MaterialSet deferredTypes;
    private MaterialAndData replace;
    private Material replaceType;
    private MaterialMap replaceMaterials;
    private boolean finishedNonAttached = false;
    private boolean finishedAttached = false;
    private boolean finishedDelayedBlocks = false;
    private int attachedBlockIndex = 0;
    private int delayedBlockIndex = 0;
    private Deque<BlockData> deferred;
    private Integer maxOrientDimension = null;
    private Integer minOrientDimension = null;
    private boolean power = false;
    private boolean commit = false;
    private double breakable = 0.0;
    private double backfireChance = 0.0;
    private Vector bounds = null;
    private boolean applyPhysics = false;
    private boolean consume = false;
    private boolean consumeVariants = true;
    private boolean checkChunks = true;
    private boolean deferPhysics = true;
    private boolean useBrushSize = false;
    private int x = 0;
    private int y = 0;
    private int z = 0;
    private int r = 0;
    private boolean limitYAxis = false;

    public ConstructBatch(BrushSpell spell, Location center, ConstructionType type, int radius, int thickness, boolean spawnFallingBlocks, Vector orientVector) {
        super(spell);
        this.center = center;
        this.radius = radius;
        this.type = type;
        this.thickness = thickness;
        this.spawnFallingBlocks = spawnFallingBlocks;
        MaterialSetManager materials = this.mage.getController().getMaterialSetManager();
        this.attachables = materials.getMaterialSetEmpty("attachable");
        this.attachablesWall = materials.getMaterialSetEmpty("attachable_wall");
        this.attachablesDouble = materials.getMaterialSetEmpty("attachable_double");
        this.delayed = materials.getMaterialSetEmpty("delayed");
        this.deferredTypes = materials.getMaterialSetEmpty("deferred");
        this.orient = orientVector == null ? new Vector(0, 1, 0) : orientVector;
    }

    public void setPower(boolean power) {
        this.power = power;
        this.undoList.setApplyPhysics(true);
    }

    public void setBackfireChance(double backfireChance) {
        this.backfireChance = backfireChance;
    }

    public void setBreakable(double breakable) {
        this.breakable = breakable;
    }

    public void setFallingBlockSpeed(float speed) {
        this.fallingBlockSpeed = speed;
    }

    public void setFallingDirection(Vector direction) {
        this.fallingDirection = direction;
    }

    public void setOrientDimensionMax(int maxDim) {
        this.maxOrientDimension = maxDim;
    }

    public void setOrientDimensionMin(int minDim) {
        this.minOrientDimension = minDim;
    }

    @Deprecated
    protected boolean canAttachTo(Material attachMaterial, Material material, boolean vertical) {
        if (vertical && attachMaterial == material) {
            return true;
        }
        if (material.isTransparent()) {
            return false;
        }
        return !this.attachables.testMaterial(material) && !this.attachablesWall.testMaterial(material) && !this.attachablesDouble.testMaterial(material);
    }

    @Override
    public int size() {
        return this.radius * this.radius * this.radius * 8;
    }

    @Override
    public int remaining() {
        if (this.r >= this.radius) {
            return 0;
        }
        return (this.radius - this.r) * (this.radius - this.r) * (this.radius - this.r) * 8;
    }

    @Override
    public int process(int workAllowed) {
        int workPerformed;
        block33: {
            block36: {
                block35: {
                    BlockData delayed;
                    block34: {
                        workPerformed = 0;
                        if (this.useBrushSize && this.bounds == null) {
                            MaterialBrush brush = this.spell.getBrush();
                            if (!brush.isReady()) {
                                return 0;
                            }
                            this.bounds = brush.getSize();
                            if (this.bounds == null) {
                                this.finished = true;
                                return 0;
                            }
                            this.minOrientDimension = 0;
                            this.radius = (int)Math.max(Math.max(this.bounds.getX() / 2.0, this.bounds.getZ() / 2.0), this.bounds.getY());
                        }
                        if (!this.finishedDelayedBlocks) break block34;
                        if (this.deferred == null || this.deferred.isEmpty()) {
                            this.finish();
                        } else {
                            while (!this.deferred.isEmpty() && workPerformed < workAllowed && !this.finished) {
                                delayed = this.deferred.pop();
                                if (this.checkChunks && !CompatibilityUtils.checkChunk(delayed.getWorldLocation())) {
                                    return workPerformed + 20;
                                }
                                Block block = delayed.getBlock();
                                if (!this.deferredTypes.testMaterial(block.getType())) {
                                    ++workPerformed;
                                    continue;
                                }
                                workPerformed += 5;
                                CompatibilityUtils.applyPhysics(block);
                            }
                        }
                        break block33;
                    }
                    if (!this.finishedAttached) break block35;
                    if (this.delayedBlockIndex >= this.delayedBlocks.size()) {
                        this.finishedDelayedBlocks = true;
                        if (!this.deferPhysics || this.undoList == null) {
                            this.finish();
                        } else {
                            this.deferred = new ArrayDeque<BlockData>(this.undoList);
                        }
                    } else {
                        while (this.delayedBlockIndex < this.delayedBlocks.size() && workPerformed < workAllowed && !this.finished) {
                            delayed = this.delayedBlocks.get(this.delayedBlockIndex);
                            if (this.checkChunks && !CompatibilityUtils.checkChunk(((com.elmakers.mine.bukkit.block.BlockData)delayed).getWorldLocation())) {
                                return workPerformed + 20;
                            }
                            Block block = ((com.elmakers.mine.bukkit.block.BlockData)delayed).getBlock();
                            workPerformed += 10;
                            this.modifyWith(block, delayed);
                            ++this.delayedBlockIndex;
                        }
                    }
                    break block33;
                }
                if (!this.finishedNonAttached) break block36;
                while (this.attachedBlockIndex < this.attachedBlockList.size() && workPerformed < workAllowed && !this.finished) {
                    boolean canAttachToWall;
                    com.elmakers.mine.bukkit.block.BlockData attach = this.attachedBlockList.get(this.attachedBlockIndex);
                    if (this.checkChunks && !CompatibilityUtils.checkChunk(attach.getWorldLocation())) {
                        return workPerformed + 20;
                    }
                    Block block = attach.getBlock();
                    Block underneath = block.getRelative(BlockFace.DOWN);
                    Material material = attach.getMaterial();
                    boolean ok = this.canAttachTo(material, underneath.getType(), true);
                    if (!ok && this.attachablesDouble.testMaterialAndData(attach)) {
                        com.elmakers.mine.bukkit.block.BlockData attachedUnder = this.attachedBlockMap.get(com.elmakers.mine.bukkit.block.BlockData.getBlockId(underneath));
                        boolean bl = ok = attachedUnder != null && attachedUnder.getMaterial() == material;
                        if (!ok) {
                            Block above = block.getRelative(BlockFace.UP);
                            com.elmakers.mine.bukkit.block.BlockData attachedAbove = this.attachedBlockMap.get(com.elmakers.mine.bukkit.block.BlockData.getBlockId(above));
                            boolean bl2 = ok = attachedAbove != null && attachedAbove.getMaterial() == material;
                        }
                    }
                    if (!ok && (canAttachToWall = this.attachablesWall.testMaterialAndData(attach))) {
                        BlockFace[] faces;
                        for (BlockFace face : faces = new BlockFace[]{BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH}) {
                            if (!this.canAttachTo(material, block.getRelative(face).getType(), false)) continue;
                            ok = true;
                            break;
                        }
                    }
                    if (ok) {
                        this.modifyWith(block, attach);
                        workPerformed += 10;
                    }
                    ++this.attachedBlockIndex;
                }
                if (this.attachedBlockIndex < this.attachedBlockList.size()) break block33;
                this.finishedAttached = true;
                break block33;
            }
            int yBounds = this.radius;
            if ((this.maxOrientDimension != null || this.minOrientDimension != null) && this.orient.getBlockY() > 0) {
                this.limitYAxis = true;
                yBounds = Math.max(this.minOrientDimension == null ? this.radius : this.minOrientDimension, this.maxOrientDimension == null ? this.radius : this.maxOrientDimension);
            }
            if (this.bounds != null) {
                yBounds = Math.min(yBounds, (int)this.bounds.getY());
            }
            yBounds = Math.min(yBounds, this.center.getWorld().getMaxHeight());
            while (workPerformed <= workAllowed && !this.finishedNonAttached && !this.finished) {
                if (!this.fillBlock(this.x, this.y, this.z)) {
                    return workPerformed + 5;
                }
                int xBounds = this.r;
                int zBounds = this.r;
                if ((this.maxOrientDimension != null || this.minOrientDimension != null) && this.orient.getBlockX() > 0) {
                    xBounds = Math.max(this.minOrientDimension == null ? this.r : this.minOrientDimension, this.maxOrientDimension == null ? this.r : this.maxOrientDimension);
                }
                if (this.bounds != null) {
                    xBounds = Math.min(xBounds, (int)this.bounds.getX());
                }
                ++this.y;
                if (this.y > yBounds) {
                    this.y = 0;
                    if (this.x < xBounds) {
                        ++this.x;
                    } else {
                        --this.z;
                        if (this.z < 0) {
                            ++this.r;
                            zBounds = this.r;
                            if ((this.maxOrientDimension != null || this.minOrientDimension != null) && this.orient.getBlockZ() > 0) {
                                zBounds = Math.max(this.minOrientDimension == null ? this.r : this.minOrientDimension, this.maxOrientDimension == null ? this.r : this.maxOrientDimension);
                            }
                            if (this.bounds != null) {
                                zBounds = Math.min(zBounds, (int)this.bounds.getZ());
                            }
                            this.z = zBounds;
                            this.x = 0;
                        }
                    }
                }
                workPerformed += 10;
                if (this.r <= this.radius && (this.bounds == null || !((double)this.r > this.bounds.getZ()) || !((double)this.r > this.bounds.getX()))) continue;
                this.finishedNonAttached = true;
                break;
            }
        }
        return workPerformed;
    }

    public boolean fillBlock(int x, int y, int z) {
        boolean fillBlock = false;
        int maxDistanceSquared = this.radius * this.radius;
        switch (this.type) {
            case SPHERE: {
                float mx = (float)x - 0.1f;
                float my = (float)y - 0.1f;
                float mz = (float)z - 0.1f;
                int distanceSquared = (int)(mx * mx + my * my + mz * mz);
                if (this.thickness == 0) {
                    fillBlock = distanceSquared <= maxDistanceSquared;
                    break;
                }
                int outerDistanceSquared = (int)((mx += 1.0f) * mx + (my += 1.0f) * my + (mz += 1.0f) * mz);
                fillBlock = maxDistanceSquared >= distanceSquared - this.thickness && maxDistanceSquared <= outerDistanceSquared;
                break;
            }
            case CYLINDER: {
                float mx = (float)x - 0.1f;
                float mz = (float)z - 0.1f;
                int distanceSquared = (int)(mx * mx + mz * mz);
                if (this.thickness == 0) {
                    fillBlock = distanceSquared <= maxDistanceSquared;
                    break;
                }
                int outerDistanceSquared = (int)((mx += 1.0f) * mx + (mz += 1.0f) * mz);
                fillBlock = maxDistanceSquared >= distanceSquared - this.thickness && maxDistanceSquared <= outerDistanceSquared;
                break;
            }
            case PYRAMID: {
                int elevation = this.radius - y;
                if (this.thickness == 0) {
                    fillBlock = x <= elevation && z <= elevation;
                    break;
                }
                fillBlock = x <= elevation && x >= elevation - this.thickness && z <= elevation || z <= elevation && z >= elevation - this.thickness && x <= elevation;
                break;
            }
            default: {
                fillBlock = this.thickness == 0 ? true : x > this.radius - this.thickness || y > this.radius - this.thickness || z > this.radius - this.thickness;
            }
        }
        boolean success = true;
        if (fillBlock) {
            if (y != 0) {
                boolean bl = success = success && this.constructBlock(x, -y, z);
                if (x != 0) {
                    boolean bl2 = success = success && this.constructBlock(-x, -y, z);
                }
                if (z != 0) {
                    boolean bl3 = success = success && this.constructBlock(x, -y, -z);
                }
                if (x != 0 && z != 0) {
                    success = success && this.constructBlock(-x, -y, -z);
                }
            }
            boolean bl = success = success && this.constructBlock(x, y, z);
            if (x != 0) {
                boolean bl4 = success = success && this.constructBlock(-x, y, z);
            }
            if (z != 0) {
                boolean bl5 = success = success && this.constructBlock(x, y, -z);
            }
            if (z != 0 && x != 0) {
                success = success && this.constructBlock(-x, y, -z);
            }
        }
        return success;
    }

    public boolean constructBlock(int dx, int dy, int dz) {
        if (this.limitYAxis && this.minOrientDimension != null && dy < -this.minOrientDimension.intValue()) {
            return true;
        }
        if (this.limitYAxis && this.maxOrientDimension != null && dy > this.maxOrientDimension) {
            return true;
        }
        if (this.bounds != null) {
            if ((double)dx > this.bounds.getX() || (double)dy > this.bounds.getY() || (double)dz > this.bounds.getZ()) {
                return true;
            }
            if ((double)dx < -this.bounds.getX() || (double)dy < -this.bounds.getY() || (double)dz < -this.bounds.getZ()) {
                return true;
            }
        }
        int x = this.center.getBlockX() + dx;
        int y = this.center.getBlockY() + dy;
        int z = this.center.getBlockZ() + dz;
        if (y < 0 || y > this.center.getWorld().getMaxHeight()) {
            return true;
        }
        Location location = new Location(this.center.getWorld(), (double)x, (double)y, (double)z);
        if (this.checkChunks && !CompatibilityUtils.checkChunk(location)) {
            return false;
        }
        Block block = location.getBlock();
        if (!this.spell.isDestructible(block)) {
            return true;
        }
        if (this.replace != null && this.replace.isDifferent(block)) {
            return true;
        }
        if (this.replaceType != null && this.replaceType != block.getType()) {
            return true;
        }
        MaterialBrush brush = this.spell.getBrush();
        brush.update(this.mage, block.getLocation());
        if (brush.isErase() ? !this.spell.hasBreakPermission(block) : !this.spell.hasBuildPermission(block)) {
            return true;
        }
        BlockState blockState = block.getState();
        if (this.power) {
            Material material = block.getType();
            MaterialData data = blockState.getData();
            boolean powerBlock = false;
            if (data instanceof Button) {
                Button powerData = (Button)data;
                this.registerForUndo(block);
                powerData.setPowered(!powerData.isPowered());
                powerBlock = true;
            } else if (data instanceof Lever) {
                Lever powerData = (Lever)data;
                this.registerForUndo(block);
                powerData.setPowered(!powerData.isPowered());
                powerBlock = true;
            } else if (data instanceof PistonBaseMaterial) {
                PistonBaseMaterial powerData = (PistonBaseMaterial)data;
                this.registerForUndo(block);
                powerData.setPowered(!powerData.isPowered());
                powerBlock = true;
            } else if (data instanceof PoweredRail) {
                PoweredRail powerData = (PoweredRail)data;
                this.registerForUndo(block);
                powerData.setPowered(!powerData.isPowered());
                powerBlock = true;
            } else if (data instanceof RedstoneWire) {
                RedstoneWire wireData = (RedstoneWire)data;
                this.registerForUndo(block);
                wireData.setData((byte)(15 - wireData.getData()));
                powerBlock = true;
            } else if (material == Material.REDSTONE_BLOCK) {
                this.registerForUndo(block);
                block.getWorld().playEffect(block.getLocation(), Effect.STEP_SOUND, material.getId());
                this.controller.getRedstoneReplacement().modify(block, this.applyPhysics);
            } else if (material == Material.TNT) {
                this.registerForUndo(block);
                block.setType(Material.AIR);
                this.registerForUndo(block.getLocation().getWorld().spawnEntity(block.getLocation(), EntityType.PRIMED_TNT));
            }
            if (powerBlock) {
                blockState.update();
            }
            return true;
        }
        if (!brush.isReady()) {
            brush.prepare();
            return false;
        }
        if (this.attachables.testMaterialAndData(brush) || this.attachablesWall.testMaterialAndData(brush) || this.attachablesDouble.testMaterialAndData(brush)) {
            com.elmakers.mine.bukkit.block.BlockData attachBlock = new com.elmakers.mine.bukkit.block.BlockData(block);
            attachBlock.updateFrom(brush);
            this.attachedBlockMap.put(attachBlock.getId(), attachBlock);
            this.attachedBlockList.add(attachBlock);
            return true;
        }
        if (this.delayed.testMaterialAndData(brush)) {
            com.elmakers.mine.bukkit.block.BlockData delayBlock = new com.elmakers.mine.bukkit.block.BlockData(block);
            delayBlock.updateFrom(brush);
            this.delayedBlocks.add(delayBlock);
            return true;
        }
        this.modifyWith(block, brush);
        if (!this.undoList.isScheduled()) {
            this.controller.logBlockChange(this.spell.getMage(), blockState, block.getState());
        }
        return true;
    }

    protected void modifyWith(Block block, MaterialAndData brush) {
        Material previousMaterial = block.getType();
        byte previousData = DeprecatedUtils.getData(block);
        this.touch(block);
        boolean isDifferent = false;
        MaterialAndData replacement = null;
        if (this.replaceMaterials != null) {
            replacement = this.replaceMaterials.get(brush.getMaterial());
        }
        isDifferent = replacement != null ? replacement.isDifferent(block) : brush.isDifferent(block);
        if (brush.isValid() && (isDifferent || this.commit)) {
            if (this.consume && !this.context.isConsumeFree() && brush.getMaterial() != Material.AIR) {
                ItemStack requires = brush.getItemStack(1);
                if (!this.mage.hasItem(requires, this.consumeVariants)) {
                    String requiresMessage = this.context.getMessage("insufficient_resources");
                    this.context.sendMessageKey("insufficient_resources", requiresMessage.replace("$cost", brush.getName()));
                    this.finish();
                    return;
                }
                this.mage.removeItem(requires, this.consumeVariants);
            }
            if (!this.commit) {
                this.registerForUndo(block);
            }
            BlockState prior = block.getState();
            brush.modify(block, this.applyPhysics);
            if (replacement != null) {
                replacement.modify(block, this.applyPhysics);
            }
            if (!this.undoList.isScheduled()) {
                this.controller.logBlockChange(this.spell.getMage(), prior, block.getState());
            }
            if (this.breakable > 0.0) {
                this.context.registerBreakable(block, this.breakable);
            }
            if (this.backfireChance > 0.0) {
                this.context.registerReflective(block, this.backfireChance);
            }
            if (this.spawnFallingBlocks) {
                FallingBlock falling = DeprecatedUtils.spawnFallingBlock(block.getLocation(), previousMaterial, previousData);
                falling.setDropItem(false);
                if (this.fallingBlockSpeed != 0.0f) {
                    Vector direction = this.fallingDirection != null ? this.fallingDirection : falling.getLocation().subtract(this.center).toVector();
                    direction = direction.normalize().multiply(this.fallingBlockSpeed);
                    SafetyUtils.setVelocity((Entity)falling, direction);
                }
                this.registerForUndo((Entity)falling);
            }
            if (this.commit) {
                BlockData blockData = UndoList.register(block);
                blockData.commit();
            }
        }
    }

    public void setReplace(MaterialAndData replace) {
        this.replace = replace;
    }

    public void setReplaceType(Material replace) {
        this.replaceType = replace;
    }

    public void setDeferPhysics(boolean defer) {
        this.deferPhysics = defer;
    }

    @Override
    protected boolean contains(Location location) {
        if (this.thickness != 0) {
            return false;
        }
        if (!location.getWorld().equals(this.center.getWorld())) {
            return false;
        }
        switch (this.type) {
            case SPHERE: {
                int radiusSquared = this.radius * this.radius;
                return location.distanceSquared(this.center) <= (double)radiusSquared;
            }
        }
        return location.getBlockX() >= this.center.getBlockX() - this.radius && location.getBlockX() <= this.center.getBlockX() + this.radius && location.getBlockY() >= this.center.getBlockY() - this.radius && location.getBlockY() <= this.center.getBlockY() + this.radius && location.getBlockZ() >= this.center.getBlockZ() - this.radius && location.getBlockZ() <= this.center.getBlockZ() + this.radius;
    }

    public void setApplyPhysics(boolean physics) {
        this.applyPhysics = physics;
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public void setConsume(boolean consume) {
        this.consume = consume;
    }

    public void setConsumeVariants(boolean variants) {
        this.consumeVariants = variants;
    }

    public void setCheckChunks(boolean checkChunks) {
        this.checkChunks = checkChunks;
    }

    public void setUseBrushSize(boolean useBrushSize) {
        this.useBrushSize = useBrushSize;
    }

    public void setReplaceMaterials(MaterialMap replaceMaterials) {
        this.replaceMaterials = replaceMaterials;
    }
}

