/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.block.builtin;

import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import com.elmakers.mine.bukkit.world.BlockResult;
import com.elmakers.mine.bukkit.world.CastSpell;
import com.elmakers.mine.bukkit.world.CastSpellParser;
import com.elmakers.mine.bukkit.world.block.BlockRule;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class CastRule
extends BlockRule {
    protected List<CastSpell> spells;
    protected Deque<WeightedPair<CastSpell>> spellProbability;

    @Override
    public boolean onLoad(ConfigurationSection parameters) {
        List spells = parameters.getStringList("spells");
        if (spells == null || spells.size() == 0) {
            ConfigurationSection spellMap = parameters.getConfigurationSection("spells");
            this.spellProbability = new ArrayDeque<WeightedPair<CastSpell>>();
            RandomUtils.populateProbabilityMap(CastSpellParser.getInstance(), this.spellProbability, spellMap);
            if (this.spellProbability.isEmpty()) {
                return false;
            }
            this.logBlockRule("Casting one of " + StringUtils.join(this.spellProbability, (String)","));
        } else {
            this.spells = new ArrayList<CastSpell>();
            for (String spellName : spells) {
                this.spells.add(new CastSpell(spellName));
            }
            this.logBlockRule("Casting " + StringUtils.join(this.spells, (String)","));
        }
        return !spells.isEmpty() || !this.spellProbability.isEmpty();
    }

    @Override
    @Nonnull
    public BlockResult onHandle(Block block, Random random, Player cause) {
        String[] standardParameters = new String[]{"pworld", block.getLocation().getWorld().getName(), "px", Integer.toString(block.getLocation().getBlockX()), "py", Integer.toString(block.getLocation().getBlockY()), "pz", Integer.toString(block.getLocation().getBlockZ()), "target", "self", "quiet", "true"};
        if (this.spells == null) {
            this.spells = new ArrayList<CastSpell>();
        }
        if (this.spellProbability != null) {
            CastSpell spell = (CastSpell)RandomUtils.weightedRandom(this.spellProbability);
            this.spells.clear();
            this.spells.add(spell);
        }
        Mage mage = this.controller.getMage(cause);
        boolean casted = false;
        for (CastSpell castSpell : this.spells) {
            int index;
            MageSpell spell;
            if (castSpell.isEmpty() || (spell = mage.getSpell(castSpell.getName())) == null) continue;
            String[] fullParameters = new String[castSpell.getParameters().length + standardParameters.length];
            for (index = 0; index < standardParameters.length; ++index) {
                fullParameters[index] = standardParameters[index];
            }
            for (index = 0; index < castSpell.getParameters().length; ++index) {
                fullParameters[index + standardParameters.length] = castSpell.getParameters()[index];
            }
            casted = spell.cast(fullParameters) || casted;
        }
        return casted ? BlockResult.REMOVE_DROPS : BlockResult.SKIP;
    }
}

