/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.requirements;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.api.wand.WandUpgradePath;
import com.elmakers.mine.bukkit.requirements.PropertyRequirement;
import com.elmakers.mine.bukkit.requirements.RangedRequirement;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class MagicRequirement {
    @Nonnull
    private final MageController controller;
    @Nullable
    private String permissionNode = null;
    @Nullable
    private String notPermissionNode = null;
    @Nullable
    private String requiredPath = null;
    @Nullable
    private String requiredTemplate = null;
    @Nullable
    private Set<String> requiredTemplates = null;
    @Nullable
    private List<String> wandTags = null;
    @Nullable
    private String requiresCompletedPath = null;
    @Nullable
    private String exactPath = null;
    @Nullable
    private List<String> mageClass = null;
    @Nullable
    private List<String> activeClass = null;
    @Nullable
    private List<PropertyRequirement> wandProperties = null;
    @Nullable
    private List<PropertyRequirement> classProperties = null;
    @Nullable
    private List<PropertyRequirement> attributes = null;
    @Nullable
    private List<PropertyRequirement> variables = null;
    @Nullable
    private RangedRequirement lightLevel = null;
    @Nullable
    private RangedRequirement timeOfDay = null;
    @Nullable
    private RangedRequirement height = null;
    @Nullable
    private RangedRequirement currency = null;
    @Nullable
    private String weather = null;
    @Nullable
    private String castSpell = null;
    private int castTimeout = 0;
    @Nonnull
    private String currencyType = "currency";
    private boolean requireWand = false;
    private boolean ignoreMissing = false;

    public MagicRequirement(@Nonnull MageController controller, @Nonnull Requirement requirement) {
        this.controller = controller;
        ConfigurationSection configuration = requirement.getConfiguration();
        this.permissionNode = configuration.getString("permission");
        this.notPermissionNode = configuration.getString("not_permission");
        this.requiredPath = configuration.getString("path");
        this.exactPath = configuration.getString("path_exact");
        this.requiresCompletedPath = configuration.getString("path_end");
        this.requiredTemplate = configuration.getString("wand");
        this.requireWand = configuration.getBoolean("holding_wand");
        this.mageClass = ConfigurationUtils.getStringList(configuration, "class");
        this.activeClass = ConfigurationUtils.getStringList(configuration, "active_class");
        this.wandTags = ConfigurationUtils.getStringList(configuration, "wand_tags");
        this.ignoreMissing = configuration.getBoolean("ignore_missing", false);
        if (this.activeClass != null && this.mageClass == null) {
            this.mageClass = this.activeClass;
        }
        if (configuration.contains("wands")) {
            this.requiredTemplates = new HashSet<String>(ConfigurationUtils.getStringList(configuration, "wands"));
        }
        this.wandProperties = this.parsePropertyRequirements(configuration, "wand_properties", "property");
        this.classProperties = this.parsePropertyRequirements(configuration, "class_properties", "property");
        this.attributes = this.parsePropertyRequirements(configuration, "attributes", "attribute");
        this.variables = this.parsePropertyRequirements(configuration, "variables", "variable");
        this.lightLevel = this.parseRangedRequirement(configuration, "light");
        this.timeOfDay = this.parseRangedRequirement(configuration, "time");
        this.weather = configuration.getString("weather");
        this.height = this.parseRangedRequirement(configuration, "height");
        this.currency = this.parseRangedRequirement(configuration, "currency");
        this.currencyType = configuration.getString("currency_type", "currency");
        this.castSpell = configuration.getString("cast_spell");
        this.castTimeout = configuration.getInt("cast_timeout", 0);
        if (this.requiresCompletedPath != null) {
            this.requiredPath = this.requiresCompletedPath;
            this.exactPath = this.requiresCompletedPath;
        }
        if (this.requiredTemplate != null || this.requiredTemplates != null || this.wandProperties != null || this.wandTags != null) {
            this.requireWand = true;
        }
    }

    @Nullable
    private RangedRequirement parseRangedRequirement(ConfigurationSection configuration, String key) {
        if (configuration.contains(key)) {
            return new RangedRequirement(ConfigurationUtils.getConfigurationSection(configuration, key));
        }
        return null;
    }

    @Nullable
    private List<PropertyRequirement> parsePropertyRequirements(ConfigurationSection configuration, String section, String type) {
        if (!configuration.contains(section)) {
            return null;
        }
        ArrayList<PropertyRequirement> requirements = new ArrayList<PropertyRequirement>();
        Collection<ConfigurationSection> propertyConfigs = ConfigurationUtils.getNodeList(configuration, section);
        for (ConfigurationSection propertyConfig : propertyConfigs) {
            if (!propertyConfig.contains(type)) {
                this.controller.getLogger().warning("Property requirement missing " + type + " parameter");
                continue;
            }
            PropertyRequirement requirement = new PropertyRequirement(type, propertyConfig);
            requirements.add(requirement);
        }
        return requirements;
    }

    public boolean checkRequirement(@Nonnull CastContext context) {
        Double value;
        String template;
        Mage mage = context.getMage();
        Player player = mage.getPlayer();
        if (!(this.permissionNode == null || player != null && player.hasPermission(this.permissionNode))) {
            return false;
        }
        if (this.notPermissionNode != null && player != null && player.hasPermission(this.notPermissionNode)) {
            return false;
        }
        Wand wand = context.getWand();
        if (wand == null && this.requireWand) {
            return false;
        }
        Location location = mage.getLocation();
        if (this.weather != null) {
            switch (this.weather) {
                case "storm": {
                    if (location != null && location.getWorld().hasStorm()) break;
                    return false;
                }
                case "thunder": {
                    if (location != null && location.getWorld().isThundering()) break;
                    return false;
                }
                case "clear": {
                    if (location != null && !location.getWorld().isThundering() && !location.getWorld().hasStorm()) break;
                    return false;
                }
                default: {
                    context.getLogger().warning("Invalid weather specified in requirement " + this.weather + ", looking for clear/storm/thunder");
                }
            }
        }
        if (!(this.timeOfDay == null || location != null && this.timeOfDay.check(Double.valueOf(location.getWorld().getTime())))) {
            return false;
        }
        if (!(this.lightLevel == null || location != null && this.lightLevel.check(Double.valueOf(location.getBlock().getLightLevel())))) {
            return false;
        }
        if (!(this.height == null || location != null && this.height.check(location.getY()))) {
            return false;
        }
        if (!(this.currency == null || location != null && this.currency.check(mage.getCurrency(this.currencyType)))) {
            return false;
        }
        if (this.castSpell != null && !this.castSpell.isEmpty()) {
            MageSpell spell = mage.getSpell(this.castSpell);
            if (spell == null) {
                return false;
            }
            long lastCast = spell.getLastCast();
            if (lastCast == 0L) {
                return false;
            }
            if (this.castTimeout > 0 && System.currentTimeMillis() - lastCast > (long)this.castTimeout) {
                return false;
            }
        }
        if (this.wandTags != null && !this.hasTags(wand)) {
            return false;
        }
        if (!(this.requiredTemplate == null || (template = wand.getTemplateKey()) != null && template.equals(this.requiredTemplate))) {
            return false;
        }
        if (!(this.requiredTemplates == null || (template = wand.getTemplateKey()) != null && this.requiredTemplates.contains(template))) {
            return false;
        }
        CasterProperties checkProperties = context.getActiveProperties();
        ProgressionPath path = checkProperties.getPath();
        if (this.mageClass != null && !this.mageClass.isEmpty()) {
            boolean hasAny = false;
            for (String string : this.mageClass) {
                if (!mage.hasClassUnlocked(string)) continue;
                hasAny = true;
                break;
            }
            if (!hasAny) {
                return false;
            }
        }
        if (this.activeClass != null && !this.activeClass.isEmpty()) {
            MageClass currentClass = mage.getActiveClass();
            boolean hasAny = false;
            if (currentClass != null) {
                for (String testClass : this.activeClass) {
                    if (!currentClass.getKey().equals(testClass)) continue;
                    hasAny = true;
                    break;
                }
            }
            if (!hasAny) {
                return false;
            }
        }
        if (this.requiredPath != null || this.exactPath != null) {
            if (path == null) {
                return false;
            }
            if (this.requiredPath != null && !path.hasPath(this.requiredPath)) {
                return false;
            }
            if (this.exactPath != null && !this.exactPath.equals(path.getKey())) {
                return false;
            }
            if (this.requiresCompletedPath != null) {
                boolean hasPathCompleted = false;
                if (path.hasPath(this.requiresCompletedPath)) {
                    hasPathCompleted = path.getKey().equals(this.requiresCompletedPath) ? !path.canProgress(checkProperties) : true;
                }
                if (!hasPathCompleted) {
                    return false;
                }
            }
        }
        if (this.wandProperties != null && !this.checkProperties(wand, this.wandProperties)) {
            return false;
        }
        if (this.classProperties != null) {
            MageClass activeClass = mage.getActiveClass();
            if (this.mageClass != null) {
                String string;
                Iterator<String> hasAny = this.mageClass.iterator();
                while (hasAny.hasNext() && (activeClass = mage.getClass(string = hasAny.next())) == null) {
                }
            }
            if (activeClass == null) {
                return false;
            }
            if (!this.checkProperties(activeClass, this.classProperties)) {
                return false;
            }
        }
        if (this.attributes != null) {
            for (PropertyRequirement requirement : this.attributes) {
                String string;
                if (requirement.check(value = context.getAttribute(string = requirement.key))) continue;
                return false;
            }
        }
        if (this.variables != null) {
            for (PropertyRequirement requirement : this.variables) {
                String string;
                if (requirement.check(value = context.getVariable(string = requirement.key))) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean checkProperties(CasterProperties properties, List<PropertyRequirement> requirements) {
        for (PropertyRequirement requirement : requirements) {
            String key;
            Double value;
            if (requirement.check(value = properties.hasProperty(key = requirement.key) ? properties.getProperty(key, 0.0) : null)) continue;
            return false;
        }
        return true;
    }

    protected String getMessage(CastContext context, String key) {
        return context.getMessage(key, this.getDefaultMessage(context, key));
    }

    protected String getDefaultMessage(CastContext context, String key) {
        return context.getController().getMessages().get("requirements." + key);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String getRequirementDescription(@Nonnull CastContext context) {
        String message;
        Double value;
        String key;
        String string;
        Object requiresPath;
        String template;
        String message2;
        String message3;
        Mage mage = context.getMage();
        MageController controller = mage.getController();
        Player player = mage.getPlayer();
        if (!(this.permissionNode == null || player != null && player.hasPermission(this.permissionNode))) {
            return context.getMessage(SpellResult.INSUFFICIENT_PERMISSION.name().toLowerCase());
        }
        if (this.notPermissionNode != null && player != null && player.hasPermission(this.notPermissionNode)) {
            return context.getMessage(SpellResult.INSUFFICIENT_PERMISSION.name().toLowerCase());
        }
        Wand wand = context.getWand();
        if (wand == null && this.requireWand) {
            return this.getMessage(context, "no_wand");
        }
        Location location = mage.getLocation();
        if (this.weather != null) {
            switch (this.weather) {
                case "storm": {
                    if (location != null && location.getWorld().hasStorm()) break;
                    return this.getMessage(context, "no_weather");
                }
                case "thunder": {
                    if (location != null && location.getWorld().isThundering()) break;
                    return this.getMessage(context, "no_weather");
                }
                case "clear": {
                    if (location != null && !location.getWorld().isThundering() && !location.getWorld().hasStorm()) break;
                    return this.getMessage(context, "no_weather");
                }
                default: {
                    context.getLogger().warning("Invalid weather specified in requirement " + this.weather + ", looking for clear/storm/thunder");
                }
            }
        }
        if (this.timeOfDay != null && (message3 = this.checkRequiredProperty(context, this.timeOfDay, this.getMessage(context, "time"), location == null ? null : Double.valueOf(location.getWorld().getTime()))) != null) {
            return message3;
        }
        if (this.lightLevel != null && (message2 = this.checkRequiredProperty(context, this.lightLevel, this.getMessage(context, "light"), location == null ? null : Double.valueOf(location.getBlock().getLightLevel()))) != null) {
            return message2;
        }
        if (this.height != null && (message2 = this.checkRequiredProperty(context, this.height, this.getMessage(context, "height"), location == null ? null : Double.valueOf(location.getY()))) != null) {
            return message2;
        }
        if (this.currency != null && (message2 = this.checkRequiredProperty(context, this.currency, this.getMessage(context, "currency"), mage.getCurrency(this.currencyType))) != null) {
            return message2;
        }
        if (this.castSpell != null) {
            MageSpell mageSpell;
            String spellName = "Unknown";
            SpellTemplate template2 = controller.getSpellTemplate(this.castSpell);
            if (template2 != null) {
                spellName = template2.getName();
            }
            if ((mageSpell = mage.getSpell(this.castSpell)) == null) {
                return this.getMessage(context, "no_cast").replace("$spell", spellName);
            }
            long lastCast = mageSpell.getLastCast();
            if (lastCast == 0L) {
                return this.getMessage(context, "no_cast").replace("$spell", spellName);
            }
            if (this.castTimeout > 0 && System.currentTimeMillis() - lastCast > (long)this.castTimeout) {
                return this.getMessage(context, "no_cast").replace("$spell", spellName);
            }
        }
        if (!(this.requiredTemplate == null || (template = wand.getTemplateKey()) != null && template.equals(this.requiredTemplate))) {
            return this.getMessage(context, "no_template").replace("$wand", wand.getName());
        }
        if (!(this.requiredTemplates == null || (template = wand.getTemplateKey()) != null && this.requiredTemplates.contains(template))) {
            return this.getMessage(context, "no_template").replace("$wand", wand.getName());
        }
        if (this.wandTags != null && !this.hasTags(wand)) {
            return this.getMessage(context, "no_template").replace("$wand", wand.getName());
        }
        if (this.mageClass != null && !this.mageClass.isEmpty()) {
            boolean hasAny = false;
            for (String string2 : this.mageClass) {
                if (!mage.hasClassUnlocked(string2)) continue;
                hasAny = true;
                break;
            }
            if (!hasAny) {
                return this.getMessage(context, "no_class").replace("$class", this.mageClass.get(0));
            }
        }
        if (this.activeClass != null && !this.activeClass.isEmpty()) {
            MageClass currentClass = mage.getActiveClass();
            boolean hasAny = false;
            if (currentClass != null) {
                for (String testClass : this.activeClass) {
                    if (!currentClass.getKey().equals(testClass)) continue;
                    hasAny = true;
                    break;
                }
            }
            if (!hasAny) {
                return this.getMessage(context, "no_class").replace("$class", this.activeClass.get(0));
            }
        }
        CasterProperties checkProperties = context.getActiveProperties();
        ProgressionPath path = checkProperties.getPath();
        if (this.requiredPath != null || this.exactPath != null) {
            String pathName;
            if (path == null) {
                return this.getMessage(context, "no_path");
            }
            if (this.requiredPath != null && !path.hasPath(this.requiredPath)) {
                WandUpgradePath wandUpgradePath = controller.getPath(this.requiredPath);
                pathName = this.requiredPath;
                if (wandUpgradePath != null) {
                    pathName = wandUpgradePath.getName();
                } else if (!this.ignoreMissing) {
                    context.getLogger().warning("Invalid path specified in requirement " + this.requiredPath);
                }
                return this.getMessage(context, "no_required_path").replace("$path", pathName);
            }
            if (this.exactPath != null && !this.exactPath.equals(path.getKey())) {
                WandUpgradePath wandUpgradePath = controller.getPath(this.exactPath);
                pathName = this.exactPath;
                if (wandUpgradePath != null) {
                    pathName = wandUpgradePath.getName();
                } else if (!this.ignoreMissing) {
                    context.getLogger().warning("Invalid path specified in requirement: " + this.exactPath);
                }
                return this.getMessage(context, "no_path_exact").replace("$path", pathName);
            }
            if (this.requiresCompletedPath != null) {
                void var9_26;
                boolean bl = false;
                if (path.hasPath(this.requiresCompletedPath)) {
                    if (path.getKey().equals(this.requiresCompletedPath)) {
                        boolean bl2 = !path.canProgress(checkProperties);
                    } else {
                        boolean bl3 = true;
                    }
                }
                if (var9_26 == false) {
                    requiresPath = controller.getPath(this.requiresCompletedPath);
                    String pathName2 = this.requiresCompletedPath;
                    if (requiresPath != null) {
                        pathName2 = requiresPath.getName();
                    } else if (!this.ignoreMissing) {
                        context.getLogger().warning("Invalid path specified in requirement: " + this.exactPath);
                    }
                    return this.getMessage(context, "no_path_end").replace("$path", pathName2);
                }
            }
        }
        if (this.wandProperties != null && (string = this.getRequiredProperty(context, wand, this.wandProperties)) != null) {
            return string;
        }
        if (this.classProperties != null) {
            void var9_29;
            MageClass mageClass = mage.getActiveClass();
            if (this.mageClass != null) {
                String tryClass;
                MageClass mageClass2;
                requiresPath = this.mageClass.iterator();
                while (requiresPath.hasNext() && (mageClass2 = mage.getClass(tryClass = requiresPath.next())) == null) {
                }
            }
            if (var9_29 == null) {
                return this.getMessage(context, "no_path");
            }
            String message4 = this.getRequiredProperty(context, (CasterProperties)var9_29, this.classProperties);
            if (message4 != null) {
                return message4;
            }
        }
        if (this.attributes != null) {
            for (PropertyRequirement requirement : this.attributes) {
                message = this.checkRequiredProperty(context, requirement, key = requirement.key, value = context.getAttribute(key));
                if (message == null) continue;
                return message;
            }
        }
        if (this.variables != null) {
            for (PropertyRequirement requirement : this.variables) {
                message = this.checkRequiredProperty(context, requirement, key = requirement.key, value = context.getVariable(key));
                if (message == null) continue;
                return message;
            }
        }
        return null;
    }

    @Nullable
    protected String getRequiredProperty(CastContext context, CasterProperties properties, List<PropertyRequirement> requirements) {
        for (PropertyRequirement requirement : requirements) {
            String message;
            String key = requirement.key;
            Double value = properties.hasProperty(key) ? properties.getProperty(key, 0.0) : null;
            String messageKey = "wand." + key;
            String name = key;
            if (this.controller.getMessages().containsKey(messageKey)) {
                name = this.controller.getMessages().getLevelString(messageKey, value == null ? 0.0f : (float)value.doubleValue());
            }
            if ((message = this.checkRequiredProperty(context, requirement, name, value)) == null) continue;
            return message;
        }
        return null;
    }

    @Nullable
    protected String checkRequiredProperty(CastContext context, RangedRequirement requirement, String name, Double value) {
        if (!(requirement.value == null || value != null && value.equals(requirement.value))) {
            return this.getMessage(context, "property_requirement").replace("$property", name).replace("$value", Double.toString(requirement.value));
        }
        if (requirement.min != null && (value == null || value <= requirement.min)) {
            return this.getMessage(context, "property_min").replace("$property", name).replace("$value", Double.toString(requirement.min));
        }
        if (requirement.max != null && value != null && value >= requirement.max) {
            return this.getMessage(context, "property_max").replace("$property", name).replace("$value", Double.toString(requirement.max));
        }
        return null;
    }

    protected boolean hasTags(Wand wand) {
        for (String checkTag : this.wandTags) {
            if (!wand.hasTag(checkTag)) continue;
            return true;
        }
        return false;
    }
}

