/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.materials;

import com.elmakers.mine.bukkit.api.magic.MaterialMap;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.MaterialSetManager;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.materials.MaterialSets;
import com.elmakers.mine.bukkit.materials.SimpleMaterialMap;
import com.elmakers.mine.bukkit.materials.Union;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;

public final class SimpleMaterialSetManager
implements MaterialSetManager {
    private Logger log;
    private Map<String, MaterialSet> materialSets = new HashMap<String, MaterialSet>();
    private Set<String> unmodifiableMaterialSetKeys = Collections.unmodifiableSet(this.materialSets.keySet());
    private ConfigurationSection loading;
    private Set<String> loadingStack = new LinkedHashSet<String>();

    @Override
    public Collection<String> getMaterialSets() {
        return this.unmodifiableMaterialSetKeys;
    }

    @Override
    @Nullable
    public MaterialSet getMaterialSet(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        MaterialSet existing = this.materialSets.get(name);
        if (existing == null && this.loading != null && this.loading.getKeys(false).contains(name)) {
            if (this.loadingStack.contains(name)) {
                Bukkit.getLogger().info("Keys: " + this.loading.getKeys(false));
                throw new IllegalStateException("Circular dependency detected in material configs: " + StringUtils.join(this.loadingStack, (String)" -> ") + " -> " + name);
            }
            this.loadingStack.add(name);
            MaterialSet set = this.createMaterialSet(this.loading, name);
            if (set != null) {
                this.materialSets.put(name, set);
            }
            this.loadingStack.remove(name);
            return set;
        }
        return existing;
    }

    @Override
    public MaterialSet getMaterialSet(String name, MaterialSet fallback) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)fallback, (Object)"fallback");
        MaterialSet set = this.getMaterialSet(name);
        return set != null ? set : fallback;
    }

    @Override
    public MaterialSet getMaterialSetEmpty(String name) {
        return this.getMaterialSet(name, MaterialSets.empty());
    }

    @Override
    @Nullable
    public MaterialMap getMaterialMap(@Nonnull String name) {
        MaterialSet existing = this.materialSets.get(name);
        return existing == null || !(existing instanceof MaterialMap) ? null : (MaterialMap)existing;
    }

    @Override
    @Nullable
    public MaterialSet fromConfig(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        MaterialSet materials = this.materialSets.get(name);
        if (materials == null) {
            materials = this.createMaterialSetFromString(name);
            this.materialSets.put(name, materials);
        }
        return materials;
    }

    @Override
    public MaterialSet fromConfig(String name, MaterialSet fallback) {
        MaterialSet v = this.fromConfig(name);
        return v != null ? v : fallback;
    }

    @Override
    public MaterialSet fromConfigEmpty(String name) {
        return this.fromConfig(name, MaterialSets.empty());
    }

    @Override
    @Nullable
    public MaterialMap mapFromConfig(ConfigurationSection configuration, String key) {
        ConfigurationSection adhoc = configuration.getConfigurationSection(key);
        if (adhoc != null) {
            return this.createMaterialMap(adhoc);
        }
        return this.getMaterialMap(configuration.getString(key));
    }

    public void loadMaterials(ConfigurationSection materialNode) {
        this.loading = materialNode;
        Set keys = materialNode.getKeys(false);
        for (String key : keys) {
            this.loadingStack.clear();
            this.loadingStack.add(key);
            MaterialSet set = this.createMaterialSet(materialNode, key);
            if (set == null) continue;
            this.materialSets.put(key, set);
        }
        this.loadingStack.clear();
        this.loading = null;
    }

    private MaterialSet createMaterialSetFromString(String materialSet) {
        boolean negate;
        String materialString;
        if (materialSet.equals("*")) {
            return MaterialSets.wildcard();
        }
        if (materialSet.startsWith("!")) {
            materialString = materialSet.substring(1);
            negate = true;
        } else {
            materialString = materialSet;
            negate = false;
        }
        String[] names = StringUtils.split((String)materialString, (char)',');
        MaterialSet created = this.createMaterialSetFromStringList(Arrays.asList(names));
        return negate ? created.not() : created;
    }

    @Nullable
    private MaterialSet parseMaterialSet(String materialSet) {
        boolean negate;
        String materialString;
        if (materialSet.startsWith("!")) {
            materialString = materialSet.substring(1);
            negate = true;
        } else {
            materialString = materialSet;
            negate = false;
        }
        MaterialSet existing = null;
        if (materialSet.equals("*")) {
            return MaterialSets.wildcard();
        }
        existing = this.getMaterialSet(materialString);
        if (existing == null) {
            this.warning("Invalid material set: " + materialSet);
            return null;
        }
        return negate ? existing.not() : existing;
    }

    @Nullable
    private MaterialSet createMaterialSet(ConfigurationSection node, String key) {
        if (node.isString(key)) {
            return this.createMaterialSetFromString(node.getString(key));
        }
        ConfigurationSection section = node.getConfigurationSection(key);
        if (section != null) {
            return this.createMaterialMap(section);
        }
        List materialData = node.getStringList(key);
        if (materialData == null) {
            this.warning("Unexpected config type for material set '" + key + "': " + node.get(key));
            return null;
        }
        return this.createMaterialSetFromStringList(materialData);
    }

    private MaterialMap createMaterialMap(ConfigurationSection section) {
        HashMap<Material, MaterialAndData> materialMap = new HashMap<Material, MaterialAndData>();
        Set keys = section.getKeys(false);
        for (String key : keys) {
            Material material = ConfigurationUtils.toMaterial(key);
            if (material == null) {
                this.warning("Invalid material key in map: " + key);
                continue;
            }
            String valueKey = section.getString(key);
            MaterialAndData toMaterial = ConfigurationUtils.toMaterialAndData(valueKey);
            if (toMaterial == null || !toMaterial.isValid()) {
                this.warning("Invalid material value in map: " + valueKey);
                continue;
            }
            materialMap.put(material, toMaterial);
        }
        return new SimpleMaterialMap(materialMap);
    }

    private MaterialSet createMaterialSetFromStringList(List<String> names) {
        Union union = MaterialSets.unionBuilder();
        for (String matName : names) {
            MaterialAndData material;
            MaterialSet resolved = this.parseMaterialSet(matName);
            if (resolved != null) {
                union.add(resolved);
                continue;
            }
            if (matName.contains("|") || matName.contains(":")) {
                material = ConfigurationUtils.toMaterialAndData(matName);
                if (material != null && material.isValid()) {
                    union.add(material);
                    continue;
                }
                this.warning("Invalid material value in list: " + matName);
                continue;
            }
            material = ConfigurationUtils.toMaterial(matName);
            if (material != null) {
                union.add((Material)material);
                continue;
            }
            this.warning("Invalid material value in list: " + matName);
        }
        return union.build();
    }

    protected void warning(String message) {
        if (this.log != null) {
            this.log.warning(message);
        }
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }
}

