/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.SpellCategory;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.citizens.CitizensController;
import com.elmakers.mine.bukkit.magic.CasterProperties;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.CastCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MageCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicAutomataCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicConfigCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicGiveCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicItemCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicMapCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicMobCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicNPCCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicSaveCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicServerCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicSkillsCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicTraitCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.MagicWarpCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.RPCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.SpellsCommandExecutor;
import com.elmakers.mine.bukkit.magic.command.WandCommandExecutor;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MagicPlugin
extends JavaPlugin
implements MagicAPI {
    private static MagicPlugin instance;
    private MagicController controller = null;

    public MagicPlugin() {
        instance = this;
    }

    public void onLoad() {
        if (this.controller == null) {
            this.controller = new MagicController(this);
        }
        if (!this.controller.registerNMSBindings()) {
            this.controller = null;
        } else {
            this.controller.initializeWorldGuardFlags();
        }
    }

    public void onEnable() {
        if (this.controller == null) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[Magic] Something went wrong with some Deep Magic, plugin will not load.");
            Bukkit.getConsoleSender().sendMessage(ChatColor.DARK_RED + "[Magic] Please make sure you are running a compatible version of " + ChatColor.RED + "Spigot (1.9 or Higher)!");
        } else {
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            if (NMSUtils.isLegacy()) {
                Bukkit.getConsoleSender().sendMessage(ChatColor.YELLOW + "[Magic] Using backwards-compatibility layer. It is highly recommended that you update to the latest Spigot version and/or the latest Magic version.");
            }
            if (!NMSUtils.isCurrentVersion()) {
                CasterProperties.setLegacyVersion();
            }
            this.initialize();
        }
    }

    protected void initialize() {
        this.controller.initialize();
        new MagicCommandExecutor(this).register(this);
        new MageCommandExecutor(this).register(this);
        new MagicGiveCommandExecutor(this).register(this);
        new MagicItemCommandExecutor(this).register(this);
        new MagicMobCommandExecutor(this).register(this);
        new MagicNPCCommandExecutor(this).register(this);
        new MagicAutomataCommandExecutor(this.controller).register(this);
        new MagicMapCommandExecutor(this).register(this);
        new MagicServerCommandExecutor(this).register(this);
        new MagicSaveCommandExecutor(this).register(this);
        new MagicSkillsCommandExecutor(this).register(this);
        new CastCommandExecutor(this).register(this);
        new WandCommandExecutor(this).register(this);
        new SpellsCommandExecutor(this).register(this);
        new RPCommandExecutor(this).register(this);
        new MagicWarpCommandExecutor(this.controller).register(this);
        CitizensController citizens = this.controller.getCitizens();
        if (citizens != null) {
            new MagicTraitCommandExecutor((MagicAPI)this, citizens).register(this);
        }
        new MagicConfigCommandExecutor((MagicAPI)this, this.controller).register(this);
    }

    public void onDisable() {
        if (this.controller != null && this.controller.isLoaded()) {
            this.controller.onShutdown();
            this.controller.undoScheduled();
            this.controller.save();
            this.controller.clear();
        }
    }

    @Override
    public Plugin getPlugin() {
        return this;
    }

    @Override
    public boolean hasPermission(CommandSender sender, String pNode) {
        return this.controller.hasPermission(sender, pNode);
    }

    @Override
    public boolean hasPermission(CommandSender sender, String pNode, boolean defaultPermission) {
        return this.controller.hasPermission(sender, pNode, defaultPermission);
    }

    @Override
    public void save() {
        this.controller.save();
    }

    @Override
    public void reload() {
        this.controller.loadConfiguration();
    }

    @Override
    public void reload(CommandSender sender) {
        this.controller.loadConfiguration(sender);
    }

    @Override
    public void clearCache() {
        this.controller.clearCache();
    }

    @Override
    public boolean commit() {
        return this.controller.commitAll();
    }

    @Override
    @Deprecated
    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getMages() {
        return this.controller.getMages();
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getMagesWithPendingBatches() {
        ArrayList<com.elmakers.mine.bukkit.api.magic.Mage> mages = new ArrayList<com.elmakers.mine.bukkit.api.magic.Mage>();
        Collection<com.elmakers.mine.bukkit.api.magic.Mage> internal = this.controller.getPending();
        mages.addAll(internal);
        return mages;
    }

    @Override
    public Collection<UndoList> getPendingUndo() {
        ArrayList<UndoList> undo = new ArrayList<UndoList>();
        undo.addAll(this.controller.getPendingUndo());
        return undo;
    }

    @Override
    public Collection<LostWand> getLostWands() {
        ArrayList<LostWand> lostWands = new ArrayList<LostWand>();
        lostWands.addAll(this.controller.getLostWands());
        return lostWands;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.magic.Mage> getAutomata() {
        ArrayList<com.elmakers.mine.bukkit.api.magic.Mage> automata = new ArrayList<com.elmakers.mine.bukkit.api.magic.Mage>();
        automata.addAll(this.controller.getAutomataMages());
        return automata;
    }

    @Override
    public void removeLostWand(String id) {
        this.controller.removeLostWand(id);
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand getWand(ItemStack itemStack) {
        return this.controller.getWand(itemStack);
    }

    @Override
    public boolean isWand(ItemStack item) {
        return Wand.isWand(item);
    }

    @Override
    @Nullable
    public String getSpell(ItemStack item) {
        return Wand.getSpell(item);
    }

    @Override
    public boolean isBrush(ItemStack item) {
        return Wand.isBrush(item);
    }

    @Override
    public boolean isSpell(ItemStack item) {
        return Wand.isSpell(item);
    }

    @Override
    @Nullable
    public String getBrush(ItemStack item) {
        return Wand.getBrush(item);
    }

    @Override
    public boolean isUpgrade(ItemStack item) {
        return Wand.isUpgrade(item);
    }

    @Override
    public void giveItemToPlayer(Player player, ItemStack itemStack) {
        this.controller.giveItemToPlayer(player, itemStack);
    }

    @Override
    public void giveExperienceToPlayer(Player player, int xp) {
        Mage mage = this.controller.getRegisteredMage((Entity)player);
        if (mage != null) {
            mage.giveExperience(xp);
        } else {
            player.giveExp(xp);
        }
    }

    @Override
    @Deprecated
    public com.elmakers.mine.bukkit.api.magic.Mage getMage(CommandSender sender) {
        return this.controller.getMage(sender);
    }

    @Override
    @Deprecated
    public com.elmakers.mine.bukkit.api.magic.Mage getMage(Entity entity, CommandSender sender) {
        return this.controller.getMage(entity);
    }

    @Override
    public String describeItem(ItemStack item) {
        return this.controller.describeItem(item);
    }

    @Override
    public boolean takeItem(Player player, ItemStack item) {
        return this.controller.takeItem(player, item);
    }

    @Override
    public boolean hasItem(Player player, ItemStack item) {
        return this.controller.hasItem(player, item);
    }

    @Override
    @Nullable
    public ItemStack createItem(String magicKey) {
        return this.createItem(magicKey, null);
    }

    @Override
    @Nullable
    public ItemStack createItem(String magicKey, com.elmakers.mine.bukkit.api.magic.Mage mage) {
        if (this.controller == null) {
            this.getLogger().log(Level.WARNING, "Calling API before plugin is initialized");
            return null;
        }
        return this.controller.createItem(magicKey, mage, false, null);
    }

    @Override
    @Nullable
    public ItemStack createGenericItem(String itemKey) {
        return this.controller.createItem(itemKey);
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.wand.Wand createWand(String wandKey) {
        return Wand.createWand(this.controller, wandKey);
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand createWand(Material iconMaterial, short iconData) {
        return new Wand(this.controller, iconMaterial, iconData);
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.wand.Wand createWand(ItemStack item) {
        return Wand.createWand(this.controller, item);
    }

    @Override
    public com.elmakers.mine.bukkit.api.wand.Wand createUpgrade(String wandKey) {
        Wand wand = Wand.createWand(this.controller, wandKey);
        if (!wand.isUpgrade()) {
            wand.makeUpgrade();
        }
        return wand;
    }

    @Override
    public String getItemKey(ItemStack item) {
        return this.controller.getItemKey(item);
    }

    @Override
    @Nullable
    public ItemStack createSpellItem(String spellKey) {
        return Wand.createSpellItem(spellKey, this.controller, null, true);
    }

    @Override
    @Nullable
    public ItemStack createBrushItem(String brushKey) {
        return Wand.createBrushItem(brushKey, this.controller, null, true);
    }

    @Override
    public boolean cast(String spellName, String[] parameters) {
        return this.cast(spellName, parameters, (CommandSender)Bukkit.getConsoleSender(), null);
    }

    @Override
    public boolean cast(String spellName, String[] parameters, CommandSender sender, Entity entity) {
        ConfigurationSection config = null;
        if (parameters != null && parameters.length > 0) {
            config = ConfigurationUtils.newConfigurationSection();
            ConfigurationUtils.addParameters(parameters, config);
        }
        return this.controller.cast(null, spellName, config, sender, entity);
    }

    @Override
    public boolean cast(String spellName, ConfigurationSection parameters, CommandSender sender, Entity entity) {
        return this.controller.cast(null, spellName, parameters, sender, entity);
    }

    @Override
    public Collection<SpellTemplate> getSpellTemplates() {
        return this.controller.getSpellTemplates();
    }

    @Override
    public Collection<SpellTemplate> getSpellTemplates(boolean showHidden) {
        return this.controller.getSpellTemplates(showHidden);
    }

    @Override
    public Collection<String> getWandKeys() {
        return this.controller.getWandTemplateKeys();
    }

    @Override
    public Collection<String> getPlayerNames() {
        return this.controller.getPlayerNames();
    }

    @Override
    @Nullable
    public SpellTemplate getSpellTemplate(String key) {
        return this.controller.getSpellTemplate(key);
    }

    @Override
    public Collection<String> getSchematicNames() {
        return this.controller.getSchematicNames();
    }

    @Override
    public Collection<String> getBrushes() {
        return this.controller.getBrushKeys();
    }

    @Override
    public MageController getController() {
        return this.controller;
    }

    @Override
    public ItemStack getSpellBook(SpellCategory category, int count) {
        return this.controller.getSpellBook(category, count);
    }

    @Override
    public Messages getMessages() {
        return this.controller.getMessages();
    }

    public static MagicAPI getAPI() {
        return instance;
    }
}

