/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.configuration;

import com.elmakers.mine.bukkit.configuration.ParameterizedConfigurationSection;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationStore;
import com.elmakers.mine.bukkit.slikey.effectlib.math.EquationTransform;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationOptions;
import org.bukkit.configuration.ConfigurationSection;

public abstract class ParameterizedConfiguration
extends ParameterizedConfigurationSection
implements Configuration {
    private Options options;
    private String context;

    protected ParameterizedConfiguration(String context) {
        this.context = context;
    }

    protected ParameterizedConfiguration(ParameterizedConfiguration copy) {
        this(copy.context);
    }

    @Nullable
    public ConfigurationSection getParent() {
        return null;
    }

    public void addDefaults(Map<String, Object> map) {
    }

    public void addDefaults(Configuration configuration) {
    }

    public void setDefaults(Configuration configuration) {
    }

    @Nullable
    public Configuration getDefaults() {
        return null;
    }

    public ConfigurationOptions options() {
        if (this.options == null) {
            this.options = new Options(this);
        }
        return this.options;
    }

    @Nullable
    protected Double evaluate(String expression) {
        Set<String> parameters = this.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        EquationTransform transform = EquationStore.getInstance().getTransform(expression, parameters);
        for (String parameter : transform.getParameters()) {
            double value = this.getParameter(parameter);
            transform.setVariable(parameter, value);
        }
        double value = transform.get();
        Exception ex = transform.getException();
        if (ex != null) {
            ParameterizedConfiguration.warn("Error evaluating transform in '" + this.context + "': '" + expression + "': " + ex.getMessage());
        }
        return Double.isNaN(value) || Double.isInfinite(value) ? 0.0 : value;
    }

    protected abstract Set<String> getParameters();

    protected abstract double getParameter(String var1);

    private static class Options
    extends ConfigurationOptions {
        protected Options(Configuration configuration) {
            super(configuration);
        }
    }
}

