/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.populator.builtin;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.magic.MaterialMap;
import com.elmakers.mine.bukkit.world.populator.MagicBlockPopulator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class ReplacePopulator
extends MagicBlockPopulator {
    private static final int WARNING_INTERVAL = 10000;
    private MaterialMap replaceMap = null;
    private Map<Biome, Biome> replaceBiomes = null;
    private int maxY = 128;
    private int minY = 3;
    private long lastBiomeWarning;

    @Override
    public boolean onLoad(ConfigurationSection config) {
        this.replaceMap = null;
        this.replaceBiomes = null;
        this.maxY = config.getInt("max_y");
        if (this.maxY == 0) {
            this.maxY = 128;
        }
        this.minY = config.getInt("min_y");
        if (this.minY == 0) {
            this.minY = 3;
        }
        this.replaceMap = this.controller.getMaterialSetManager().mapFromConfig(config, "replace");
        ConfigurationSection replaceBiomeSection = config.getConfigurationSection("replace_biomes");
        if (replaceBiomeSection != null) {
            this.replaceBiomes = new HashMap<Biome, Biome>();
            Set biomeKeys = replaceBiomeSection.getKeys(false);
            for (String biomeKey : biomeKeys) {
                Biome toBiome;
                Biome biome;
                String toBiomeKey = replaceBiomeSection.getString(biomeKey);
                try {
                    biome = Biome.valueOf((String)biomeKey.toUpperCase());
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning("Invalid biome: " + biomeKey);
                    continue;
                }
                try {
                    toBiome = Biome.valueOf((String)toBiomeKey.toUpperCase());
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning("Invalid biome: " + toBiomeKey);
                    continue;
                }
                this.replaceBiomes.put(biome, toBiome);
            }
        }
        return this.replaceMap != null || this.replaceBiomes != null;
    }

    @Override
    @Nullable
    public MaterialAndData populate(Block block, Random random) {
        block4: {
            Biome newBiome;
            if (block.getY() < this.minY || block.getY() > this.maxY) {
                return null;
            }
            if (this.replaceBiomes != null && (newBiome = this.replaceBiomes.get(block.getBiome())) != null) {
                try {
                    block.setBiome(newBiome);
                }
                catch (Exception ex) {
                    long now = System.currentTimeMillis();
                    if (now - this.lastBiomeWarning <= 10000L) break block4;
                    this.lastBiomeWarning = now;
                    this.controller.getLogger().warning("Could not set biome to " + newBiome);
                }
            }
        }
        return this.replaceMap == null ? null : this.replaceMap.get(block.getType());
    }
}

