/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.populator;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.block.ModifyType;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.world.populator.MagicChunkPopulator;
import java.util.Random;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public abstract class MagicBlockPopulator
extends MagicChunkPopulator {
    private int maxY = 255;
    private int minY = 0;
    private int maxAirY = 255;
    private ModifyType modifyType = ModifyType.NO_PHYSICS;

    @Override
    public boolean load(ConfigurationSection config, MagicController controller) {
        if (!super.load(config, controller)) {
            return false;
        }
        this.maxY = config.getInt("max_y", this.maxY);
        this.minY = config.getInt("min_y", this.minY);
        this.maxAirY = config.getInt("max_air_y", this.maxAirY);
        String modifyType = config.getString("modifyType", null);
        if (modifyType != null && !modifyType.isEmpty()) {
            this.modifyType = ModifyType.valueOf(modifyType.toUpperCase());
        }
        return true;
    }

    public void populate(World world, Random random, Chunk chunk) {
        for (int x = 0; x <= 15; ++x) {
            block1: for (int z = 0; z <= 15; ++z) {
                for (int y = this.minY; y <= this.maxY; ++y) {
                    Block block = chunk.getBlock(x, y, z);
                    if (y > this.maxAirY && block.getType() == Material.AIR) continue block1;
                    MaterialAndData newMaterial = this.populate(block, random);
                    if (newMaterial == null) continue;
                    newMaterial.modify(block, this.modifyType);
                }
            }
        }
    }

    public abstract MaterialAndData populate(Block var1, Random var2);
}

