/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.item.ItemData;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class ItemController {
    private MageController controller;
    private final Set<String> itemKeys = new HashSet<String>();
    private final Map<String, ItemData> items = new HashMap<String, ItemData>();
    private final Map<ItemStack, ItemData> itemsByStack = new HashMap<ItemStack, ItemData>();

    public ItemController(MageController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection configuration) {
        Set itemKeys = configuration.getKeys(false);
        for (String itemKey : itemKeys) {
            ConfigurationSection itemConfig = configuration.getConfigurationSection(itemKey);
            if (itemConfig != null) {
                this.loadItem(itemKey, itemConfig);
                continue;
            }
            String itemString = configuration.getString(itemKey);
            if (!itemString.isEmpty()) {
                this.loadItem(itemKey, itemString);
                continue;
            }
            this.controller.getLogger().warning("Improperly formatted item: " + itemKey);
        }
    }

    public void loadItem(String itemKey, String material) {
        try {
            ItemData magicItem = new ItemData(itemKey, material);
            if (magicItem != null) {
                this.itemKeys.add(itemKey);
                this.items.put(itemKey, magicItem);
                this.itemsByStack.put(magicItem.getItemStack(1), magicItem);
            } else {
                this.controller.getLogger().warning("Could not create item with key " + itemKey + " and material " + material);
            }
        }
        catch (Throwable ex) {
            this.controller.getLogger().log(Level.WARNING, "An error occurred while processing the item: " + itemKey, ex);
        }
    }

    public void loadItem(String itemKey, ConfigurationSection configuration) {
        try {
            ItemData magicItem = new ItemData(itemKey, configuration);
            if (magicItem != null) {
                this.itemKeys.add(itemKey);
                this.items.put(itemKey, magicItem);
                this.itemsByStack.put(magicItem.getItemStack(1), magicItem);
            } else {
                this.controller.getLogger().warning("Could not create item with key " + itemKey);
            }
        }
        catch (Throwable ex) {
            this.controller.getLogger().log(Level.WARNING, "An error occurred while processing the item: " + itemKey, ex);
        }
    }

    public int getCount() {
        return this.items.size();
    }

    public Set<String> getKeys() {
        return this.itemKeys;
    }

    @Nullable
    public ItemData get(String key) {
        String[] pieces;
        ItemData item = this.items.get(key);
        if (item == null && (pieces = StringUtils.split((String)key, (char)':')).length > 1 && (item = this.items.get(pieces[0])) != null) {
            try {
                short damage = Short.parseShort(pieces[1]);
                item = item.createVariant(key, damage);
                if (item != null) {
                    this.items.put(key, item);
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
        return item;
    }

    @Nullable
    public ItemData get(ItemStack item) {
        String key = Wand.getMagicKey(item);
        if (key != null) {
            return this.get(key);
        }
        return this.itemsByStack.get(item);
    }

    @Nullable
    public ItemData getOrCreate(String key) {
        ItemData data = this.get(key);
        if (data == null) {
            try {
                data = new ItemData(key);
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Error creating item: " + key);
            }
        }
        return data;
    }

    public void remove(String key) {
        ItemData existing = this.items.get(key);
        if (existing != null) {
            this.itemsByStack.remove(existing.getItemStack(1));
        }
        this.items.remove(key);
        this.itemKeys.remove(key);
    }
}

