/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.data;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlDataFile
extends YamlConfiguration {
    protected final File file;
    protected final Logger logger;
    protected final boolean checkBackupSize;

    public YamlDataFile(Logger logger, File file) {
        this(logger, file, true);
    }

    public YamlDataFile(Logger logger, File file, boolean checkBackupSize) {
        this.file = file;
        this.logger = logger;
        this.checkBackupSize = checkBackupSize;
    }

    public YamlDataFile(Logger logger, String filename) {
        this.file = new File(filename);
        this.logger = logger;
        this.checkBackupSize = true;
    }

    public void load() {
        try {
            this.load(this.file);
        }
        catch (Exception ex) {
            this.logger.warning(ex.getMessage());
            this.logger.warning("Error loading data file " + this.file.getName());
        }
    }

    public void save() {
        try {
            File targetFile;
            File tempFile = new File(this.file.getAbsolutePath() + ".tmp");
            if (tempFile.exists()) {
                this.logger.warning("Temp file for " + this.file.getName() + "exists, deleting");
                tempFile.delete();
            }
            File backupFile = new File(this.file.getAbsolutePath() + ".bak");
            this.save(tempFile);
            if (this.checkBackupSize && backupFile.exists() && backupFile.length() > tempFile.length()) {
                this.logger.warning("Backup file " + backupFile.getName() + " is larger than " + tempFile.getName());
                int index = 1;
                File saveBackup = new File(backupFile.getAbsolutePath() + "." + index);
                while (saveBackup.exists()) {
                    saveBackup = new File(backupFile.getAbsolutePath() + "." + ++index);
                }
                this.logger.info("This may be normal, but just in case the backup file will be saved permanently as " + saveBackup.getName());
                this.logger.info("If data seems missing, please restore the backup file while the server is shut down");
                backupFile.renameTo(saveBackup);
            }
            if (backupFile.exists()) {
                backupFile.delete();
            }
            if ((targetFile = new File(this.file.getAbsolutePath())).exists()) {
                targetFile.renameTo(backupFile);
            }
            tempFile.renameTo(this.file);
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Error saving data file " + this.file.getName(), ex);
        }
    }

    public File getFile() {
        return this.file;
    }
}

