/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityChestedHorseData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Llama;

public class EntityLlamaData
extends EntityChestedHorseData {
    private Llama.Color color;
    private int strength;

    public EntityLlamaData() {
    }

    public EntityLlamaData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        Logger log = controller.getLogger();
        String colorString = parameters.getString("llama_color");
        if (colorString != null && !colorString.isEmpty()) {
            try {
                this.color = Llama.Color.valueOf((String)colorString.toUpperCase());
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Invalid llama_color: " + colorString, ex);
            }
        }
        this.strength = parameters.getInt("llama_strength", 1);
    }

    public EntityLlamaData(Entity entity) {
        super(entity);
        if (entity instanceof Llama) {
            Llama llama = (Llama)entity;
            this.color = llama.getColor();
            this.strength = llama.getStrength();
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof Llama) {
            Llama llama = (Llama)entity;
            if (this.color != null) {
                llama.setColor(this.color);
            }
            if (this.strength > 0 && this.strength < 6) {
                llama.setStrength(this.strength);
            }
        }
    }
}

