/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.builtin.RideEntityAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class MountArmorStandAction
extends RideEntityAction {
    private boolean armorStandInvisible;
    private boolean armorStandSmall;
    private boolean armorStandMarker;
    private boolean armorStandGravity;
    private boolean mountWand;
    private boolean findWand;
    private double armorStandPitch = 0.0;
    private double armorStandRoll = 0.0;
    private double armorStandHealth = 0.0;
    private ItemStack helmetItem;
    private CreatureSpawnEvent.SpawnReason armorStandSpawnReason = CreatureSpawnEvent.SpawnReason.CUSTOM;
    private ItemStack item;
    private ItemStack replacementItem;
    private int slotNumber;
    private boolean mountTarget = false;
    private String mountName;

    @Override
    public void reset(CastContext context) {
        Entity mount = this.mount;
        super.reset(context);
        this.item = null;
        if (mount != null && !this.mountTarget) {
            mount.remove();
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        ItemData itemType;
        super.prepare(context, parameters);
        MageController controller = context.getController();
        this.mountTarget = parameters.getBoolean("mount_target", false);
        this.armorStandInvisible = parameters.getBoolean("armor_stand_invisible", true);
        this.armorStandSmall = parameters.getBoolean("armor_stand_small", false);
        this.armorStandMarker = parameters.getBoolean("armor_stand_marker", true);
        this.armorStandGravity = parameters.getBoolean("armor_stand_gravity", true);
        this.armorStandPitch = parameters.getDouble("armor_stand_pitch", 0.0);
        this.armorStandRoll = parameters.getDouble("armor_stand_roll", 0.0);
        this.armorStandHealth = parameters.getDouble("armor_stand_health", 0.1);
        this.mountWand = parameters.getBoolean("mount_wand", false);
        this.findWand = parameters.getBoolean("find_wand", false);
        this.mountName = parameters.getString("mount_name", null);
        ItemData replacementType = controller.getOrCreateItemOrWand(parameters.getString("replacement_item"));
        if (replacementType != null) {
            this.replacementItem = replacementType.getItemStack(1);
        }
        if (parameters.contains("armor_stand_reason")) {
            String reasonText = parameters.getString("armor_stand_reason").toUpperCase();
            try {
                this.armorStandSpawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)reasonText);
            }
            catch (Exception ex) {
                context.getMage().sendMessage("Unknown spawn reason: " + reasonText);
            }
        }
        if ((itemType = controller.getOrCreateItemOrWand(parameters.getString("helmet_item"))) != null) {
            this.helmetItem = itemType.getItemStack(1);
            if (this.helmetItem != null) {
                InventoryUtils.makeUnbreakable(InventoryUtils.makeReal(this.helmetItem));
            }
        }
    }

    @Override
    protected void remount(CastContext context) {
        if (this.mountTarget) {
            return;
        }
        if (this.mount != null) {
            this.mount.remove();
        }
        if (this.mountNewArmorStand(context)) {
            this.mount = context.getTargetEntity();
        }
    }

    @Override
    protected void adjustHeading(CastContext context) {
        super.adjustHeading(context);
        float targetPitch = this.targetLocation.getPitch();
        if (this.armorStandPitch != 0.0 || this.armorStandRoll != 0.0) {
            double pitch = this.armorStandPitch * (double)targetPitch / 180.0 * Math.PI;
            double roll = 0.0;
            if (this.armorStandRoll != 0.0) {
                double strafeDirection = context.getMage().getVehicleStrafeDirection();
                roll = this.armorStandRoll * strafeDirection;
            }
            ArmorStand armorStand = (ArmorStand)this.mount;
            armorStand.setHeadPose(new EulerAngle(pitch, 0.0, roll));
        }
    }

    @Override
    protected SpellResult mount(CastContext context) {
        Mage mage = context.getMage();
        Player player = mage.getPlayer();
        if (player == null && this.mountWand) {
            return SpellResult.PLAYER_REQUIRED;
        }
        this.item = null;
        if (this.mountWand) {
            Wand wand = context.getWand();
            if (this.findWand) {
                wand = null;
                MageController controller = context.getController();
                ItemStack[] items = player.getInventory().getContents();
                for (int i = 0; i < items.length; ++i) {
                    Wand candidateWand;
                    String spellKey;
                    ItemStack candidateItem = items[i];
                    if (!controller.isWand(candidateItem) || (spellKey = (candidateWand = controller.getWand(candidateItem)).getActiveSpellKey()) == null || !spellKey.equals(context.getSpell().getSpellKey().getBaseKey())) continue;
                    wand = candidateWand;
                    wand.setHeldSlot(i);
                    break;
                }
            }
            if (wand == null) {
                return SpellResult.NO_TARGET;
            }
            wand.deactivate();
            this.item = wand.getItem();
            if (this.item == null || this.item.getType() == Material.AIR) {
                return SpellResult.FAIL;
            }
            this.slotNumber = wand.getHeldSlot();
        }
        if (!this.mountTarget && !this.mountNewArmorStand(context)) {
            return SpellResult.FAIL;
        }
        if (this.mountWand) {
            ItemStack replacement = this.replacementItem == null ? new ItemStack(Material.AIR) : this.replacementItem;
            player.getInventory().setItem(this.slotNumber, replacement);
        }
        SpellResult result = super.mount(context);
        if (this.mount == null || !(this.mount instanceof ArmorStand)) {
            result = SpellResult.FAIL;
        }
        return result;
    }

    protected boolean mountNewArmorStand(CastContext context) {
        Mage mage = context.getMage();
        Entity entity = context.getEntity();
        ArmorStand armorStand = CompatibilityUtils.createArmorStand(mage.getLocation());
        armorStand.setHealth(this.armorStandHealth);
        CompatibilityUtils.setMaxHealth((Damageable)armorStand, this.armorStandHealth);
        if (this.armorStandInvisible) {
            CompatibilityUtils.setInvisible(armorStand, true);
        }
        if (this.armorStandMarker) {
            armorStand.setMarker(true);
        }
        if (!this.armorStandGravity) {
            armorStand.setGravity(false);
        }
        CompatibilityUtils.setDisabledSlots(armorStand, 0x1F1F00);
        if (this.armorStandSmall) {
            armorStand.setSmall(true);
        }
        CompatibilityUtils.setPersist((Entity)armorStand, false);
        MageController controller = context.getController();
        controller.setForceSpawn(true);
        try {
            CompatibilityUtils.addToWorld(entity.getWorld(), (Entity)armorStand, this.armorStandSpawnReason);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        controller.setForceSpawn(false);
        if (this.mountWand) {
            armorStand.setHelmet(this.item);
        } else if (this.helmetItem != null) {
            armorStand.setHelmet(this.helmetItem);
        }
        if (this.mountName != null && !this.mountName.isEmpty()) {
            armorStand.setCustomName(this.mountName);
        }
        context.setTargetEntity((Entity)armorStand);
        return true;
    }

    @Override
    public void finish(CastContext context) {
        if (!this.mountTarget && this.mount != null) {
            this.mount.remove();
        } else if (this.mount != null && (this.armorStandPitch != 0.0 || this.armorStandRoll != 0.0)) {
            ArmorStand armorStand = (ArmorStand)this.mount;
            armorStand.setHeadPose(new EulerAngle(0.0, 0.0, 0.0));
        }
        super.finish(context);
        Mage mage = context.getMage();
        Player player = mage.getPlayer();
        if (player == null || this.item == null) {
            return;
        }
        ItemStack currentItem = mage.getItem(this.slotNumber);
        if (this.replacementItem != null && context.getController().itemsAreEqual(currentItem, this.replacementItem)) {
            mage.setItem(this.slotNumber, this.item);
        } else if (currentItem != null || mage.hasStoredInventory() || player.isDead()) {
            mage.giveItem(this.item);
        } else {
            player.getInventory().setItem(this.slotNumber, this.item);
        }
        context.checkWand();
        this.item = null;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("armor_stand_invisible");
        parameters.add("armor_stand_small");
        parameters.add("armor_stand_marker");
        parameters.add("armor_stand_gravity");
        parameters.add("armor_stand_reason");
        parameters.add("armor_stand_pitch");
        parameters.add("mount_wand");
        parameters.add("mount_target");
        parameters.add("replacement_item");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("armor_stand_invisible") || parameterKey.equals("armor_stand_marker") || parameterKey.equals("armor_stand_small") || parameterKey.equals("armor_stand_gravity") || parameterKey.equals("mount_target") || parameterKey.equals("mount_wand")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("armor_stand_pitch")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_VECTOR_COMPONENTS));
        } else if (parameterKey.equals("armor_stand_reason")) {
            for (CreatureSpawnEvent.SpawnReason reason : CreatureSpawnEvent.SpawnReason.values()) {
                examples.add(reason.name().toLowerCase());
            }
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

