/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CheckAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.magic.SourceLocation;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class CheckBlockAction
extends CheckAction {
    private MaterialSet allowed;
    private boolean useTarget;
    private BlockFace direction;
    private int directionCount;
    private boolean setTarget;
    private boolean allowBrush;
    private SourceLocation sourceLocation;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.allowed = spell.getController().getMaterialSetManager().fromConfig(parameters.getString("allowed"));
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.useTarget = parameters.getBoolean("use_target", true);
        this.setTarget = parameters.getBoolean("set_target", false);
        this.allowBrush = parameters.getBoolean("allow_brush", false);
        this.sourceLocation = new SourceLocation(parameters.getString("source_location", "BLOCK"), !this.useTarget);
        this.directionCount = parameters.getInt("direction_count", 1);
        String directionString = parameters.getString("direction");
        if (directionString != null && !directionString.isEmpty()) {
            try {
                this.direction = BlockFace.valueOf((String)directionString.toUpperCase());
            }
            catch (Exception ex) {
                context.getLogger().warning("Invalid BlockFace direction: " + directionString);
            }
        }
    }

    @Override
    protected boolean isAllowed(CastContext context) {
        MaterialBrush brush = context.getBrush();
        Block block = this.sourceLocation.getBlock(context);
        if (block == null) {
            return false;
        }
        if (this.direction != null) {
            for (int i = 0; i < this.directionCount; ++i) {
                block = block.getRelative(this.direction);
            }
        }
        boolean isAllowed = false;
        if (this.allowBrush) {
            boolean bl = isAllowed = brush != null && !brush.isDifferent(block);
        }
        if (!isAllowed && this.allowed != null) {
            isAllowed = this.allowed.testBlock(block);
        }
        if (!isAllowed && !this.allowBrush && this.allowed == null) {
            isAllowed = true;
            if (brush != null && brush.isErase()) {
                if (!context.hasBreakPermission(block)) {
                    isAllowed = false;
                }
            } else if (!context.hasBuildPermission(block)) {
                isAllowed = false;
            }
            if (!context.isDestructible(block)) {
                isAllowed = false;
            }
        }
        if (this.setTarget && isAllowed) {
            this.createActionContext(context, context.getEntity(), null, context.getTargetEntity(), block.getLocation());
        }
        return isAllowed;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

