/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BookAction
extends BaseSpellAction {
    @Nonnull
    private String title = "";
    @Nonnull
    private String author = "";
    @Nullable
    private ConfigurationSection pages;
    private boolean giveBook;

    private ItemStack updateBook(CastContext context, Mage targetMage, ItemStack book) {
        BookMeta meta = (BookMeta)book.getItemMeta();
        List<String> pages = this.replaceContents(context, targetMage);
        meta.setTitle(this.title);
        meta.setAuthor(this.author);
        meta.setPages(pages);
        book.setItemMeta((ItemMeta)meta);
        return book;
    }

    private List<String> replaceContents(CastContext context, Mage targetMage) {
        ArrayList<Replacement> replacements = new ArrayList<Replacement>();
        Set<String> attributes = context.getController().getAttributes();
        Set<String> currencies = context.getController().getCurrencyKeys();
        for (String attr : attributes) {
            Double value = targetMage.getAttribute(attr);
            if (value == null) continue;
            replacements.add(new Replacement("$" + attr, Integer.toString((int)Math.ceil(value))));
        }
        for (String currency : currencies) {
            replacements.add(new Replacement("$" + currency, Integer.toString((int)Math.ceil(targetMage.getCurrency(currency)))));
        }
        replacements.add(new Replacement("@tn", targetMage.getName()));
        replacements.add(new Replacement("@td", targetMage.getDisplayName()));
        replacements.add(new Replacement("@p", context.getMage().getName()));
        replacements.add(new Replacement("@pd", context.getMage().getDisplayName()));
        MageClass mageClass = targetMage.getActiveClass();
        String className = mageClass != null ? mageClass.getName() : "";
        ProgressionPath magePath = targetMage.getActiveProperties().getPath();
        String pathName = magePath != null ? magePath.getName() : "";
        replacements.add(new Replacement("$class", className));
        replacements.add(new Replacement("$path", pathName));
        ArrayList<String> newContents = new ArrayList<String>();
        Set pageKeys = this.pages.getKeys(false);
        for (String pageKey : pageKeys) {
            int pageNumber = 0;
            try {
                pageNumber = Integer.parseInt(pageKey) - 1;
            }
            catch (NumberFormatException ex) {
                context.getController().getLogger().warning("Invalid page number: " + pageKey);
                continue;
            }
            String pageText = "";
            List<String> lines = ConfigurationUtils.getStringList(this.pages, pageKey);
            pageText = lines == null ? this.pages.getString(pageKey) : StringUtils.join(lines, (String)"\n");
            for (Replacement replacement : replacements) {
                pageText = pageText.replace(replacement.replace, replacement.with);
            }
            while (newContents.size() <= pageNumber) {
                newContents.add("");
            }
            newContents.set(pageNumber, ChatColor.translateAlternateColorCodes((char)'&', (String)pageText));
        }
        return newContents;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        Messages messages = context.getController().getMessages();
        String titleParam = parameters.getString("title", "");
        String authorParam = parameters.getString("author", context.getMage().getName());
        this.title = messages.get(titleParam, ChatColor.translateAlternateColorCodes((char)'&', (String)titleParam));
        this.author = messages.get(authorParam, ChatColor.translateAlternateColorCodes((char)'&', (String)authorParam));
        this.pages = parameters.getConfigurationSection("pages");
        this.giveBook = parameters.getBoolean("give_book", false);
    }

    public SpellResult performGive(CastContext context) {
        Entity target = context.getTargetEntity();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        if (!(target instanceof InventoryHolder)) {
            return SpellResult.NO_TARGET;
        }
        Mage targetMage = context.getController().getMage(target);
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK);
        this.updateBook(context, targetMage, book);
        targetMage.giveItem(book);
        return SpellResult.CAST;
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (this.pages == null) {
            return SpellResult.FAIL;
        }
        if (this.giveBook) {
            return this.performGive(context);
        }
        Mage mage = context.getMage();
        Wand wand = context.getWand();
        if (wand == null || wand.getItem().getType() != Material.WRITTEN_BOOK) {
            return SpellResult.NO_TARGET;
        }
        ItemStack book = wand.getItem();
        this.updateBook(context, mage, book);
        if (wand == mage.getActiveWand()) {
            mage.getPlayer().getInventory().setItemInMainHand(wand.getItem());
        } else if (wand == mage.getOffhandWand()) {
            mage.getPlayer().getInventory().setItemInOffHand(wand.getItem());
        }
        return SpellResult.CAST;
    }

    private static class Replacement {
        public String replace;
        public String with;

        public Replacement(String replace, String with) {
            this.replace = replace;
            this.with = with;
        }
    }
}

