/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.spawn;

import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.world.spawn.SpawnResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;

public abstract class SpawnRule
implements Comparable<SpawnRule> {
    protected MagicController controller;
    protected String key;
    protected final List<EntityType> targetEntityTypes = new ArrayList<EntityType>();
    protected Class<? extends Entity> targetEntityClass;
    protected float percentChance;
    protected int minY;
    protected int maxY;
    protected int cooldown;
    protected int priority;
    protected long lastSpawn;
    protected boolean allowIndoors;
    protected boolean targetCustom;
    protected boolean targetNPC;
    protected ConfigurationSection parameters;
    protected Set<String> tags;
    protected Set<Biome> biomes;
    protected Set<Biome> notBiomes;
    protected boolean isGlobal;
    protected static final Random rand = new Random();

    @Nonnull
    public abstract SpawnResult onProcess(Plugin var1, LivingEntity var2);

    public void finalizeLoad(String worldName) {
    }

    @Nullable
    protected Set<Biome> loadBiomes(List<String> biomeNames) {
        if (biomeNames == null || biomeNames.isEmpty()) {
            return null;
        }
        HashSet<Biome> set = new HashSet<Biome>();
        for (String biomeName : biomeNames) {
            try {
                Biome biome = Biome.valueOf((String)biomeName.trim().toUpperCase());
                set.add(biome);
            }
            catch (Exception ex) {
                this.controller.getLogger().warning(" Invalid biome: " + biomeName);
            }
        }
        return set;
    }

    public boolean load(String key, ConfigurationSection parameters, MagicController controller) {
        this.parameters = parameters;
        this.key = key;
        this.controller = controller;
        this.isGlobal = true;
        List entityTypes = parameters.getStringList("target_types");
        String entityTypeName = parameters.getString("target_type");
        if (!(entityTypeName == null || entityTypeName.isEmpty() || entityTypeName.equals("*") || entityTypeName.equalsIgnoreCase("all"))) {
            entityTypes.add(entityTypeName);
        }
        for (String entityType : entityTypes) {
            this.isGlobal = false;
            EntityType targetType = EntityData.parseEntityType(entityType);
            if (targetType == null) {
                this.controller.getLogger().warning(" Invalid entity type: " + entityTypeName);
                continue;
            }
            this.targetEntityTypes.add(targetType);
        }
        String entityClassName = parameters.getString("target_class");
        if (entityClassName != null && !entityClassName.isEmpty()) {
            try {
                this.targetEntityClass = Class.forName("org.bukkit.entity." + entityClassName);
            }
            catch (Throwable ex) {
                controller.getLogger().warning("Unknown entity class in target_class of " + this.getKey() + ": " + entityClassName);
                this.targetEntityClass = null;
            }
        }
        this.targetCustom = parameters.getBoolean("target_custom", false);
        this.targetNPC = parameters.getBoolean("target_npc", false);
        this.allowIndoors = parameters.getBoolean("allow_indoors", true);
        this.minY = parameters.getInt("min_y", 0);
        this.maxY = parameters.getInt("max_y", 255);
        this.percentChance = (float)parameters.getDouble("probability", 1.0);
        this.cooldown = parameters.getInt("cooldown", 0);
        this.priority = parameters.getInt("priority", 0);
        List<String> tagList = ConfigurationUtils.getStringList(parameters, "tags");
        if (tagList != null && !tagList.isEmpty()) {
            this.tags = new HashSet<String>(tagList);
        }
        this.biomes = this.loadBiomes(ConfigurationUtils.getStringList(parameters, "biomes"));
        this.notBiomes = this.loadBiomes(ConfigurationUtils.getStringList(parameters, "not_biomes"));
        this.priority = parameters.getInt("priority");
        return true;
    }

    public List<EntityType> getTargetTypes() {
        return this.targetEntityTypes;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public String getKey() {
        return this.key;
    }

    @Nonnull
    public SpawnResult process(Plugin plugin, LivingEntity entity) {
        Block highest;
        if (this.targetEntityClass != null && !this.targetEntityClass.isAssignableFrom(entity.getClass())) {
            return SpawnResult.SKIP;
        }
        if (!this.targetCustom && entity.getCustomName() != null) {
            return SpawnResult.SKIP;
        }
        if (!this.targetNPC && this.controller.isNPC((Entity)entity)) {
            return SpawnResult.SKIP;
        }
        if (this.percentChance < rand.nextFloat()) {
            return SpawnResult.SKIP;
        }
        long now = System.currentTimeMillis();
        if (this.cooldown > 0 && this.lastSpawn != 0L && now < this.lastSpawn + (long)this.cooldown) {
            return SpawnResult.SKIP;
        }
        Location entityLocation = entity.getLocation();
        int y = entityLocation.getBlockY();
        if (y < this.minY || y > this.maxY) {
            return SpawnResult.SKIP;
        }
        if (this.tags != null && !this.controller.inTaggedRegion(entity.getLocation(), this.tags)) {
            return SpawnResult.SKIP;
        }
        if (this.biomes != null && !this.biomes.contains(entity.getLocation().getBlock().getBiome())) {
            return SpawnResult.SKIP;
        }
        if (this.notBiomes != null && this.notBiomes.contains(entity.getLocation().getBlock().getBiome())) {
            return SpawnResult.SKIP;
        }
        if (!this.allowIndoors && (double)(highest = entityLocation.getWorld().getHighestBlockAt(entityLocation)).getY() - entityLocation.getY() > 3.0) {
            return SpawnResult.SKIP;
        }
        this.lastSpawn = now;
        return this.onProcess(plugin, entity);
    }

    @Override
    public int compareTo(SpawnRule other) {
        if (this.priority > other.priority) {
            return -1;
        }
        if (this.priority < other.priority) {
            return 1;
        }
        return this.key.compareTo(other.key);
    }

    protected String getTargetEntityTypeName() {
        if (this.targetEntityClass != null) {
            return "entities of class " + this.targetEntityClass.getSimpleName();
        }
        return this.targetEntityTypes.isEmpty() ? "all entities" : StringUtils.join(this.targetEntityTypes, (String)",");
    }

    protected void logSpawnRule(String message) {
        if (this.minY > 0) {
            message = message + " at y > " + this.minY;
        }
        if (this.percentChance < 1.0f) {
            message = message + " at a " + this.percentChance * 100.0f + "% chance";
        }
        if (this.tags != null) {
            message = message + " in regions tagged with any of " + this.tags.toString();
        }
        if (this.biomes != null) {
            message = message + " in biomes " + this.biomes.toString();
        }
        if (this.notBiomes != null) {
            message = message + " not in biomes " + this.notBiomes.toString();
        }
        this.controller.info(message);
    }
}

