/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.MaterialSetManager;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.spell.builtin.SimulateSpell;
import com.elmakers.mine.bukkit.utility.AscendingPair;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.TextUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class AnimateSpell
extends SimulateSpell {
    private static Random random = new Random();
    private Deque<WeightedPair<Integer>> levelWeights = null;
    public static final String[] ANIMATE_PARAMETERS = new String[]{"animate", "sim_check_destructible", "seed_radius", "restricted", "obworld", "btarget"};

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        String message;
        if (parameters.getString("animate", null) != null) {
            return super.onCast(parameters);
        }
        Block targetBlock = this.getTargetBlock();
        if (targetBlock == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int seedRadius = parameters.getInt("seed_radius", 0);
        MaterialAndData targetMaterial = new MaterialAndData(targetBlock);
        List<String> materials = ConfigurationUtils.getStringList(parameters, "materials");
        if (seedRadius > 0 && materials != null && !materials.isEmpty()) {
            int startIndex;
            int index = startIndex = RandomUtils.getRandom().nextInt(materials.size());
            do {
                MaterialAndData randomMaterial;
                if (!(randomMaterial = new MaterialAndData(materials.get(index))).isValid()) continue;
                targetMaterial = randomMaterial;
                break;
            } while ((index = (index + 1) % materials.size()) != startIndex);
        } else if (parameters.contains("material") && (targetMaterial = ConfigurationUtils.getMaterialAndData(parameters, "material", targetMaterial)).isValid()) {
            this.addDestructible(targetMaterial);
        }
        if (!this.mage.isSuperPowered() && seedRadius == 0) {
            String customRestricted;
            MaterialSetManager materialSets = this.controller.getMaterialSetManager();
            MaterialSet restricted = materialSets.getMaterialSet("restricted");
            if (restricted != null && restricted.testMaterialAndData(targetMaterial)) {
                return SpellResult.FAIL;
            }
            if (parameters.contains("restricted") && (customRestricted = parameters.getString("restricted")) != null && !customRestricted.equals("restricted") && (restricted = materialSets.fromConfigEmpty(customRestricted)).testMaterialAndData(targetMaterial)) {
                return SpellResult.FAIL;
            }
        }
        if (!this.isDestructible(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        this.registerForUndo(targetBlock);
        if (seedRadius > 0) {
            for (int dx = -seedRadius; dx < seedRadius; ++dx) {
                for (int dz = -seedRadius; dz < seedRadius; ++dz) {
                    for (int dy = -seedRadius; dy < seedRadius; ++dy) {
                        Block seedBlock = targetBlock.getRelative(dx, dy, dz);
                        if (!this.isDestructible(seedBlock)) continue;
                        this.registerForUndo(seedBlock);
                        targetMaterial.modify(seedBlock);
                    }
                }
            }
        }
        int level = 0;
        if (parameters.contains("level")) {
            level = parameters.getInt("level", level);
        } else if (this.levelWeights != null) {
            level = (Integer)RandomUtils.weightedRandom(this.levelWeights);
        }
        boolean simCheckDestructible = parameters.getBoolean("sim_check_destructible", true);
        simCheckDestructible = parameters.getBoolean("scd", simCheckDestructible);
        MemoryConfiguration automataParameters = new MemoryConfiguration();
        automataParameters.set("target", (Object)"self");
        automataParameters.set("cooldown", (Object)0);
        automataParameters.set("m", (Object)targetMaterial.getKey());
        automataParameters.set("cd", (Object)(simCheckDestructible ? 1 : 0));
        automataParameters.set("level", (Object)level);
        String automataName = parameters.getString("name", "Automata");
        Messages messages = this.controller.getMessages();
        String automataType = parameters.getString("message_type", "evil");
        List<String> prefixes = messages.getAll("automata." + automataType + ".prefixes");
        List<String> suffixes = messages.getAll("automata." + automataType + ".suffixes");
        if (!prefixes.isEmpty()) {
            automataName = prefixes.get(random.nextInt(prefixes.size())) + " " + automataName;
        }
        if (!suffixes.isEmpty()) {
            automataName = automataName + " " + suffixes.get(random.nextInt(suffixes.size()));
        }
        if (level > 1) {
            automataName = automataName + " " + AnimateSpell.escapeLevel(messages, "automata.level", level);
        }
        if ((message = this.getMessage("cast_broadcast").replace("$name", automataName)).length() > 0) {
            this.controller.sendToMages(message, targetBlock.getLocation());
        }
        automataParameters.set("animate", (Object)automataName);
        String automataId = UUID.randomUUID().toString();
        Mage mage = this.controller.getAutomaton(automataId, automataName);
        mage.setLocation(targetBlock.getLocation());
        mage.setQuiet(true);
        mage.addTag(this.getKey());
        final MageSpell spell = mage.getSpell(this.getKey());
        Bukkit.getScheduler().runTaskLater(this.controller.getPlugin(), new Runnable((ConfigurationSection)automataParameters){
            final /* synthetic */ ConfigurationSection val$automataParameters;
            {
                this.val$automataParameters = configurationSection;
            }

            @Override
            public void run() {
                spell.cast(this.val$automataParameters);
            }
        }, 1L);
        this.registerForUndo();
        return SpellResult.CAST;
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("animate") || parameterKey.equals("sim_check_destructible")) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        }
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        parameters.addAll(Arrays.asList(ANIMATE_PARAMETERS));
    }

    @Override
    protected void loadTemplate(ConfigurationSection template) {
        super.loadTemplate(template);
        if (template.contains("levels")) {
            ConfigurationSection levelTemplate = template.getConfigurationSection("levels");
            Set levelKeys = levelTemplate.getKeys(false);
            ArrayList<AscendingPair<Float>> levels = new ArrayList<AscendingPair<Float>>();
            for (String levelString : levelKeys) {
                int n = Integer.parseInt(levelString);
                double weight = levelTemplate.getDouble(levelString);
                levels.add(new AscendingPair<Float>(n, Float.valueOf((float)weight)));
            }
            RandomUtils.extrapolateFloatList(levels);
            this.levelWeights = new ArrayDeque<WeightedPair<Integer>>();
            float threshold = 0.0f;
            for (AscendingPair ascendingPair : levels) {
                float weight = ((Float)ascendingPair.getValue()).floatValue();
                int levelIndex = (int)ascendingPair.getIndex();
                this.levelWeights.add(new WeightedPair<Integer>(Float.valueOf(threshold += weight), Float.valueOf(weight), levelIndex));
            }
        } else {
            this.levelWeights = null;
        }
    }

    protected static String escapeLevel(Messages messages, String templateName, int level) {
        String templateString = messages.get(templateName);
        if (templateString.contains("$roman")) {
            return templateString.replace("$roman", TextUtils.roman(level));
        }
        return templateString.replace("$amount", Integer.toString(level));
    }
}

