/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.item.ItemUpdatedCallback;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.item.ItemData;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MagicGiveCommandExecutor
extends MagicTabExecutor {
    public MagicGiveCommandExecutor(MagicAPI api) {
        super(api, "mgive");
    }

    public boolean onCommand(final CommandSender sender, Command command, String label, String[] args) {
        if (!this.api.hasPermission(sender, this.getPermissionNode())) {
            this.sendNoPermission(sender);
            return true;
        }
        if (args.length == 0 || args.length > 3) {
            sender.sendMessage("Usage: mgive [player] <item> [count]");
            return true;
        }
        String playerName = null;
        String itemName = null;
        String countString = null;
        if (args.length == 1) {
            itemName = args[0];
        } else if (args.length == 3) {
            playerName = args[0];
            itemName = args[1];
            countString = args[2];
        } else {
            playerName = args[0];
            Player testPlayer = DeprecatedUtils.getPlayer(playerName);
            if (testPlayer == null && !playerName.startsWith("@")) {
                itemName = args[0];
                countString = args[1];
                playerName = null;
            } else {
                itemName = args[1];
            }
        }
        int count = 1;
        if (countString != null) {
            try {
                count = Integer.parseInt(countString);
            }
            catch (Exception ex) {
                sender.sendMessage("Error parsing count: " + countString + ", should be an integer.");
                return true;
            }
        }
        if (!this.api.hasPermission(sender, "Magic.create." + itemName) && !this.api.hasPermission(sender, "Magic.create.*")) {
            sender.sendMessage(ChatColor.RED + "You do not have permission to create " + itemName);
            return true;
        }
        ArrayList<Player> players = new ArrayList<Player>();
        if (playerName != null && sender.hasPermission("Magic.commands.mgive.others")) {
            List<Entity> targets = NMSUtils.selectEntities(sender, playerName);
            if (targets != null) {
                for (Entity entity : targets) {
                    if (!(entity instanceof Player)) continue;
                    players.add((Player)entity);
                }
            } else {
                Player player = DeprecatedUtils.getPlayer(playerName);
                if (player == null) {
                    sender.sendMessage("No players matched: " + playerName);
                    return true;
                }
                players.add(player);
            }
        } else {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Console usage: mgive <player> <item> [count]");
                return true;
            }
            players.add((Player)sender);
        }
        Set<String> customCosts = this.controller.getCurrencyKeys();
        for (Player player : players) {
            Mage mage;
            if (itemName.equalsIgnoreCase("xp")) {
                this.api.giveExperienceToPlayer(player, count);
                sender.sendMessage(ChatColor.AQUA + "Gave " + ChatColor.WHITE + count + ChatColor.AQUA + " experience to " + ChatColor.GOLD + player.getName());
                continue;
            }
            if (itemName.equalsIgnoreCase("sp")) {
                mage = this.controller.getMage(player);
                mage.addSkillPoints(count);
                sender.sendMessage(ChatColor.AQUA + "Gave " + ChatColor.WHITE + count + ChatColor.AQUA + " skill points to " + ChatColor.GOLD + player.getName());
                continue;
            }
            if (customCosts.contains(itemName)) {
                mage = this.controller.getMage(player);
                mage.addCurrency(itemName, count);
                sender.sendMessage(ChatColor.AQUA + "Gave " + ChatColor.WHITE + count + ChatColor.AQUA + " " + this.controller.getMessages().get("currency." + itemName + ".name", itemName) + " to " + ChatColor.GOLD + player.getName());
                continue;
            }
            mage = this.controller.getMage(player);
            final int itemCount = count;
            final String itemKey = itemName = ItemData.cleanMinecraftItemName(itemName);
            this.api.getController().createItem(itemName, mage, false, new ItemUpdatedCallback(){

                @Override
                public void updated(@Nullable ItemStack itemStack) {
                    if (itemStack == null) {
                        sender.sendMessage(ChatColor.RED + "Unknown item type " + ChatColor.DARK_RED + itemKey);
                        return;
                    }
                    itemStack.setAmount(itemCount);
                    String displayName = MagicGiveCommandExecutor.this.api.describeItem(itemStack);
                    sender.sendMessage(ChatColor.AQUA + "Gave " + ChatColor.WHITE + itemCount + " " + ChatColor.LIGHT_PURPLE + displayName + ChatColor.AQUA + " to " + ChatColor.GOLD + mage.getName());
                    mage.giveItem(itemStack);
                }
            });
        }
        return true;
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        HashSet<String> options = new HashSet<String>();
        if (!sender.hasPermission("Magic.commands.mgive")) {
            return options;
        }
        if (args.length == 1 && sender.hasPermission("Magic.commands.mgive.others")) {
            options.addAll(this.api.getPlayerNames());
        }
        if (args.length == 1 || args.length == 2) {
            Collection<SpellTemplate> spellList = this.api.getSpellTemplates(sender.hasPermission("Magic.bypass_hidden"));
            for (SpellTemplate spellTemplate : spellList) {
                this.addIfPermissible(sender, options, "Magic.create.", spellTemplate.getKey());
            }
            Collection<String> allWands = this.api.getWandKeys();
            for (String wandKey : allWands) {
                this.addIfPermissible(sender, options, "Magic.create.", wandKey);
            }
            for (Material material : Material.values()) {
                this.addIfPermissible(sender, options, "Magic.create.", material.name().toLowerCase());
            }
            Set<String> set = this.api.getController().getItemKeys();
            for (String itemKey : set) {
                this.addIfPermissible(sender, options, "Magic.create.", itemKey);
            }
            Set<String> currencies = this.api.getController().getCurrencyKeys();
            for (String string : currencies) {
                this.addIfPermissible(sender, options, "Magic.create.", string);
            }
            Collection<String> recipes = this.controller.getRecipeKeys();
            for (String recipe : recipes) {
                this.addIfPermissible(sender, options, "Magic.create.", "recipe:" + recipe);
            }
            Set<String> set2 = this.controller.getMageClassKeys();
            for (String magicClass : set2) {
                this.addIfPermissible(sender, options, "Magic.create.", "recipes:" + magicClass);
            }
            this.addIfPermissible(sender, options, "Magic.create.", "recipe:*");
            this.addIfPermissible(sender, options, "Magic.create.", "recipes:*");
        }
        return options;
    }
}

