/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.api.magic.Trigger;
import com.elmakers.mine.bukkit.api.spell.CooldownReducer;
import com.elmakers.mine.bukkit.api.spell.CostReducer;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.magic.BaseMagicConfigurable;
import com.elmakers.mine.bukkit.magic.BaseMagicProperties;
import com.elmakers.mine.bukkit.magic.CustomTrigger;
import com.elmakers.mine.bukkit.magic.EntityAttributeModifier;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.ParentedProperties;
import com.elmakers.mine.bukkit.magic.TemplateProperties;
import com.elmakers.mine.bukkit.spell.TriggeredSpell;
import com.elmakers.mine.bukkit.wand.Wand;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BaseMageModifier
extends ParentedProperties
implements CostReducer,
CooldownReducer {
    public static final ImmutableSet<String> PROPERTY_KEYS = new ImmutableSet.Builder().addAll(BaseMagicProperties.PROPERTY_KEYS).add((Object[])new String[]{"craftable", "useable", "health_scale", "entity_attributes", "triggers"}).build();
    private List<EntityAttributeModifier> attributeModifiers;
    private boolean checkedAttributes = false;
    @Nullable
    protected Multimap<String, CustomTrigger> triggers;
    protected final Mage mage;

    public BaseMageModifier(Mage mage, MagicPropertyType type, @Nullable TemplateProperties template) {
        super(type, mage.getController(), template);
        this.mage = mage;
    }

    @Override
    public Mage getMage() {
        return this.mage;
    }

    @Override
    public boolean isPlayer() {
        return this.mage.isPlayer();
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return this.mage.getPlayer();
    }

    @Override
    public void updated() {
        super.updated();
        Mage mage = this.getMage();
        if (mage == null) {
            return;
        }
        this.updateMaxMana(mage);
        Wand activeWand = mage.getActiveWand();
        if (activeWand != null) {
            activeWand.updated();
        }
        if (!this.isLocked()) {
            this.deactivate();
            this.activate();
        }
        mage.updatePassiveEffects();
    }

    public void activate() {
        this.activateAttributes();
    }

    protected void activateAttributes() {
        Collection<EntityAttributeModifier> modifiers;
        Player player;
        double healthScale = this.getDouble("health_scale");
        if (healthScale > 0.0 && (player = this.mage.getPlayer()) != null) {
            player.setHealthScale(healthScale);
        }
        if ((modifiers = this.getAttributeModifiers()) == null) {
            return;
        }
        LivingEntity entity = this.mage.getLivingEntity();
        if (entity == null) {
            return;
        }
        for (EntityAttributeModifier modifier : modifiers) {
            AttributeInstance attribute = entity.getAttribute(modifier.attribute);
            if (modifier.modifier != null) {
                if (!this.checkedAttributes) {
                    Collection existingModifiers = attribute.getModifiers();
                    for (AttributeModifier existing : existingModifiers) {
                        if (!existing.getName().equalsIgnoreCase(modifier.modifier.getName())) continue;
                        this.mage.getController().getLogger().warning("Removed duplicate attribute modifier " + modifier.modifier.getName() + ", was this leftover from a server crash?");
                        attribute.removeModifier(existing);
                        break;
                    }
                }
                try {
                    attribute.addModifier(modifier.modifier);
                }
                catch (Exception ex) {
                    this.controller.getLogger().log(Level.WARNING, "Error adding vanilla attribute modifier: " + modifier.modifier.getName() + " from class/modifier " + this.getKey(), ex);
                }
            }
            if (modifier.base == null) continue;
            modifier.previous = attribute.getBaseValue();
            attribute.setBaseValue(modifier.base.doubleValue());
        }
        this.checkedAttributes = true;
    }

    public void deactivate() {
        this.deactivateAttributes();
    }

    protected void deactivateAttributes() {
        Player player;
        double healthScale = this.getDouble("health_scale");
        if (healthScale > 0.0 && (player = this.mage.getPlayer()) != null) {
            player.setHealthScaled(false);
        }
        if (this.attributeModifiers == null) {
            return;
        }
        LivingEntity entity = this.mage.getLivingEntity();
        if (entity == null) {
            return;
        }
        ListIterator<EntityAttributeModifier> it = this.attributeModifiers.listIterator(this.attributeModifiers.size());
        while (it.hasPrevious()) {
            EntityAttributeModifier modifier = it.previous();
            AttributeInstance attribute = entity.getAttribute(modifier.attribute);
            if (modifier.modifier != null) {
                attribute.removeModifier(modifier.modifier);
            }
            if (modifier.previous == null) continue;
            attribute.setBaseValue(modifier.previous.doubleValue());
        }
        this.attributeModifiers = null;
    }

    @Nullable
    public Collection<EntityAttributeModifier> getAttributeModifiers() {
        if (this.attributeModifiers != null) {
            return this.attributeModifiers;
        }
        ConfigurationSection config = this.getConfigurationSection("entity_attributes");
        if (config == null) {
            return null;
        }
        Set keys = config.getKeys(false);
        if (keys.isEmpty()) {
            return null;
        }
        this.attributeModifiers = new ArrayList<EntityAttributeModifier>();
        for (String key : keys) {
            double value;
            String name = "mage_" + this.getKey() + "_" + key;
            Double base = null;
            String attributeKey = key;
            AttributeModifier.Operation operation = AttributeModifier.Operation.ADD_NUMBER;
            if (config.isConfigurationSection(key)) {
                ConfigurationSection modifierConfig = config.getConfigurationSection(key);
                name = modifierConfig.getString("name", name);
                attributeKey = modifierConfig.getString("attribute", attributeKey);
                value = modifierConfig.getDouble("value");
                String operationType = modifierConfig.getString("operation");
                if (operationType.equalsIgnoreCase("base")) {
                    base = value;
                } else if (operationType != null && !operationType.isEmpty()) {
                    try {
                        operation = AttributeModifier.Operation.valueOf((String)operationType.toUpperCase());
                    }
                    catch (Exception ex) {
                        this.controller.getLogger().warning("Invalid operation " + operationType + " on entity_attributes." + key + " in mage class " + this.getKey());
                    }
                }
            } else {
                value = config.getDouble(key);
            }
            Attribute attribute = null;
            try {
                attribute = Attribute.valueOf((String)attributeKey.toUpperCase());
            }
            catch (Exception ex) {
                this.controller.getLogger().warning("Invalid attribute " + attributeKey + " on entity_attributes." + key + " in mage class " + this.getKey());
            }
            if (attribute == null) continue;
            if (base != null) {
                this.attributeModifiers.add(new EntityAttributeModifier(attribute, base));
                continue;
            }
            AttributeModifier modifier = new AttributeModifier(name, value, operation);
            this.attributeModifiers.add(new EntityAttributeModifier(attribute, modifier));
        }
        return this.attributeModifiers;
    }

    protected void cancelTrigger(String triggerType) {
        Collection customTriggers;
        List<TriggeredSpell> triggers = this.getTriggers(triggerType);
        if (triggers != null) {
            for (TriggeredSpell triggered : triggers) {
                this.mage.cancelPending(triggered.getSpellKey());
            }
        }
        Collection collection = customTriggers = this.triggers == null ? null : this.triggers.get((Object)triggerType);
        if (customTriggers != null) {
            for (CustomTrigger trigger : customTriggers) {
                trigger.cancel(this.mage);
            }
        }
    }

    public void trigger(String triggerType) {
        Collection customTriggers;
        List<TriggeredSpell> triggers = this.getTriggers(triggerType);
        if (triggers != null) {
            for (TriggeredSpell triggered : triggers) {
                MageSpell spell;
                if (!triggered.getTrigger().isValid(this.mage) || (spell = this.mage.getSpell(triggered.getSpellKey())) == null || !spell.isEnabled()) continue;
                spell.cast();
                triggered.getTrigger().triggered();
            }
        }
        Collection collection = customTriggers = this.triggers == null ? null : this.triggers.get((Object)triggerType);
        if (customTriggers != null) {
            for (CustomTrigger trigger : customTriggers) {
                trigger.execute(this.mage);
            }
        }
    }

    @Nullable
    protected List<TriggeredSpell> getTriggers(String triggerType) {
        ArrayList<TriggeredSpell> triggers = null;
        for (String spellKey : this.getSpells()) {
            Collection<Trigger> spellTriggers;
            Spell spell = this.getSpell(spellKey);
            if (spell == null || (spellTriggers = spell.getTriggers()) == null) continue;
            for (Trigger trigger : spellTriggers) {
                if (!trigger.getTrigger().equalsIgnoreCase(triggerType)) continue;
                if (triggers == null) {
                    triggers = new ArrayList<TriggeredSpell>();
                }
                triggers.add(new TriggeredSpell(spellKey, trigger));
            }
        }
        return triggers;
    }

    @Override
    @Nullable
    public BaseMagicConfigurable getStorage(MagicPropertyType propertyType) {
        switch (propertyType) {
            case SUBCLASS: {
                return this;
            }
            case CLASS: {
                return this.getRoot();
            }
            case MAGE: {
                return this.mage == null ? null : this.mage.getProperties();
            }
            case WAND: {
                return this.mage == null ? null : this.mage.getActiveWand();
            }
        }
        return null;
    }

    @Override
    public float getCostReduction() {
        float costReduction = this.getFloat("cost_reduction");
        if (this.mage != null) {
            float reduction = this.mage.getCostReduction();
            return this.stackPassiveProperty(reduction, costReduction);
        }
        return costReduction;
    }

    @Override
    public float getCooldownReduction() {
        float cooldownReduction = this.getFloat("cooldown_reduction");
        if (this.mage != null) {
            float reduction = this.mage.getCooldownReduction();
            return this.stackPassiveProperty(reduction, cooldownReduction);
        }
        return cooldownReduction;
    }

    @Override
    public boolean isCooldownFree() {
        return this.getFloat("cooldown_reduction") > 1.0f;
    }

    @Override
    public float getConsumeReduction() {
        float consumeReduction = this.getFloat("consume_reduction");
        if (this.mage != null) {
            float reduction = this.mage.getConsumeReduction();
            return this.stackPassiveProperty(reduction, consumeReduction);
        }
        return consumeReduction;
    }

    @Override
    public float getCostScale() {
        return 1.0f;
    }

    protected void takeItems() {
        List<String> classItems = this.getStringList("gave_items");
        if (classItems != null) {
            for (String classItemKey : classItems) {
                ItemStack item = this.controller.createItem(classItemKey);
                if (item == null) continue;
                this.mage.removeItem(item, true);
            }
            this.setProperty("gave_items", null);
        }
    }

    protected void giveItems(String key) {
        List<String> classItems = this.getStringList(key);
        if (classItems != null) {
            ArrayList<String> gaveItems = new ArrayList<String>();
            for (String classItemKey : classItems) {
                Wand wand;
                ItemStack item = this.controller.createItem(classItemKey);
                if (item == null) {
                    this.controller.getLogger().warning("Invalid modifier item in " + this.getKey() + ": " + classItemKey);
                    continue;
                }
                if (this.mage.hasItem(item)) continue;
                gaveItems.add(classItemKey);
                String wandKey = this.controller.getWandKey(item);
                if (wandKey != null && (wand = this.mage.getBoundWand(wandKey)) != null) {
                    this.mage.giveItem(wand.getItem());
                    continue;
                }
                this.mage.giveItem(item);
            }
            if (!gaveItems.isEmpty()) {
                this.setProperty("gave_items", gaveItems);
            }
        }
    }

    @Override
    public void loadProperties() {
        Set triggerKeys;
        super.loadProperties();
        ConfigurationSection triggerConfig = this.getConfigurationSection("triggers");
        Set set = triggerKeys = triggerConfig == null ? null : triggerConfig.getKeys(false);
        if (triggerKeys != null) {
            this.triggers = ArrayListMultimap.create();
            for (String triggerKey : triggerKeys) {
                CustomTrigger trigger = new CustomTrigger((MageController)this.controller, triggerKey, triggerConfig.getConfigurationSection(triggerKey));
                this.triggers.put((Object)trigger.getTrigger(), (Object)trigger);
            }
        } else {
            this.triggers = null;
        }
    }

    public boolean canUse(String itemKey) {
        List<String> useable = this.getStringList("useable");
        if (useable == null) {
            return false;
        }
        for (String key : useable) {
            if (!key.equalsIgnoreCase(itemKey)) continue;
            return true;
        }
        return false;
    }

    public boolean canCraft(String recipeKey) {
        List<String> craftable = this.getStringList("craftable");
        if (craftable == null) {
            return false;
        }
        for (String key : craftable) {
            if (!key.equalsIgnoreCase(recipeKey)) continue;
            return true;
        }
        return false;
    }
}

