/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.economy;

import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.economy.BaseMagicCurrency;
import com.elmakers.mine.bukkit.integration.VaultController;
import org.bukkit.OfflinePlayer;

public class VaultCurrency
extends BaseMagicCurrency {
    private final boolean isValid;

    public VaultCurrency(MageController controller) {
        super(controller, "currency", 1.0);
        this.isValid = controller.isVaultCurrencyEnabled();
    }

    @Override
    public double getBalance(Mage mage, CasterProperties caster) {
        double balance = 0.0;
        VaultController vault = VaultController.getInstance();
        if (vault != null) {
            balance = vault.getBalance((OfflinePlayer)mage.getPlayer());
        }
        return balance;
    }

    @Override
    public boolean has(Mage mage, CasterProperties caster, double amount) {
        VaultController vault = VaultController.getInstance();
        return vault != null && vault.has((OfflinePlayer)mage.getPlayer(), amount);
    }

    @Override
    public void deduct(Mage mage, CasterProperties caster, double amount) {
        VaultController vault = VaultController.getInstance();
        if (vault != null) {
            vault.withdrawPlayer((OfflinePlayer)mage.getPlayer(), amount);
        }
    }

    @Override
    public boolean give(Mage mage, CasterProperties caster, double amount) {
        VaultController vault = VaultController.getInstance();
        if (vault != null) {
            vault.depositPlayer((OfflinePlayer)mage.getPlayer(), amount);
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }
}

