/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

public class BoundingBox
implements com.elmakers.mine.bukkit.api.block.BoundingBox {
    protected static final Vector UNIT_VECTOR = new Vector(1, 1, 1);
    protected BlockVector max;
    protected BlockVector min;

    @Deprecated
    public BoundingBox() {
    }

    public BoundingBox(Vector p1, Vector p2) {
        this.min = new BlockVector(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.min(p1.getZ(), p2.getZ()));
        this.max = new BlockVector(Math.max(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()), Math.max(p1.getZ(), p2.getZ()));
    }

    public BoundingBox(BlockVector min, BlockVector max) {
        this.min = min;
        this.max = max;
    }

    public BoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.min = new BlockVector(Math.min(minX, maxX), Math.min(minY, maxY), Math.min(minZ, maxZ));
        this.max = new BlockVector(Math.max(minX, maxX), Math.max(minY, maxY), Math.max(minZ, maxZ));
    }

    public BoundingBox contain(Vector newPoint) {
        if (this.contains(newPoint)) {
            return this;
        }
        BlockVector newMin = new BlockVector(Vector.getMinimum((Vector)this.min, (Vector)newPoint));
        BlockVector newMax = new BlockVector(Vector.getMaximum((Vector)this.max, (Vector)newPoint));
        this.min = newMin;
        this.max = newMax;
        return this;
    }

    @Override
    public boolean contains(Vector p) {
        return p.isInAABB((Vector)this.min, (Vector)this.max);
    }

    @Override
    public boolean contains(Vector p, int threshold) {
        if (threshold == 0) {
            return this.contains(p);
        }
        Vector adjustedMin = UNIT_VECTOR.clone().multiply(-threshold).add((Vector)this.min);
        Vector adjustedMax = UNIT_VECTOR.clone().multiply(threshold).add((Vector)this.max);
        return p.isInAABB(adjustedMin, adjustedMax);
    }

    public void fill(World world, Material material, @Nullable MaterialSet destructable, @Nullable UndoList affected) {
        for (int x = this.min.getBlockX(); x < this.max.getBlockX(); ++x) {
            for (int y = this.min.getBlockY(); y < this.max.getBlockY(); ++y) {
                for (int z = this.min.getBlockZ(); z < this.max.getBlockZ(); ++z) {
                    Block block = world.getBlockAt(x, y, z);
                    if (destructable == null) {
                        if (affected != null) {
                            affected.add(block);
                        }
                        block.setType(material);
                        continue;
                    }
                    if (!destructable.testBlock(block)) continue;
                    if (affected != null) {
                        affected.add(block);
                    }
                    block.setType(material);
                }
            }
        }
    }

    @Override
    public BlockVector getCenter() {
        Vector center = new Vector(this.min.getX(), this.min.getY(), this.min.getZ());
        center = center.getMidpoint((Vector)this.max);
        return new BlockVector(center);
    }

    @Override
    public BlockVector getMax() {
        return this.max;
    }

    @Override
    public BlockVector getMin() {
        return this.min;
    }

    public void setMax(BlockVector max) {
        this.max = max;
    }

    public void setMin(BlockVector min) {
        this.min = min;
    }
}

