/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.ActionHandler;
import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.EntityMetadataUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class SpawnEntityAction
extends CompoundAction {
    private Deque<WeightedPair<String>> entityTypeProbability;
    private CreatureSpawnEvent.SpawnReason spawnReason = CreatureSpawnEvent.SpawnReason.EGG;
    private boolean loot = false;
    private boolean setTarget = false;
    private boolean setSource = false;
    private boolean force = false;
    private boolean waitForDeath = true;
    private boolean repeatRandomize = true;
    private boolean tamed = false;
    private boolean setOwner = true;
    private boolean onBlock = true;
    private Vector direction = null;
    private double speed;
    private double dyOffset;
    private com.elmakers.mine.bukkit.api.entity.EntityData entityData;
    private WeakReference<Entity> entity;
    private boolean spawnActionsRun = false;
    private boolean deathActionsRun = false;
    private boolean hasSpawnActions = false;
    private boolean hasDeathActions = false;
    private boolean hasAnyActions = false;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        ActionHandler actions;
        super.prepare(context, parameters);
        this.loot = parameters.getBoolean("loot", false);
        this.force = parameters.getBoolean("force", false);
        this.tamed = parameters.getBoolean("tamed", false);
        this.setOwner = parameters.getBoolean("owned", true);
        this.setSource = parameters.getBoolean("set_source", false);
        this.repeatRandomize = parameters.getBoolean("repeat_random", true);
        this.speed = parameters.getDouble("speed", 0.0);
        this.direction = ConfigurationUtils.getVector(parameters, "direction");
        this.dyOffset = parameters.getDouble("dy_offset", 0.0);
        this.onBlock = parameters.getBoolean("on_block", true);
        String disguiseTarget = parameters.getString("disguise_target");
        if (disguiseTarget != null) {
            Entity targetEntity;
            Entity entity = targetEntity = disguiseTarget.equals("target") ? context.getTargetEntity() : context.getEntity();
            if (targetEntity != null) {
                ConfigurationSection disguiseConfig = parameters.createSection("disguise");
                disguiseConfig.set("type", (Object)targetEntity.getType().name().toLowerCase());
                if (targetEntity instanceof Player) {
                    ItemStack offhand;
                    ItemStack mainhand;
                    ItemStack boots;
                    ItemStack leggings;
                    ItemStack chestplate;
                    MageController controller = context.getController();
                    Player targetPlayer = (Player)targetEntity;
                    disguiseConfig.set("name", (Object)targetPlayer.getName());
                    disguiseConfig.set("skin", (Object)targetPlayer.getName());
                    PlayerInventory inventory = targetPlayer.getInventory();
                    ItemStack helmet = inventory.getHelmet();
                    if (!CompatibilityUtils.isEmpty(helmet)) {
                        disguiseConfig.set("helmet", (Object)controller.getItemKey(helmet));
                    }
                    if (!CompatibilityUtils.isEmpty(chestplate = inventory.getChestplate())) {
                        disguiseConfig.set("chestplate", (Object)controller.getItemKey(chestplate));
                    }
                    if (!CompatibilityUtils.isEmpty(leggings = inventory.getLeggings())) {
                        disguiseConfig.set("leggings", (Object)controller.getItemKey(leggings));
                    }
                    if (!CompatibilityUtils.isEmpty(boots = inventory.getBoots())) {
                        disguiseConfig.set("boots", (Object)controller.getItemKey(boots));
                    }
                    if (!CompatibilityUtils.isEmpty(mainhand = inventory.getItemInMainHand())) {
                        disguiseConfig.set("mainhand", (Object)controller.getItemKey(mainhand));
                    }
                    if (!CompatibilityUtils.isEmpty(offhand = inventory.getItemInOffHand())) {
                        disguiseConfig.set("offhand", (Object)controller.getItemKey(offhand));
                    }
                }
            }
        }
        if (parameters.contains("type")) {
            this.entityData = context.getController().getMob(parameters);
        }
        if (parameters.contains("reason")) {
            String reasonText = parameters.getString("reason").toUpperCase();
            try {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)reasonText);
            }
            catch (Exception ex) {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.EGG;
            }
        }
        this.hasDeathActions = (actions = this.getHandler("actions")) != null && actions.size() > 0;
        ActionHandler handler = this.getHandler("spawn");
        this.hasSpawnActions = handler != null && handler.size() > 0;
        this.hasAnyActions = this.hasDeathActions || this.hasSpawnActions;
        this.waitForDeath = parameters.getBoolean("wait_for_death", this.hasDeathActions);
        this.setTarget = parameters.getBoolean("set_target", this.hasSpawnActions);
    }

    @Override
    protected void addHandlers(Spell spell, ConfigurationSection parameters) {
        super.addHandlers(spell, parameters);
        this.addHandler(spell, "spawn");
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.entity = null;
    }

    @Override
    public boolean next(CastContext context) {
        return this.hasSpawnActions && !this.spawnActionsRun || this.hasDeathActions && !this.deathActionsRun;
    }

    @Override
    public SpellResult step(CastContext context) {
        boolean isDead;
        SpellResult result;
        if (!(this.entity != null || (result = this.spawn(context)).isSuccess() && this.hasAnyActions)) {
            return result;
        }
        Entity spawned = (Entity)this.entity.get();
        if (this.hasSpawnActions && !this.spawnActionsRun) {
            this.spawnActionsRun = true;
            return this.startTargetedActions("spawn", spawned, context);
        }
        boolean bl = isDead = spawned == null || spawned.isDead() || !spawned.isValid();
        if (this.hasDeathActions && (isDead || !this.waitForDeath) && !this.deathActionsRun) {
            this.deathActionsRun = true;
            return this.startTargetedActions("actions", spawned, context);
        }
        return isDead || !this.waitForDeath ? SpellResult.CAST : SpellResult.PENDING;
    }

    private SpellResult startTargetedActions(String actionKey, Entity spawned, CastContext context) {
        if ((this.setTarget || this.setSource) && spawned != null) {
            Entity sourceEntity;
            Entity entity = sourceEntity = this.setSource ? spawned : context.getEntity();
            if (this.setTarget) {
                this.createActionContext(context, sourceEntity, sourceEntity.getLocation(), spawned, spawned.getLocation());
            } else {
                this.createActionContext(context, sourceEntity, sourceEntity.getLocation());
            }
        }
        return this.startActions(actionKey);
    }

    private SpellResult spawn(CastContext context) {
        LivingEntity shooter;
        Location spawnLocation = context.getTargetLocation();
        if (spawnLocation == null || this.onBlock) {
            Block targetBlock = context.getTargetBlock();
            targetBlock = targetBlock.getRelative(BlockFace.UP);
            spawnLocation = targetBlock.getLocation();
        }
        Location sourceLocation = context.getLocation();
        spawnLocation.setPitch(sourceLocation.getPitch());
        spawnLocation.setYaw(sourceLocation.getYaw());
        MageController controller = context.getController();
        if (this.entityTypeProbability != null && !this.entityTypeProbability.isEmpty() && (this.repeatRandomize || this.entityData == null)) {
            String randomType = (String)RandomUtils.weightedRandom(this.entityTypeProbability);
            try {
                this.entityData = controller.getMob(randomType);
                if (this.entityData == null) {
                    this.entityData = new EntityData(controller, EntityType.valueOf((String)randomType.toUpperCase()));
                }
            }
            catch (Throwable ex) {
                this.entityData = null;
            }
        }
        if (this.entityData == null) {
            return SpellResult.FAIL;
        }
        if (this.force) {
            controller.setForceSpawn(true);
        }
        Entity spawnedEntity = null;
        try {
            spawnedEntity = this.entityData.spawn(spawnLocation, this.spawnReason);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (spawnedEntity instanceof AreaEffectCloud) {
            ((AreaEffectCloud)spawnedEntity).setSource((ProjectileSource)context.getLivingEntity());
        } else if (spawnedEntity instanceof Projectile) {
            ((Projectile)spawnedEntity).setShooter((ProjectileSource)context.getLivingEntity());
        }
        if (this.force) {
            controller.setForceSpawn(false);
        }
        if (spawnedEntity == null) {
            return SpellResult.FAIL;
        }
        if (!this.loot) {
            EntityMetadataUtils.instance().setBoolean(spawnedEntity, "nodrops", true);
        }
        if (this.speed > 0.0) {
            Vector motion = this.direction;
            motion = motion == null ? context.getDirection() : motion.clone();
            if (this.dyOffset != 0.0) {
                motion.setY(motion.getY() + this.dyOffset);
            }
            motion.normalize();
            motion.multiply(this.speed);
            CompatibilityUtils.setEntityMotion(spawnedEntity, motion);
        }
        Collection<EffectPlayer> entityEffects = context.getEffects("spawned");
        for (EffectPlayer effectPlayer : entityEffects) {
            effectPlayer.start(spawnedEntity.getLocation(), spawnedEntity, null, null);
        }
        context.registerForUndo(spawnedEntity);
        if (this.setOwner && spawnedEntity instanceof Creature) {
            EntityMetadataUtils.instance().setString(spawnedEntity, "owner", context.getMage().getId());
        }
        if (this.setTarget && !this.hasAnyActions) {
            context.setTargetEntity(spawnedEntity);
        }
        if ((shooter = context.getLivingEntity()) != null) {
            if (spawnedEntity instanceof Projectile) {
                ((Projectile)spawnedEntity).setShooter((ProjectileSource)shooter);
            } else if (spawnedEntity instanceof AreaEffectCloud) {
                ((AreaEffectCloud)spawnedEntity).setSource((ProjectileSource)shooter);
            }
        }
        if (this.tamed && spawnedEntity instanceof Tameable) {
            Tameable tameable = (Tameable)spawnedEntity;
            tameable.setTamed(true);
            Player owner = context.getMage().getPlayer();
            if (owner != null) {
                tameable.setOwner((AnimalTamer)owner);
            }
        }
        this.entity = new WeakReference<Entity>(spawnedEntity);
        return SpellResult.CAST;
    }

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        if (parameters.contains("entity_types")) {
            this.entityTypeProbability = new ArrayDeque<WeightedPair<String>>();
            RandomUtils.populateStringProbabilityMap(this.entityTypeProbability, ConfigurationUtils.getConfigurationSection(parameters, "entity_types"), 0, 0, 0.0f);
        }
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("loot");
        parameters.add("baby");
        parameters.add("name");
        parameters.add("type");
        parameters.add("speed");
        parameters.add("reason");
        parameters.add("villager_profession");
        parameters.add("skeleton_type");
        parameters.add("ocelot_type");
        parameters.add("rabbit_type");
        parameters.add("horse_variant");
        parameters.add("horse_style");
        parameters.add("horse_color");
        parameters.add("color");
        parameters.add("repeat_random");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("type")) {
            for (EntityType type : EntityType.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("reason")) {
            for (CreatureSpawnEvent.SpawnReason type : CreatureSpawnEvent.SpawnReason.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("ocelot_type")) {
            for (Ocelot.Type type : Ocelot.Type.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("villager_profession")) {
            for (Villager.Profession profession : Villager.Profession.values()) {
                examples.add(profession.name().toLowerCase());
            }
        } else if (parameterKey.equals("rabbit_type")) {
            for (Rabbit.Type type : Rabbit.Type.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("horse_style")) {
            for (Horse.Style type : Horse.Style.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("horse_color")) {
            for (Horse.Color type : Horse.Color.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("color")) {
            for (DyeColor type : DyeColor.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("loot") || parameterKey.equals("baby") || parameterKey.equals("repeat_random")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("name")) {
            examples.add("Philbert");
        } else if (parameterKey.equals("speed")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

