/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.utility.ColoredLogger;
import com.elmakers.mine.bukkit.utility.LogMessage;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MagicLogger
extends ColoredLogger {
    private String context = null;
    private boolean capture = false;
    private final Set<LogMessage> warnings = new LinkedHashSet<LogMessage>();
    private final Set<LogMessage> errors = new LinkedHashSet<LogMessage>();

    public MagicLogger(Logger delegate) {
        super(delegate);
    }

    @Override
    public void log(LogRecord record) {
        if (this.capture) {
            boolean logged = false;
            if (record.getThrown() != null) {
                logged = true;
                super.log(record);
            }
            if (record.getLevel().equals(Level.WARNING)) {
                this.warnings.add(new LogMessage(this.context, record.getMessage().replace("[Magic] ", "")));
            } else if (record.getLevel().equals(Level.SEVERE)) {
                this.errors.add(new LogMessage(this.context, record.getMessage().replace("[Magic] ", "")));
            } else if (!logged) {
                super.log(record);
            }
        } else {
            super.log(record);
        }
    }

    public void enableCapture(boolean enable) {
        this.capture = enable;
        this.context = null;
        this.warnings.clear();
        this.errors.clear();
    }

    public void setContext(String context) {
        this.context = context;
    }

    public List<LogMessage> getErrors() {
        return new ArrayList<LogMessage>(this.errors);
    }

    public List<LogMessage> getWarnings() {
        return new ArrayList<LogMessage>(this.warnings);
    }

    public boolean isCapturing() {
        return this.capture;
    }
}

