/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.tasks;

import com.elmakers.mine.bukkit.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.spell.ActionSpell;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.MagicLogger;
import java.util.Collection;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class ValidateSpellsTask
implements Runnable {
    private final MagicController controller;
    private final CommandSender sender;

    public ValidateSpellsTask(MagicController controller, CommandSender sender) {
        this.controller = controller;
        this.sender = sender;
    }

    @Override
    public void run() {
        MagicLogger logger = this.controller.getLogger();
        Mage mage = this.controller.getMage(this.sender);
        Collection<SpellTemplate> spells = this.controller.getSpellTemplates();
        for (SpellTemplate newSpell : spells) {
            String key = newSpell.getKey();
            logger.setContext("spells." + key);
            if (!(newSpell instanceof BaseSpell)) continue;
            BaseSpell spell = (BaseSpell)newSpell;
            try {
                MageSpell mageSpell = spell.createMageSpell(mage);
                CastContext context = new CastContext(mageSpell);
                context.setWorkingParameters(mageSpell.getSpellParameters());
                if (mageSpell instanceof ActionSpell) {
                    ActionSpell actionSpell = (ActionSpell)mageSpell;
                    Collection<String> handlers = actionSpell.getHandlers();
                    for (String handler : handlers) {
                        actionSpell.setCurrentHandler(handler, context);
                        actionSpell.reloadParameters(context);
                    }
                } else {
                    mageSpell.reloadParameters(context);
                }
                if (!(mageSpell instanceof BaseSpell)) continue;
                ((BaseSpell)mageSpell).validateEffects();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "There was an error checking spell " + key + " for issues", ex);
            }
        }
        MagicPlugin plugin = this.controller.getPlugin();
        plugin.getServer().getScheduler().runTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                ValidateSpellsTask.this.controller.resetLoading(ValidateSpellsTask.this.sender);
            }
        });
    }
}

