/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.tasks;

import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.MagicLogger;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigurationLoadTask
implements Runnable {
    private final MagicController controller;
    private final File configFolder;
    private final Plugin plugin;
    private final CommandSender sender;
    private boolean verboseLogging;
    private static final String[] CONFIG_FILES = new String[]{"messages", "materials", "attributes", "effects", "spells", "paths", "classes", "wands", "items", "crafting", "mobs", "automata", "modifiers"};
    private static final ImmutableSet<String> DEFAULT_ON = ImmutableSet.of((Object)"messages", (Object)"materials");
    private final Map<String, ConfigurationSection> loadedConfigurations = new HashMap<String, ConfigurationSection>();
    private final Map<String, ConfigurationSection> mainConfigurations = new HashMap<String, ConfigurationSection>();
    private final Map<String, ConfigurationSection> spellConfigurations = new HashMap<String, ConfigurationSection>();
    private final Map<String, ConfigurationSection> baseSpellConfigurations = new HashMap<String, ConfigurationSection>();
    private final Map<String, ConfigurationSection> exampleConfigurations = new HashMap<String, ConfigurationSection>();
    private static final Object loadLock = new Object();
    private boolean allPvpRestricted = false;
    private boolean noPvpRestricted = false;
    private boolean saveDefaultConfigs = true;
    private boolean spellUpgradesEnabled = true;
    private String exampleDefaults = null;
    private String languageOverride = null;
    private Collection<String> addExamples = null;
    private Set<String> allExamples = new HashSet<String>();
    private ConfigurationSection mainConfiguration;
    private Set<String> resolvingKeys = new LinkedHashSet<String>();
    private boolean success;

    public ConfigurationLoadTask(MagicController controller, CommandSender sender) {
        this.controller = controller;
        this.sender = sender;
        this.plugin = controller.getPlugin();
        this.configFolder = controller.getConfigFolder();
    }

    private Logger getLogger() {
        return this.controller.getLogger();
    }

    private void loadInitialProperties(ConfigurationSection properties) {
        this.spellUpgradesEnabled = properties.getBoolean("enable_spell_upgrades", true);
        this.allPvpRestricted = properties.getBoolean("pvp_restricted", false);
        this.noPvpRestricted = properties.getBoolean("allow_pvp_restricted", false);
        this.saveDefaultConfigs = properties.getBoolean("save_default_configs", true);
        this.exampleDefaults = properties.getString("example", this.exampleDefaults);
        this.addExamples = ConfigurationUtils.getStringList(properties, "add_examples");
        if (this.addExamples == null || this.addExamples.isEmpty()) {
            this.addExamples = ConfigurationUtils.getStringList(properties, "examples");
        }
        this.languageOverride = properties.getString("language");
    }

    private void info(String message) {
        if (this.verboseLogging) {
            this.controller.info(message);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verboseLogging = verbose;
    }

    @Nonnull
    private ConfigurationSection loadExampleConfiguration(String examplesPrefix) {
        ConfigurationSection exampleConfig = this.exampleConfigurations.get(examplesPrefix);
        if (exampleConfig == null) {
            InputStream input;
            String examplesFileName = examplesPrefix + ".yml";
            File externalFolder = new File(this.plugin.getDataFolder(), examplesPrefix);
            File externalFile = new File(this.plugin.getDataFolder(), examplesFileName);
            if (externalFile.exists()) {
                try {
                    exampleConfig = CompatibilityUtils.loadConfiguration(externalFile);
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading: " + examplesFileName);
                }
            }
            if (externalFolder.exists()) {
                try {
                    if (exampleConfig == null) {
                        exampleConfig = new MemoryConfiguration();
                    }
                    exampleConfig = this.loadConfigFolder(exampleConfig, externalFolder, false);
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading: " + examplesFileName);
                }
            }
            if (exampleConfig == null && (input = this.plugin.getResource(examplesFileName)) != null) {
                try {
                    exampleConfig = CompatibilityUtils.loadConfiguration(input);
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading: " + examplesFileName + " from builtin resources");
                }
            }
            if (exampleConfig == null) {
                exampleConfig = new MemoryConfiguration();
            }
            this.exampleConfigurations.put(examplesPrefix, exampleConfig);
        }
        return ConfigurationUtils.cloneConfiguration(exampleConfig);
    }

    private ConfigurationSection loadMainConfiguration() throws InvalidConfigurationException, IOException {
        ConfigurationSection configuration = this.loadMainConfiguration("config");
        this.loadInitialProperties(configuration);
        boolean reloadConfig = false;
        if (this.addExamples != null && this.addExamples.size() > 0) {
            this.allExamples.addAll(this.addExamples);
            this.info("Adding examples: " + StringUtils.join(this.addExamples, (String)","));
            reloadConfig = true;
        }
        if (this.exampleDefaults != null && this.exampleDefaults.length() > 0) {
            this.allExamples.add(this.exampleDefaults);
            this.info("Overriding configuration with example: " + this.exampleDefaults);
            reloadConfig = true;
        }
        if (reloadConfig) {
            configuration = this.loadMainConfiguration("config");
        }
        return configuration;
    }

    private ConfigurationSection loadMainConfiguration(String fileName) throws InvalidConfigurationException, IOException {
        Object exampleConfig;
        YamlConfiguration config;
        ConfigurationSection overrides = this.loadOverrides(fileName);
        if (overrides != null && !overrides.contains("add_resource_pack")) {
            overrides.set("add_resource_pack", overrides.get("resource_pack"));
        }
        boolean usingExample = this.exampleDefaults != null && this.exampleDefaults.length() > 0;
        String examplesFilePrefix = usingExample ? "examples/" + this.exampleDefaults + "/" + fileName : null;
        String defaultsFileName = "defaults/" + fileName + ".defaults.yml";
        try {
            config = CompatibilityUtils.loadConfiguration(this.plugin.getResource(defaultsFileName));
        }
        catch (Exception ex) {
            this.getLogger().severe("Error loading file: " + defaultsFileName);
            throw ex;
        }
        this.info(" Based on defaults " + defaultsFileName);
        String listsFilename = "defaults/lists.defaults.yml";
        YamlConfiguration listConfig = null;
        try {
            listConfig = CompatibilityUtils.loadConfiguration(this.plugin.getResource(listsFilename));
            ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)listConfig);
        }
        catch (Exception ex) {
            this.getLogger().severe("Error loading file: " + listsFilename);
            throw ex;
        }
        this.info(" Added lists from " + listsFilename);
        if (usingExample && (exampleConfig = this.loadExampleConfiguration(examplesFilePrefix)) != null) {
            try {
                this.info(" Using " + examplesFilePrefix);
                this.processInheritance(this.exampleDefaults, (ConfigurationSection)exampleConfig, fileName, (ConfigurationSection)exampleConfig);
                this.mainConfigurations.put(this.exampleDefaults, (ConfigurationSection)exampleConfig);
                ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)exampleConfig);
            }
            catch (Exception ex) {
                this.getLogger().severe("Error loading: " + examplesFilePrefix);
                throw ex;
            }
        }
        if (this.addExamples != null && this.addExamples.size() > 0) {
            for (String example : this.addExamples) {
                examplesFilePrefix = "examples/" + example + "/" + fileName;
                ConfigurationSection exampleConfig2 = this.loadExampleConfiguration(examplesFilePrefix);
                if (exampleConfig2 == null) continue;
                try {
                    boolean override = exampleConfig2.getBoolean("example_override", false);
                    this.info(" Adding " + examplesFilePrefix + (override ? ", allowing overrides" : ""));
                    this.processInheritance(example, exampleConfig2, fileName, exampleConfig2);
                    this.mainConfigurations.put(example, exampleConfig2);
                    ConfigurationUtils.addConfigurations((ConfigurationSection)config, exampleConfig2, override);
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading: " + examplesFilePrefix);
                    throw ex;
                }
            }
        }
        this.addVersionConfigs((ConfigurationSection)config, fileName);
        ConfigurationUtils.addConfigurations((ConfigurationSection)config, overrides);
        File configSubFolder = new File(this.configFolder, fileName);
        this.loadConfigFolder((ConfigurationSection)config, configSubFolder, false);
        if (this.saveDefaultConfigs) {
            try {
                this.plugin.saveResource(defaultsFileName, true);
                this.plugin.saveResource(listsFilename, true);
            }
            catch (Exception ex) {
                this.getLogger().warning("Couldn't write defaults file: " + defaultsFileName);
            }
        } else {
            this.deleteDefaults(defaultsFileName);
        }
        return config;
    }

    private boolean processInheritance(String exampleKey, ConfigurationSection exampleConfig, String fileName, ConfigurationSection mainConfiguration) {
        return this.processInheritance(exampleKey, exampleConfig, fileName, mainConfiguration, null);
    }

    private boolean processInheritance(String exampleKey, ConfigurationSection exampleConfig, String fileName, ConfigurationSection mainConfiguration, Set<String> inherited) {
        List<String> skip;
        if (mainConfiguration.contains("example")) {
            mainConfiguration.set("inherit", mainConfiguration.get("example"));
            mainConfiguration.set("example", null);
        }
        inherited = inherited == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(inherited);
        boolean disabledInherited = false;
        boolean isMainConfig = fileName.equals("config");
        inherited.add(exampleKey);
        List<String> inherits = ConfigurationUtils.getStringList(mainConfiguration, "inherit");
        if (!(inherits == null || (skip = ConfigurationUtils.getStringList(mainConfiguration, "skip_inherited")) != null && skip.contains(fileName))) {
            for (String inheritFrom : inherits) {
                String inheritFilePrefix = "examples/" + inheritFrom + "/" + fileName;
                ConfigurationSection inheritedConfig = this.loadExampleConfiguration(inheritFilePrefix);
                if (inheritedConfig == null) continue;
                if (isMainConfig) {
                    this.mainConfigurations.put(inheritFrom, ConfigurationUtils.cloneConfiguration(inheritedConfig));
                    inheritedConfig.set("disable_inherited", null);
                    inheritedConfig.set("skip_inherited", null);
                    inheritedConfig.set("example", null);
                    inheritedConfig.set("inherit", null);
                }
                try {
                    List<String> disable = ConfigurationUtils.getStringList(mainConfiguration, "disable_inherited");
                    if (inherited.contains(inheritFrom)) {
                        this.getLogger().log(Level.WARNING, "    Circular dependency detected in configuration inheritance: " + StringUtils.join(inherited, (String)" -> ") + " -> " + inheritFrom);
                    } else if (this.processInheritance(inheritFrom, inheritedConfig, fileName, this.getMainConfiguration(inheritFrom), inherited)) {
                        disabledInherited = true;
                    }
                    if (!isMainConfig && disable != null && disable.contains(fileName) && !this.allExamples.contains(inheritFrom)) {
                        this.disableAll(inheritedConfig);
                        disabledInherited = true;
                    }
                    if (disabledInherited) {
                        this.enableAll(exampleConfig);
                    }
                    ConfigurationUtils.addConfigurations(exampleConfig, inheritedConfig, false);
                    this.info("   Example " + exampleKey + " inheriting from " + inheritFrom);
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading file: " + inheritFilePrefix);
                    throw ex;
                }
            }
        }
        return disabledInherited;
    }

    private ConfigurationSection loadOverrides(String fileName) throws IOException, InvalidConfigurationException {
        ConfigurationSection results;
        String configFileName = fileName + ".yml";
        File configFile = new File(this.configFolder, configFileName);
        if (!configFile.exists()) {
            this.info("Saving template " + configFileName + ", edit to customize configuration.");
            this.plugin.saveResource(configFileName, false);
        }
        this.info("Loading " + configFile.getName());
        try {
            results = CompatibilityUtils.loadConfiguration(configFile);
        }
        catch (Exception ex) {
            this.getLogger().severe("Error loading: " + configFileName);
            throw ex;
        }
        return results;
    }

    private ConfigurationSection loadConfigFile(String fileName, ConfigurationSection mainConfiguration) throws IOException, InvalidConfigurationException {
        String languageFilePrefix;
        ConfigurationSection languageConfig;
        Object exampleConfig;
        boolean loadAllDefaults = mainConfiguration.getBoolean("load_default_configs", true);
        if (DEFAULT_ON.contains((Object)fileName)) {
            loadAllDefaults = true;
        }
        boolean loadDefaults = mainConfiguration.getBoolean("load_default_" + fileName, loadAllDefaults);
        boolean disableDefaults = mainConfiguration.getBoolean("disable_default_" + fileName, false);
        ConfigurationSection mainSection = mainConfiguration.getConfigurationSection(fileName);
        ConfigurationSection overrides = this.loadOverrides(fileName);
        boolean usingExample = this.exampleDefaults != null && this.exampleDefaults.length() > 0;
        String examplesFilePrefix = usingExample ? "examples/" + this.exampleDefaults + "/" + fileName : null;
        String defaultsFileName = "defaults/" + fileName + ".defaults.yml";
        YamlConfiguration config = new YamlConfiguration();
        YamlConfiguration defaultConfig = null;
        try {
            defaultConfig = CompatibilityUtils.loadConfiguration(this.plugin.getResource(defaultsFileName));
        }
        catch (Exception ex) {
            this.getLogger().severe("Error loading file: " + defaultsFileName);
            throw ex;
        }
        String header = defaultConfig.options().header();
        if (loadDefaults) {
            this.info(" Based on defaults " + defaultsFileName);
            if (disableDefaults) {
                this.disableAll((ConfigurationSection)defaultConfig);
            }
            ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)defaultConfig);
        }
        if (usingExample && loadDefaults && (exampleConfig = this.loadExampleConfiguration(examplesFilePrefix)) != null) {
            try {
                if (disableDefaults) {
                    this.disableAll((ConfigurationSection)exampleConfig);
                }
                if (this.processInheritance(this.exampleDefaults, (ConfigurationSection)exampleConfig, fileName, this.getMainConfiguration(this.exampleDefaults))) {
                    disableDefaults = true;
                }
                ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)exampleConfig);
                this.info(" Using " + examplesFilePrefix);
            }
            catch (Exception ex) {
                this.getLogger().severe("Error loading file: " + examplesFilePrefix);
                throw ex;
            }
        }
        if (mainSection != null) {
            ConfigurationUtils.addConfigurations(overrides, mainSection);
        }
        if (disableDefaults) {
            this.enableAll(overrides);
        }
        if (this.addExamples != null && this.addExamples.size() > 0) {
            for (String example : this.addExamples) {
                examplesFilePrefix = "examples/" + example + "/" + fileName;
                ConfigurationSection exampleConfig2 = this.loadExampleConfiguration(examplesFilePrefix);
                if (exampleConfig2 == null) continue;
                try {
                    if (disableDefaults) {
                        this.enableAll(exampleConfig2);
                    }
                    this.processInheritance(example, exampleConfig2, fileName, this.getMainConfiguration(example));
                    ConfigurationUtils.addConfigurations((ConfigurationSection)config, exampleConfig2, false);
                    this.info(" Added " + examplesFilePrefix);
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading file: " + examplesFilePrefix);
                    throw ex;
                }
            }
        }
        this.addVersionConfigs((ConfigurationSection)config, fileName);
        if (fileName.equals("messages") && this.languageOverride != null && (languageConfig = this.loadExampleConfiguration(languageFilePrefix = "examples/localizations/messages." + this.languageOverride)) != null) {
            try {
                ConfigurationUtils.addConfigurations((ConfigurationSection)config, languageConfig);
                this.info(" Using " + languageFilePrefix);
            }
            catch (Exception ex) {
                this.getLogger().severe("Error loading file: " + languageFilePrefix);
                throw ex;
            }
        }
        ConfigurationUtils.addConfigurations((ConfigurationSection)config, overrides);
        File configSubFolder = new File(this.configFolder, fileName);
        this.loadConfigFolder((ConfigurationSection)config, configSubFolder, disableDefaults);
        File savedDefaults = new File(this.configFolder, defaultsFileName);
        if (this.saveDefaultConfigs) {
            try {
                config.options().header(header);
                config.save(savedDefaults);
            }
            catch (Exception ex) {
                this.getLogger().warning("Couldn't write defaults file: " + defaultsFileName);
            }
        } else {
            this.deleteDefaults(defaultsFileName);
        }
        return config;
    }

    private void addVersionConfigs(ConfigurationSection config, String fileName) throws InvalidConfigurationException, IOException {
        int[] serverVersion = CompatibilityUtils.getServerVersion();
        int majorVersion = serverVersion[0];
        int minorVersion = serverVersion[1];
        String versionExample = majorVersion + "." + minorVersion;
        String versionFileName = "examples/" + versionExample + "/" + fileName + ".yml";
        InputStream versionInput = this.plugin.getResource(versionFileName);
        if (versionInput != null) {
            try {
                YamlConfiguration versionConfig = CompatibilityUtils.loadConfiguration(versionInput);
                if (fileName.equals("config")) {
                    this.mainConfigurations.put(versionExample, (ConfigurationSection)versionConfig);
                }
                this.processInheritance(versionExample, (ConfigurationSection)versionConfig, fileName, this.getMainConfiguration(versionExample));
                ConfigurationUtils.addConfigurations(config, (ConfigurationSection)versionConfig, true, true);
                this.getLogger().info(" Using compatibility configs: " + versionFileName);
            }
            catch (Exception ex) {
                this.getLogger().severe("Error loading file: " + versionFileName);
                throw ex;
            }
        }
    }

    private void deleteDefaults(String defaultsFileName) {
        File savedDefaults = new File(this.configFolder, defaultsFileName);
        if (savedDefaults.exists()) {
            try {
                savedDefaults.delete();
                this.getLogger().info("Deleting defaults file: " + defaultsFileName + ", save_default_configs is false");
            }
            catch (Exception ex) {
                this.getLogger().warning("Couldn't delete defaults file: " + defaultsFileName + ", contents may be outdated");
            }
        }
    }

    private void enableAll(ConfigurationSection rootSection, boolean enabled) {
        Set keys = rootSection.getKeys(false);
        for (String key : keys) {
            ConfigurationSection section = rootSection.getConfigurationSection(key);
            if (!section.isSet("enabled") || section.getBoolean("enabled")) continue;
            section.set("enabled", null);
        }
    }

    private void enableAll(ConfigurationSection rootSection) {
        this.enableAll(rootSection, true);
    }

    private void disableAll(ConfigurationSection rootSection) {
        this.enableAll(rootSection, false);
    }

    private ConfigurationSection loadConfigFolder(ConfigurationSection config, File configSubFolder, boolean setEnabled) throws IOException, InvalidConfigurationException {
        if (configSubFolder.exists()) {
            ArrayList<File> priorityFiles = new ArrayList<File>();
            File[] files = configSubFolder.listFiles();
            for (File file : files) {
                if (file.getName().startsWith(".")) continue;
                if (file.isDirectory()) {
                    config = this.loadConfigFolder(config, file, setEnabled);
                    continue;
                }
                if (!file.getName().endsWith(".yml")) continue;
                if (file.getName().startsWith("_")) {
                    priorityFiles.add(file);
                    continue;
                }
                try {
                    ConfigurationSection fileOverrides = CompatibilityUtils.loadConfiguration(file);
                    this.info(" Loading " + file.getName());
                    if (setEnabled) {
                        this.enableAll(fileOverrides);
                    }
                    config = ConfigurationUtils.addConfigurations(config, fileOverrides);
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading: " + file.getName());
                    throw ex;
                }
            }
            for (File file : priorityFiles) {
                try {
                    ConfigurationSection fileOverrides = CompatibilityUtils.loadConfiguration(file);
                    this.info(" Loading " + file.getName());
                    if (setEnabled) {
                        this.enableAll(fileOverrides);
                    }
                    config = ConfigurationUtils.addConfigurations(config, fileOverrides);
                }
                catch (Exception ex) {
                    this.getLogger().severe("Error loading: " + file.getName());
                    throw ex;
                }
            }
        } else {
            configSubFolder.mkdir();
        }
        return config;
    }

    private ConfigurationSection mapSpells(ConfigurationSection spellConfiguration) throws InvalidConfigurationException, IOException {
        MemoryConfiguration spellConfigs = new MemoryConfiguration();
        if (spellConfiguration == null) {
            return spellConfigs;
        }
        this.spellConfigurations.clear();
        this.baseSpellConfigurations.clear();
        Set spellKeys = spellConfiguration.getKeys(false);
        for (String key : spellKeys) {
            ConfigurationSection spellNode;
            if (key.equals("default") || key.equals("override") || !ConfigurationUtils.isEnabled(spellNode = this.getSpellConfig(key, spellConfiguration))) continue;
            if (this.noPvpRestricted) {
                spellNode.set("pvp_restricted", (Object)false);
            } else if (this.allPvpRestricted) {
                spellNode.set("pvp_restricted", (Object)true);
            }
            spellConfigs.set(key, (Object)spellNode);
        }
        return spellConfigs;
    }

    @Nullable
    private ConfigurationSection getSpellConfig(String key, ConfigurationSection config) {
        return this.getSpellConfig(key, config, true);
    }

    @Nullable
    private ConfigurationSection getSpellConfig(String key, ConfigurationSection config, boolean addInherited) {
        this.resolvingKeys.clear();
        return this.getSpellConfig(key, config, addInherited, this.resolvingKeys);
    }

    @Nullable
    private ConfigurationSection getSpellConfig(String key, ConfigurationSection config, boolean addInherited, Set<String> resolving) {
        boolean processInherited;
        ConfigurationSection built;
        if (this.resolvingKeys.contains(key)) {
            this.getLogger().log(Level.WARNING, "Circular dependency detected in spell configs: " + StringUtils.join(this.resolvingKeys, (String)" -> ") + " -> " + key);
            return config;
        }
        this.resolvingKeys.add(key);
        if (addInherited ? (built = this.spellConfigurations.get(key)) != null : (built = this.baseSpellConfigurations.get(key)) != null) {
            return built;
        }
        ConfigurationSection spellNode = config.getConfigurationSection(key);
        if (spellNode == null) {
            this.getLogger().warning("Spell " + key + " not known");
            return null;
        }
        spellNode = ConfigurationUtils.cloneConfiguration(spellNode);
        SpellKey spellKey = new SpellKey(key);
        String inheritFrom = spellNode.getString("inherit");
        if (inheritFrom != null && inheritFrom.equalsIgnoreCase("false")) {
            inheritFrom = null;
        }
        String upgradeInheritsFrom = null;
        if (spellKey.isVariant()) {
            if (!this.spellUpgradesEnabled) {
                return null;
            }
            int level = spellKey.getLevel();
            upgradeInheritsFrom = spellKey.getBaseKey();
            if (level != 2) {
                upgradeInheritsFrom = upgradeInheritsFrom + "|" + (level - 1);
            }
        }
        boolean bl = processInherited = addInherited && inheritFrom != null;
        if (processInherited || upgradeInheritsFrom != null) {
            if (processInherited && key.equals(inheritFrom)) {
                this.getLogger().warning("Spell " + key + " inherits from itself");
            } else if (processInherited) {
                ConfigurationSection inheritConfig = this.getSpellConfig(inheritFrom, config, true, resolving);
                if (inheritConfig != null) {
                    Boolean enabled = spellNode.contains("enabled") ? Boolean.valueOf(spellNode.getBoolean("enabled")) : null;
                    spellNode = ConfigurationUtils.addConfigurations(spellNode, inheritConfig, false);
                    spellNode.set("enabled", (Object)enabled);
                } else {
                    this.getLogger().warning("Spell " + key + " inherits from unknown ancestor " + inheritFrom);
                }
            }
            if (upgradeInheritsFrom != null) {
                if (config.contains(upgradeInheritsFrom)) {
                    ConfigurationSection baseInheritConfig = this.getSpellConfig(upgradeInheritsFrom, config, inheritFrom == null, resolving);
                    spellNode = ConfigurationUtils.addConfigurations(spellNode, baseInheritConfig, inheritFrom != null);
                } else {
                    this.getLogger().warning("Spell upgrade " + key + " inherits from unknown level " + upgradeInheritsFrom);
                }
            }
        } else {
            ConfigurationSection defaults = config.getConfigurationSection("default");
            if (defaults != null) {
                spellNode = ConfigurationUtils.addConfigurations(spellNode, defaults, false);
            }
        }
        if (addInherited) {
            this.spellConfigurations.put(key, spellNode);
        } else {
            this.baseSpellConfigurations.put(key, spellNode);
        }
        ConfigurationSection override = config.getConfigurationSection("override");
        if (override != null) {
            spellNode = ConfigurationUtils.addConfigurations(spellNode, override, true);
        }
        return spellNode;
    }

    private void run(boolean synchronous) {
        this.success = true;
        MagicLogger logger = this.controller.getLogger();
        try {
            this.mainConfiguration = this.loadMainConfiguration();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error loading config.yml", ex);
            this.success = false;
            this.mainConfiguration = new MemoryConfiguration();
        }
        this.mainConfigurations.put("", this.mainConfiguration);
        this.loadedConfigurations.clear();
        for (String configurationFile : CONFIG_FILES) {
            try {
                ConfigurationSection configuration = this.loadConfigFile(configurationFile, this.mainConfiguration);
                if (configurationFile.equals("spells")) {
                    configuration = this.mapSpells(configuration);
                }
                this.loadedConfigurations.put(configurationFile, configuration);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Error loading " + configurationFile, ex);
                this.loadedConfigurations.put(configurationFile, (ConfigurationSection)new MemoryConfiguration());
                this.success = false;
            }
        }
        if (synchronous) {
            this.controller.finalizeLoad(this, this.sender);
        } else {
            MagicPlugin plugin = this.controller.getPlugin();
            final ConfigurationLoadTask result = this;
            plugin.getServer().getScheduler().runTask((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    ConfigurationLoadTask.this.controller.finalizeLoad(result, ConfigurationLoadTask.this.sender);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = loadLock;
        synchronized (object) {
            this.run(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runNow() {
        Object object = loadLock;
        synchronized (object) {
            this.run(true);
        }
    }

    public ConfigurationSection getMainConfiguration() {
        return this.mainConfiguration;
    }

    @Nonnull
    public ConfigurationSection getMainConfiguration(String exampleKey) {
        ConfigurationSection mainConfig = this.mainConfigurations.get(exampleKey);
        if (mainConfig == null) {
            mainConfig = new MemoryConfiguration();
            this.mainConfigurations.put(exampleKey, mainConfig);
        }
        return mainConfig;
    }

    public ConfigurationSection getMessages() {
        return this.loadedConfigurations.get("messages");
    }

    public ConfigurationSection getMaterials() {
        return this.loadedConfigurations.get("materials");
    }

    public ConfigurationSection getWands() {
        return this.loadedConfigurations.get("wands");
    }

    public ConfigurationSection getPaths() {
        return this.loadedConfigurations.get("paths");
    }

    public ConfigurationSection getCrafting() {
        return this.loadedConfigurations.get("crafting");
    }

    public ConfigurationSection getMobs() {
        return this.loadedConfigurations.get("mobs");
    }

    public ConfigurationSection getItems() {
        return this.loadedConfigurations.get("items");
    }

    public ConfigurationSection getClasses() {
        return this.loadedConfigurations.get("classes");
    }

    public ConfigurationSection getModifiers() {
        return this.loadedConfigurations.get("modifiers");
    }

    public ConfigurationSection getAttributes() {
        return this.loadedConfigurations.get("attributes");
    }

    public ConfigurationSection getAutomata() {
        return this.loadedConfigurations.get("automata");
    }

    public ConfigurationSection getEffects() {
        return this.loadedConfigurations.get("effects");
    }

    public ConfigurationSection getSpells() {
        return this.loadedConfigurations.get("spells");
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public String getExampleDefaults() {
        return this.exampleDefaults;
    }

    public Collection<String> getAddExamples() {
        return this.addExamples;
    }
}

