/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.spell.TargetType;
import com.elmakers.mine.bukkit.batch.ConstructBatch;
import com.elmakers.mine.bukkit.block.ConstructionType;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.spell.BrushSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class ConstructSpell
extends BrushSpell {
    public static final String[] CONSTRUCT_PARAMETERS = new String[]{"radius", "falling", "speed", "max_dimension", "replace", "consume", "type", "thickness", "orient_dimension_max", "orient_dimension_min", "breakable", "backfire", "select_self", "use_brush_size", "falling_direction"};
    private static final ConstructionType DEFAULT_CONSTRUCTION_TYPE = ConstructionType.SPHERE;
    private static final int DEFAULT_RADIUS = 2;
    private static final int DEFAULT_MAX_DIMENSION = 16;
    private Block targetBlock = null;
    private boolean powered = false;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        boolean success;
        boolean hasPermission;
        boolean finalCast;
        Block target = null;
        boolean isSelect = this.getTargetType() == TargetType.SELECT;
        boolean bl = finalCast = !isSelect || this.targetBlock != null;
        if (finalCast && parameters.getBoolean("select_self", true) && this.isLookingDown()) {
            target = this.mage.getLocation().getBlock().getRelative(BlockFace.DOWN);
        } else {
            Target t = this.getTarget();
            target = t.getBlock();
        }
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        MaterialBrush buildWith = this.getBrush();
        boolean bl2 = hasPermission = buildWith != null && buildWith.isErase() ? this.hasBreakPermission(target) : this.hasBuildPermission(target);
        if (!hasPermission) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int radius = parameters.getInt("radius", 2);
        radius = parameters.getInt("r", radius);
        radius = parameters.getInt("size", radius);
        boolean falling = parameters.getBoolean("falling", false);
        boolean commit = parameters.getBoolean("commit", false);
        boolean consume = parameters.getBoolean("consume", false);
        boolean checkChunks = parameters.getBoolean("check_chunks", true);
        double breakable = parameters.getDouble("breakable", 0.0);
        double backfireChance = parameters.getDouble("reflect_chance", 0.0);
        String physicsType = parameters.getString("physics", "");
        Vector orientTo = null;
        if (isSelect) {
            if (this.targetLocation2 != null) {
                this.targetBlock = this.targetLocation2.getBlock();
            }
            if (this.targetBlock == null || !this.targetBlock.getWorld().equals(target.getWorld())) {
                this.targetBlock = target;
                this.activate();
                this.setSelectedLocation(this.targetBlock.getLocation());
                return SpellResult.TARGET_SELECTED;
            }
            radius = (int)this.targetBlock.getLocation().distance(target.getLocation());
            if (parameters.getBoolean("orient")) {
                orientTo = target.getLocation().toVector().subtract(this.targetBlock.getLocation().toVector());
                orientTo.setX(Math.abs(orientTo.getX()));
                orientTo.setY(Math.abs(orientTo.getY()));
                orientTo.setZ(Math.abs(orientTo.getZ()));
                orientTo = orientTo.getX() < orientTo.getZ() && orientTo.getX() < orientTo.getY() ? new Vector(1, 0, 0) : (orientTo.getZ() < orientTo.getX() && orientTo.getZ() < orientTo.getY() ? new Vector(0, 0, 1) : new Vector(0, 1, 0));
            }
            target = this.targetBlock;
            this.targetBlock = null;
        } else if (parameters.getBoolean("orient")) {
            orientTo = this.mage.getLocation().toVector().subtract(target.getLocation().toVector());
            orientTo.setX(Math.abs(orientTo.getX()));
            orientTo.setY(Math.abs(orientTo.getY()));
            orientTo.setZ(Math.abs(orientTo.getZ()));
            orientTo = orientTo.getX() > orientTo.getZ() && orientTo.getX() > orientTo.getY() ? new Vector(1, 0, 0) : (orientTo.getZ() > orientTo.getX() && orientTo.getZ() > orientTo.getY() ? new Vector(0, 0, 1) : new Vector(0, 1, 0));
        }
        if (!parameters.contains("radius")) {
            int maxDimension = parameters.getInt("max_dimension", 16);
            maxDimension = parameters.getInt("md", maxDimension);
            int diameter = radius * 2;
            maxDimension = (int)(this.mage.getConstructionMultiplier() * (float)maxDimension);
            if (diameter > maxDimension) {
                return SpellResult.FAIL;
            }
        }
        if (parameters.contains("y_offset")) {
            target = target.getRelative(BlockFace.UP, parameters.getInt("y_offset", 0));
        }
        buildWith.setTarget(target.getLocation());
        ConstructionType conType = DEFAULT_CONSTRUCTION_TYPE;
        int thickness = parameters.getInt("thickness", 0);
        String typeString = parameters.getString("type", "");
        ConstructionType testType = ConstructionType.parseString(typeString, ConstructionType.UNKNOWN);
        if (testType != ConstructionType.UNKNOWN) {
            conType = testType;
        }
        ConstructBatch batch = new ConstructBatch(this, target.getLocation(), conType, radius, thickness, falling, orientTo);
        batch.setUseBrushSize(parameters.getBoolean("use_brush_size", false));
        batch.setCommit(commit);
        batch.setConsume(consume);
        batch.setCheckChunks(checkChunks);
        UndoList undoList = this.getUndoList();
        if (undoList != null && !this.currentCast.isConsumeFree()) {
            undoList.setConsumed(consume);
        }
        if (parameters.getBoolean("replace", false)) {
            boolean matchData = parameters.getBoolean("match_data", true);
            if (this.mage.isSneaking()) {
                matchData = parameters.getBoolean("sneak_match_data", matchData);
            }
            if (matchData) {
                batch.setReplace(new MaterialAndData(target));
            } else {
                batch.setReplaceType(target.getType());
            }
        }
        if (parameters.contains("commands")) {
            ConfigurationSection commandMap = parameters.getConfigurationSection("commands");
            Set keys = commandMap.getKeys(false);
            for (String key : keys) {
                this.brush.addCommandMapping(key, commandMap.getString(key));
            }
        }
        if (falling) {
            float force = (float)parameters.getDouble("speed", 0.0);
            batch.setFallingDirection(ConfigurationUtils.getVector(parameters, "falling_direction"));
            batch.setFallingBlockSpeed(force);
        }
        batch.setApplyPhysics(physicsType.equalsIgnoreCase("true"));
        batch.setDeferPhysics(physicsType.equalsIgnoreCase("defer"));
        if (breakable > 0.0) {
            batch.setBreakable(breakable);
        }
        if (backfireChance > 0.0) {
            batch.setBackfireChance(backfireChance);
        }
        if (parameters.contains("orient_dimension_max")) {
            batch.setOrientDimensionMax(parameters.getInt("orient_dimension_max"));
        } else if (parameters.contains("odmax")) {
            batch.setOrientDimensionMax(parameters.getInt("odmax"));
        }
        if (parameters.contains("orient_dimension_min")) {
            batch.setOrientDimensionMin(parameters.getInt("orient_dimension_min"));
        } else if (parameters.contains("odmin")) {
            batch.setOrientDimensionMin(parameters.getInt("odmin"));
        }
        if (parameters.getBoolean("power", false)) {
            batch.setPower(true);
        }
        return (success = this.mage.addBatch(batch)) ? SpellResult.CAST : SpellResult.FAIL;
    }

    @Override
    protected void onFinalizeCast(SpellResult result) {
        if (result != SpellResult.TARGET_SELECTED) {
            this.deactivate(false, true, false);
        }
    }

    @Override
    protected boolean isBatched() {
        return true;
    }

    @Override
    public void onDeactivate() {
        this.targetBlock = null;
        this.setSelectedLocation(null);
    }

    @Override
    public boolean onCancelSelection() {
        return this.targetBlock != null;
    }

    @Override
    public boolean hasBrushOverride() {
        return this.powered || super.hasBrushOverride();
    }

    @Override
    protected void loadTemplate(ConfigurationSection node) {
        super.loadTemplate(node);
        ConfigurationSection parameters = node.getConfigurationSection("parameters");
        if (parameters != null) {
            this.powered = parameters.getBoolean("power", false);
            if (this.powered) {
                this.controller.getLogger().warning("Using the 'power' flag with ConstructSpell is deprecated and will be removed in the future. Please use a Sphere + PowerBlock combination instead.");
            }
        }
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        parameters.addAll(Arrays.asList(CONSTRUCT_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("radius") || parameterKey.equals("max_dimension") || parameterKey.equals("orient_dimension_max") || parameterKey.equals("orient_dimension_min") || parameterKey.equals("thickness") || parameterKey.equals("speed")) {
            examples.addAll(Arrays.asList(EXAMPLE_SIZES));
        } else if (parameterKey.equals("type")) {
            ConstructionType[] constructionTypes;
            for (ConstructionType constructionType : constructionTypes = ConstructionType.values()) {
                examples.add(constructionType.name().toLowerCase());
            }
        } else if (parameterKey.equals("power") || parameterKey.equals("replace") || parameterKey.equals("falling")) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        }
    }
}

