/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.utility.ColorHD;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class BrushSpell
extends BlockSpell {
    protected com.elmakers.mine.bukkit.block.MaterialBrush brush;
    protected String brushKey;
    protected boolean hasBrush = false;
    protected boolean usesBrush = true;
    protected boolean brushIsErase = false;
    protected boolean usesBrushEffects = true;
    protected Boolean showBrush = null;
    public static final String[] BRUSH_PARAMETERS = new String[]{"brushmod", "brush", "obx", "oby", "obz", "obworld", "btarget", "brushcolor", "preserve_data"};

    @Override
    public void processParameters(ConfigurationSection parameters) {
        super.processParameters(parameters);
        this.brushKey = parameters.getString("brush", null);
        this.brushIsErase = this.brushKey != null && (this.brushKey.equalsIgnoreCase("erase") || this.brushKey.equalsIgnoreCase("air"));
        boolean bl = this.hasBrush = this.brushKey != null && !this.brushKey.isEmpty();
        if (this.hasBrush) {
            Color color;
            this.brush = new com.elmakers.mine.bukkit.block.MaterialBrush(this.mage, this.getLocation(), this.brushKey);
            if (parameters.getBoolean("preserve_data", false)) {
                this.brush.setData(null);
            }
            if (parameters.contains("brushmod")) {
                this.brush.update(parameters.getString("brushmod"));
                this.brush.update(this.brushKey);
            }
            Double dmxValue = ConfigurationUtils.getDouble(parameters, "obx", null);
            Double dmyValue = ConfigurationUtils.getDouble(parameters, "oby", null);
            Double dmzValue = ConfigurationUtils.getDouble(parameters, "obz", null);
            String targetWorldName = parameters.getString("obworld", null);
            if (dmxValue != null || dmyValue != null || dmzValue != null || targetWorldName != null) {
                Vector offset = new Vector(dmxValue == null ? 0.0 : dmxValue, dmyValue == null ? 0.0 : dmyValue, dmzValue == null ? 0.0 : dmzValue);
                this.brush.clearCloneTarget();
                this.brush.setTargetOffset(offset, targetWorldName);
            }
            if (parameters.getBoolean("brushtarget", false)) {
                this.brush.clearCloneLocation();
            }
            if (parameters.getBoolean("brushcolor", false) && (color = this.mage.getEffectColor()) != null) {
                DyeColor bestDyeColor = null;
                Double bestDistance = null;
                for (DyeColor testDyeColor : DyeColor.values()) {
                    Color testColor = testDyeColor.getColor();
                    double testDistance = ColorHD.getDistance(testColor, color);
                    if (bestDistance != null && !(testDistance < bestDistance)) continue;
                    bestDistance = testDistance;
                    bestDyeColor = testDyeColor;
                    if (testDistance == 0.0) break;
                }
                if (bestDyeColor != null) {
                    this.brush.colorize(bestDyeColor);
                }
            }
            if (parameters.contains("brush_commands")) {
                ConfigurationSection commandMap = parameters.getConfigurationSection("brush_commands");
                Set keys = commandMap.getKeys(false);
                for (String key : keys) {
                    this.brush.addCommandMapping(key, commandMap.getString(key));
                }
            }
        } else {
            this.brush = null;
        }
    }

    @Override
    protected void loadTemplate(ConfigurationSection node) {
        ConfigurationSection parameters;
        super.loadTemplate(node);
        this.usesBrush = node.getBoolean("uses_brush", this.usesBrush);
        this.usesBrushEffects = node.getBoolean("brush_effects", true);
        if (node.contains("show_brush")) {
            this.showBrush = node.getBoolean("show_brush");
        }
        if ((parameters = node.getConfigurationSection("parameters")) != null) {
            this.brushKey = parameters.getString("brush", null);
            this.hasBrush = this.brushKey != null && !this.brushKey.isEmpty();
        } else {
            this.brushKey = null;
            this.hasBrush = false;
        }
        this.brushIsErase = this.brushKey != null && (this.brushKey.equalsIgnoreCase("erase") || this.brushKey.equalsIgnoreCase("air"));
    }

    @Override
    public boolean brushIsErase() {
        if (this.mage != null && !this.hasBrush) {
            return this.getBrush().isErase();
        }
        return this.brushIsErase;
    }

    @Override
    public boolean requiresBuildPermission() {
        return !this.brushIsErase();
    }

    @Override
    public boolean requiresBreakPermission() {
        return this.brushIsErase();
    }

    @Override
    @Nullable
    public MaterialBrush getBrush() {
        if (this.brush == null && this.hasBrush) {
            this.brush = new com.elmakers.mine.bukkit.block.MaterialBrush(this.controller, this.brushKey);
        }
        if (this.brush != null) {
            return this.brush;
        }
        return super.getBrush();
    }

    @Override
    @Nullable
    public MaterialAndData getEffectMaterial() {
        if (!this.usesBrush || !this.usesBrushEffects) {
            return null;
        }
        return this.getBrush();
    }

    @Override
    public boolean hasBrushOverride() {
        return this.hasBrush;
    }

    @Override
    public boolean usesBrush() {
        return this.usesBrush && !this.hasBrushOverride();
    }

    @Override
    public boolean showBrush() {
        if (this.showBrush != null) {
            return this.showBrush;
        }
        return this.usesBrushSelection();
    }

    @Override
    protected String getDisplayMaterialName() {
        MaterialBrush useBrush;
        if (this.usesBrush && (useBrush = this.getBrush()) != null) {
            return useBrush.getName();
        }
        return super.getDisplayMaterialName();
    }

    @Override
    public void getParameters(Collection<String> parameters) {
        super.getParameters(parameters);
        parameters.addAll(Arrays.asList(BRUSH_PARAMETERS));
    }

    @Override
    public void getParameterOptions(Collection<String> examples, String parameterKey) {
        super.getParameterOptions(examples, parameterKey);
        if (parameterKey.equals("bmod") || parameterKey.equals("brush")) {
            examples.addAll(this.controller.getBrushKeys());
        } else if (parameterKey.equals("btarget")) {
            examples.addAll(Arrays.asList(EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("obx") || parameterKey.equals("oby") || parameterKey.equals("obz")) {
            examples.addAll(Arrays.asList(EXAMPLE_VECTOR_COMPONENTS));
        } else if (parameterKey.equals("obworld")) {
            List worlds = Bukkit.getWorlds();
            for (World world : worlds) {
                examples.add(world.getName());
            }
        }
    }
}

