/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.resourcepack;

import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.resourcepack.ResourcePack;
import com.elmakers.mine.bukkit.resourcepack.ResourcePackResponse;
import com.elmakers.mine.bukkit.resourcepack.ResourcePackUpdateRunnable;
import com.elmakers.mine.bukkit.tasks.RPCheckTask;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.TextUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ResourcePackManager {
    private static final String RP_FILE = "resourcepack";
    private final MagicController controller;
    private boolean enableResourcePackCheck = true;
    private int resourcePackPromptDelay = 0;
    private boolean resourcePackPrompt = false;
    private int resourcePackCheckInterval = 0;
    private int resourcePackCheckTimer = 0;
    private String defaultResourcePack = null;
    private String resourcePack = null;
    private byte[] resourcePackHash = null;
    private long resourcePackDelay = 0L;
    private boolean isResourcePackEnabledByDefault = true;
    private final Map<String, ResourcePack> resourcePacks = new HashMap<String, ResourcePack>();
    private boolean resourcePackConfigurationLoaded = false;
    private ConfigurationSection alternateResourcePacks = null;

    public ResourcePackManager(MagicController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection properties, CommandSender sender, boolean firstLoad) {
        String currentResourcePack = this.defaultResourcePack;
        this.isResourcePackEnabledByDefault = properties.getBoolean("resource_pack_default_auto", true);
        this.resourcePackPrompt = properties.getBoolean("resource_pack_prompt", false);
        this.enableResourcePackCheck = properties.getBoolean("enable_resource_pack_check", true);
        this.resourcePackCheckInterval = properties.getInt("resource_pack_check_interval", 0);
        this.resourcePackPromptDelay = properties.getInt("resource_pack_prompt_delay", 0);
        this.defaultResourcePack = properties.getString("resource_pack", null);
        this.defaultResourcePack = properties.getString("default_resource_pack", this.defaultResourcePack);
        if (this.controller.hasAddedExamples() && !this.defaultResourcePack.isEmpty()) {
            this.defaultResourcePack = properties.getString("add_resource_pack", this.defaultResourcePack);
        }
        if (!properties.getBoolean("enable_resource_pack")) {
            this.defaultResourcePack = null;
        }
        if (this.defaultResourcePack == null || this.defaultResourcePack.isEmpty()) {
            this.resourcePack = null;
            this.resourcePackHash = null;
        }
        this.resourcePackDelay = properties.getLong("resource_pack_delay", 0L);
        this.alternateResourcePacks = properties.getConfigurationSection("alternate_resource_packs");
        if (!firstLoad && this.resourcePack != null && !this.defaultResourcePack.equals(currentResourcePack)) {
            this.checkResourcePack(sender, false, false, true);
        }
    }

    public boolean sendResourcePackToAllPlayers(CommandSender sender) {
        if (this.resourcePack == null || this.resourcePackHash == null) {
            if (sender != null) {
                sender.sendMessage(ChatColor.RED + "No RP set or RP already set in server.properties, not sending.");
            }
            return false;
        }
        int sent = 0;
        int skipped = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            Mage mage = this.controller.getRegisteredMage((Entity)player);
            if (mage != null && !mage.isResourcePackEnabled()) {
                ++skipped;
                continue;
            }
            this.sendResourcePack(mage);
            ++sent;
        }
        if (sender != null) {
            sender.sendMessage(ChatColor.AQUA + "Sent current RP to " + sent + " players, skipped " + skipped + " players");
        }
        return true;
    }

    protected boolean promptResourcePack(final Player player, final String message) {
        if (message != null && !message.isEmpty()) {
            if (this.resourcePackPromptDelay <= 0) {
                TextUtils.sendMessage((CommandSender)player, this.controller.getMessagePrefix(), message);
            } else {
                MagicPlugin plugin = this.controller.getPlugin();
                plugin.getServer().getScheduler().runTaskLater((Plugin)plugin, new Runnable(){

                    @Override
                    public void run() {
                        TextUtils.sendMessage((CommandSender)player, ResourcePackManager.this.controller.getMessagePrefix(), message);
                    }
                }, (long)(this.resourcePackPromptDelay / 50));
            }
        }
        return true;
    }

    public boolean promptResourcePack(Player player) {
        if (this.resourcePack == null || this.resourcePackHash == null) {
            return false;
        }
        if (this.resourcePackPrompt) {
            String message = this.controller.getMessages().get("resource_pack.prompt");
            this.promptResourcePack(player, message);
            return false;
        }
        return this.sendResourcePack(player);
    }

    public boolean promptNoResourcePack(Player player) {
        if (this.resourcePack == null || this.resourcePackHash == null) {
            return false;
        }
        String message = this.controller.getMessages().get("resource_pack.off_prompt");
        return this.promptResourcePack(player, message);
    }

    public boolean sendResourcePack(final com.elmakers.mine.bukkit.api.magic.Mage mage) {
        ResourcePack rp;
        String url = this.getResourcePackUrl(mage.getPreferredResourcePack());
        if (url == null) {
            url = this.resourcePack;
        }
        if (!(rp = this.createResourcePack(url)).isChecked()) {
            this.updateResourcePackHash(rp, false, false, new ResourcePackResponse(){

                @Override
                public void finished(boolean success, List<String> responses, ResourcePack pack) {
                    MagicPlugin plugin = ResourcePackManager.this.controller.getPlugin();
                    ConsoleCommandSender sender = Bukkit.getConsoleSender();
                    if (plugin.isEnabled()) {
                        for (String response : responses) {
                            sender.sendMessage(response);
                        }
                    }
                    if (success) {
                        ResourcePackManager.this.sendResourcePack(mage, rp);
                    }
                }
            });
            return true;
        }
        return this.sendResourcePack(mage, rp);
    }

    public boolean sendResourcePack(Player player) {
        return this.sendResourcePack(this.controller.getMage(player));
    }

    public boolean sendResourcePack(com.elmakers.mine.bukkit.api.magic.Mage mage, ResourcePack pack) {
        return this.sendResourcePack(mage, pack.getUrl(), pack.getHash());
    }

    public boolean sendResourcePack(com.elmakers.mine.bukkit.api.magic.Mage mage, final String url, final byte[] hash) {
        if (url == null || hash == null) {
            return false;
        }
        final Player player = mage.getPlayer();
        String message = this.controller.getMessages().get("resource_pack.sending");
        if (message != null && !message.isEmpty()) {
            TextUtils.sendMessage((CommandSender)player, this.controller.getMessagePrefix(), message);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.controller.getPlugin(), new Runnable(){

            @Override
            public void run() {
                CompatibilityUtils.setResourcePack(player, url, hash);
            }
        }, this.resourcePackDelay * 20L / 1000L);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ResourcePack> getResourcePacks() {
        Map<String, ResourcePack> map = this.resourcePacks;
        synchronized (map) {
            if (!this.resourcePackConfigurationLoaded) {
                this.resourcePackConfigurationLoaded = true;
                File rpFile = new File(this.controller.getPlugin().getDataFolder(), "data/resourcepack.yml");
                if (rpFile.exists()) {
                    try {
                        YamlConfiguration resourcePackConfiguration = new YamlConfiguration();
                        resourcePackConfiguration.load(rpFile);
                        Set keys = resourcePackConfiguration.getKeys(false);
                        for (String key : keys) {
                            this.resourcePacks.put(key, new ResourcePack(key, resourcePackConfiguration.getConfigurationSection(key)));
                        }
                    }
                    catch (Exception ex) {
                        this.controller.getLogger().log(Level.WARNING, "Error loading resource pack save file", ex);
                    }
                }
            }
        }
        return this.resourcePacks;
    }

    protected ResourcePack getResourcePack(String url) {
        return this.getResourcePacks().get(ResourcePack.getKey(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourcePack createResourcePack(String url) {
        ResourcePack pack = this.getResourcePack(url);
        if (pack == null) {
            Map<String, ResourcePack> map = this.resourcePacks;
            synchronized (map) {
                pack = new ResourcePack(url);
                this.resourcePacks.put(pack.getKey(), pack);
            }
        }
        pack.setUrl(url);
        return pack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveResourcePacks() {
        Map<String, ResourcePack> packs = this.getResourcePacks();
        Map<String, ResourcePack> map = this.resourcePacks;
        synchronized (map) {
            try {
                File rpFile = new File(this.controller.getPlugin().getDataFolder(), "data/resourcepack.yml");
                YamlConfiguration resourcePackConfiguration = new YamlConfiguration();
                for (Map.Entry<String, ResourcePack> entry : packs.entrySet()) {
                    ConfigurationSection save = resourcePackConfiguration.createSection(entry.getKey());
                    entry.getValue().save(save);
                }
                resourcePackConfiguration.save(rpFile);
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Error saving resource pack save file", ex);
            }
        }
    }

    public boolean checkResourcePack(CommandSender sender, final boolean quiet, boolean force, boolean filenameChanged) {
        MagicPlugin plugin = this.controller.getPlugin();
        if (!plugin.isEnabled()) {
            return false;
        }
        Server server = plugin.getServer();
        this.resourcePack = null;
        this.resourcePackHash = null;
        if (this.defaultResourcePack == null || this.defaultResourcePack.isEmpty()) {
            if (!quiet) {
                sender.sendMessage("Resource pack in config.yml has been disabled, Magic skipping RP check");
            }
            return false;
        }
        String serverResourcePack = CompatibilityUtils.getResourcePack(server);
        if (serverResourcePack != null) {
            serverResourcePack = serverResourcePack.trim();
        }
        if (serverResourcePack != null && !serverResourcePack.isEmpty()) {
            if (!quiet) {
                sender.sendMessage("Resource pack configured in server.properties, Magic not using RP from config.yml");
            }
            return false;
        }
        this.resourcePack = this.defaultResourcePack;
        if (!quiet) {
            sender.sendMessage("Magic checking resource pack for updates: " + ChatColor.GRAY + this.resourcePack);
        }
        ResourcePack resourcePackInfo = this.createResourcePack(this.resourcePack);
        this.updateResourcePackHash(resourcePackInfo, force, filenameChanged, new ResourcePackResponse((Plugin)plugin, sender){
            final /* synthetic */ Plugin val$plugin;
            final /* synthetic */ CommandSender val$sender;
            {
                this.val$plugin = plugin;
                this.val$sender = commandSender;
            }

            @Override
            public void finished(boolean success, List<String> responses, ResourcePack pack) {
                if (!quiet && this.val$plugin.isEnabled()) {
                    for (String response : responses) {
                        this.val$sender.sendMessage(response);
                    }
                }
                if (!success) {
                    ResourcePackManager.this.cancelResourcePackChecks();
                    if (!quiet) {
                        this.val$sender.sendMessage("Cancelling automatic RP checks until next restart");
                    }
                } else {
                    ResourcePackManager.access$102(ResourcePackManager.this, pack.getHash());
                }
            }
        });
        return true;
    }

    public void updateResourcePackHash(ResourcePack resourcePack, boolean force, boolean filenameChanged, ResourcePackResponse callback) {
        MagicPlugin plugin = this.controller.getPlugin();
        if (!plugin.isEnabled()) {
            return;
        }
        Server server = plugin.getServer();
        server.getScheduler().runTaskAsynchronously((Plugin)plugin, (Runnable)new ResourcePackUpdateRunnable(this, resourcePack, callback, force, filenameChanged));
    }

    protected void cancelResourcePackChecks() {
        if (this.resourcePackCheckTimer != 0) {
            Bukkit.getScheduler().cancelTask(this.resourcePackCheckTimer);
            this.resourcePackCheckTimer = 0;
        }
    }

    public void startResourcePackChecks() {
        if (this.checkResourcePack((CommandSender)Bukkit.getConsoleSender(), false, false, false) && this.resourcePackCheckInterval > 0 && this.enableResourcePackCheck) {
            int intervalTicks = this.resourcePackCheckInterval * 60 * 20;
            this.resourcePackCheckTimer = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.controller.getPlugin(), (Runnable)new RPCheckTask(this.controller), (long)intervalTicks, (long)intervalTicks);
        }
    }

    public String getDefaultResourcePackURL() {
        return this.resourcePack;
    }

    public boolean isResourcePackEnabledByDefault() {
        return this.isResourcePackEnabledByDefault;
    }

    public MagicController getController() {
        return this.controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChecked() {
        Map<String, ResourcePack> map = this.resourcePacks;
        synchronized (map) {
            for (ResourcePack pack : this.resourcePacks.values()) {
                pack.setChecked(false);
            }
        }
    }

    @Nullable
    public Boolean resourcePackUsesSkulls(String packType) {
        ConfigurationSection packConfig = this.alternateResourcePacks.getConfigurationSection(packType);
        return packConfig == null || !packConfig.contains("url_icons_enabled") ? null : Boolean.valueOf(packConfig.getBoolean("url_icons_enabled"));
    }

    @Nullable
    public String getResourcePackUrl(String packType) {
        if (packType == null) {
            return null;
        }
        ConfigurationSection packConfig = this.alternateResourcePacks.getConfigurationSection(packType);
        return packConfig == null ? null : packConfig.getString("url");
    }

    public Collection<String> getAlternateResourcePacks() {
        return this.alternateResourcePacks.getKeys(false);
    }

    static /* synthetic */ byte[] access$102(ResourcePackManager x0, byte[] x1) {
        x0.resourcePackHash = x1;
        return x1;
    }
}

