/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RPCommandExecutor
extends MagicTabExecutor {
    public RPCommandExecutor(MagicAPI api) {
        super(api, "getrp");
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        ArrayList<String> options = new ArrayList<String>();
        if (!this.api.hasPermission(sender, this.getPermissionNode())) {
            return options;
        }
        if (args.length == 1) {
            options.add("auto");
            options.add("default");
            options.add("manual");
            options.add("off");
            options.add("url");
            options.add("download");
            options.addAll(this.controller.getAlternateResourcePacks());
        }
        return options;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!this.api.hasPermission(sender, this.getPermissionNode())) {
            this.sendNoPermission(sender);
            return true;
        }
        String string = subCommand = args.length > 0 ? args[0] : "";
        if (subCommand.equalsIgnoreCase("url") || subCommand.equalsIgnoreCase("download")) {
            sender.sendMessage(this.controller.getResourcePackURL());
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.controller.getMessages().get("commands.in_game"));
            return true;
        }
        if (subCommand.isEmpty()) {
            sender.sendMessage(this.controller.getMessages().get("commands.getrp.sending"));
            this.controller.sendResourcePack((Player)sender);
            return true;
        }
        Mage mage = (Mage)this.controller.getMage(sender);
        if (subCommand.equalsIgnoreCase("auto")) {
            mage.setResourcePackEnabled(true);
            this.controller.sendResourcePack((Player)sender);
            sender.sendMessage(this.controller.getMessages().get("commands.getrp.auto"));
            return true;
        }
        if (subCommand.equalsIgnoreCase("off")) {
            mage.setResourcePackEnabled(false);
            sender.sendMessage(this.controller.getMessages().get("commands.getrp.turnoff"));
            return true;
        }
        if (subCommand.equalsIgnoreCase("manual")) {
            mage.setResourcePackEnabled(null);
            sender.sendMessage(this.controller.getMessages().get("commands.getrp.manual"));
            return true;
        }
        if (subCommand.equalsIgnoreCase("default")) {
            sender.sendMessage(this.controller.getMessages().get("commands.getrp.default"));
            mage.setPreferredResourcePack(null);
            this.controller.sendResourcePack((Player)sender);
            return true;
        }
        if (this.controller.getAlternateResourcePacks().contains(subCommand)) {
            sender.sendMessage(this.controller.getMessages().get("commands.getrp.preference").replace("$pack", subCommand));
            if (!mage.isResourcePackEnabledSet()) {
                sender.sendMessage(this.controller.getMessages().get("commands.getrp.noauto"));
            }
            mage.setPreferredResourcePack(subCommand);
            this.controller.sendResourcePack((Player)sender);
            return true;
        }
        String message = this.controller.getMessages().get("commands.unknown_command");
        message = message.replace("$command", subCommand);
        sender.sendMessage(message);
        return true;
    }
}

