/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.magic.BaseMageModifier;
import com.elmakers.mine.bukkit.magic.BaseMagicProperties;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageParameters;
import com.elmakers.mine.bukkit.magic.ModifierTemplate;
import com.elmakers.mine.bukkit.magic.TemplateProperties;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;

public class MageModifier
extends BaseMageModifier
implements Comparable<MageModifier>,
com.elmakers.mine.bukkit.api.magic.MageModifier {
    public static final ImmutableSet<String> PROPERTY_KEYS = new ImmutableSet.Builder().addAll(BaseMagicProperties.PROPERTY_KEYS).add((Object[])new String[]{"items", "duration"}).build();

    public MageModifier(@Nonnull Mage mage, @Nonnull ModifierTemplate template) {
        super(mage, MagicPropertyType.MODIFIER, (TemplateProperties)template);
        this.setTemplate(template);
    }

    @Override
    protected String getMessageKey(String key) {
        ModifierTemplate template = this.getTemplate();
        if (template != null) {
            String mageKey = "modifiers." + template.getKey() + "." + key;
            if (this.controller.getMessages().containsKey(mageKey)) {
                return mageKey;
            }
        }
        return "modifier." + key;
    }

    public void onRemoved() {
        this.deactivate();
        this.takeItems();
        this.cancelTrigger("added");
        this.trigger("removed");
    }

    public void onAdd(int duration) {
        this.setProperty("last_add", System.currentTimeMillis());
        this.activate();
        this.giveItems("items");
        this.reset(duration);
        this.trigger("added");
    }

    public void setTemplate(@Nonnull ModifierTemplate template) {
        super.setTemplate(template.getMageTemplate(this.getMage()));
    }

    @Override
    public void load(@Nullable ConfigurationSection configuration) {
        this.configuration = new MageParameters(this.getMage(), "Mage modifier " + this.getKey());
        if (configuration != null) {
            ConfigurationUtils.addConfigurations(this.configuration, configuration);
        }
        this.loadProperties();
    }

    public void reset(int duration) {
        this.setProperty("duration", duration);
        this.setProperty("last_reset", System.currentTimeMillis());
        this.trigger("reset");
    }

    @Override
    public boolean hasDuration() {
        return this.getDuration() > 0;
    }

    @Override
    public int getDuration() {
        return this.getInt("duration");
    }

    @Override
    public int getTimeRemaining() {
        long now = System.currentTimeMillis();
        return (int)(this.getLong("last_reset") + (long)this.getDuration() - now);
    }

    @Override
    public int compareTo(MageModifier other) {
        boolean has = this.hasDuration();
        boolean otherHas = other.hasDuration();
        if (has && !otherHas) {
            return 1;
        }
        if (otherHas && !has) {
            return -1;
        }
        return this.getTimeRemaining() - other.getTimeRemaining();
    }

    @Override
    @Nullable
    public ModifierTemplate getTemplate() {
        return (ModifierTemplate)super.getTemplate();
    }

    @Override
    @Nonnull
    public String getName() {
        ModifierTemplate template = this.getTemplate();
        return template == null ? "?" : template.getName();
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.getTemplate().getDescription();
    }

    @Override
    protected Set<String> getAllPropertyKeys() {
        return PROPERTY_KEYS;
    }
}

