/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.item;

import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

public class ItemData
implements com.elmakers.mine.bukkit.api.item.ItemData {
    public static final String MINECRAFT_ITEM_PREFIX = "minecraft:";
    public static double EARN_SCALE = 0.5;
    private String key;
    private ItemStack item;
    private double worth;
    private Double earns;
    private Set<String> categories = ImmutableSet.of();
    private String creatorId;
    private String creator;
    private boolean locked;

    public ItemData(ItemStack itemStack) {
        this.item = NMSUtils.getCopy(itemStack);
        this.key = itemStack.getType().toString();
        this.locked = Wand.getLockKey(itemStack) != null;
    }

    public ItemData(String materialKey) throws Exception {
        MaterialAndData material = new MaterialAndData(materialKey);
        if (material.isValid() && CompatibilityUtils.isLegacy(material.getMaterial())) {
            short convertData = material.getData() == null ? (short)0 : material.getData();
            material = new MaterialAndData(CompatibilityUtils.migrateMaterial(material.getMaterial(), (byte)convertData));
        }
        if (material.isValid()) {
            this.item = material.getItemStack(1);
        }
        if (this.item == null) {
            throw new Exception("Invalid item key: " + materialKey);
        }
        this.key = materialKey;
    }

    public ItemData(String key, String materialKey) throws Exception {
        this.key = key;
        MaterialAndData material = new MaterialAndData(materialKey);
        if (material.isValid()) {
            this.item = material.getItemStack(1);
        }
        if (this.item == null) {
            throw new Exception("Invalid item key: " + materialKey);
        }
    }

    public static String cleanMinecraftItemName(String materialKey) {
        if (materialKey.startsWith(MINECRAFT_ITEM_PREFIX)) {
            materialKey = materialKey.substring(MINECRAFT_ITEM_PREFIX.length());
        }
        return materialKey;
    }

    public ItemData(String key, ConfigurationSection configuration) throws Exception {
        List<String> categoriesList;
        List lore;
        String customName;
        ConfigurationSection tagSection;
        if (configuration.isItemStack("item")) {
            this.item = configuration.getItemStack("item");
        } else if (configuration.isConfigurationSection("item")) {
            ConfigurationSection itemConfiguration = configuration.getConfigurationSection("item");
            String materialKey = itemConfiguration.getString("type", key);
            MaterialAndData material = new MaterialAndData(materialKey = ItemData.cleanMinecraftItemName(materialKey));
            if (material.isValid()) {
                this.item = material.getItemStack(1);
            }
            if (this.item == null) {
                throw new Exception("Invalid item key: " + materialKey);
            }
            ConfigurationSection tagSection2 = itemConfiguration.getConfigurationSection("tags");
            if (tagSection2 != null) {
                this.item = CompatibilityUtils.makeReal(this.item);
                InventoryUtils.saveTagsToItem(tagSection2, this.item);
            }
        } else {
            String materialKey = configuration.getString("item", key);
            MaterialAndData material = new MaterialAndData(materialKey = ItemData.cleanMinecraftItemName(materialKey));
            if (material.isValid()) {
                this.item = material.getItemStack(1);
            }
            if (this.item == null) {
                throw new Exception("Invalid item key: " + materialKey);
            }
        }
        if (this.item == null) {
            throw new Exception("Invalid item configuration: " + key);
        }
        this.key = key;
        this.worth = configuration.getDouble("worth", 0.0);
        this.earns = configuration.contains("earns") ? Double.valueOf(configuration.getDouble("earns")) : null;
        this.creator = configuration.getString("creator");
        this.creatorId = configuration.getString("creator_id");
        Collection<ConfigurationSection> attributes = ConfigurationUtils.getNodeList(configuration, "attributes");
        if (attributes != null && !attributes.isEmpty()) {
            this.item = InventoryUtils.makeReal(this.item);
            for (ConfigurationSection attributeConfig : attributes) {
                String attributeKey = attributeConfig.getString("type");
                try {
                    int operation;
                    Attribute attribute = Attribute.valueOf((String)attributeKey.toUpperCase());
                    double value = attributeConfig.getDouble("amount");
                    String slot = attributeConfig.getString("slot");
                    String uuidString = attributeConfig.getString("uuid");
                    UUID uuid = null;
                    if (uuidString != null) {
                        try {
                            uuid = UUID.fromString(uuidString);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (uuid == null) {
                        uuid = UUID.randomUUID();
                    }
                    if (CompatibilityUtils.setItemAttribute(this.item, attribute, value, slot, operation = attributeConfig.getInt("operation", 0), uuid)) continue;
                    Bukkit.getLogger().warning("Failed to set attribute: " + attributeKey);
                }
                catch (Exception ex) {
                    Bukkit.getLogger().warning("Invalid attribute: " + attributeKey);
                }
            }
        } else {
            ConfigurationSection simpleAttributes = configuration.getConfigurationSection("attributes");
            if (simpleAttributes != null) {
                InventoryUtils.applyAttributes(this.item, simpleAttributes, configuration.getString("attribute_slot"));
            }
        }
        if ((tagSection = configuration.getConfigurationSection("tags")) != null) {
            this.item = CompatibilityUtils.makeReal(this.item);
            InventoryUtils.saveTagsToItem(tagSection, this.item);
        }
        if ((customName = configuration.getString("name")) != null) {
            ItemMeta meta = this.item.getItemMeta();
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)customName));
            this.item.setItemMeta(meta);
        }
        if ((lore = configuration.getStringList("lore")) != null && !lore.isEmpty()) {
            ItemMeta meta = this.item.getItemMeta();
            for (int i = 0; i < lore.size(); ++i) {
                lore.set(i, ChatColor.translateAlternateColorCodes((char)'&', (String)((String)lore.get(i))));
            }
            meta.setLore(lore);
            this.item.setItemMeta(meta);
        }
        if (configuration.getBoolean("locked")) {
            this.locked = true;
            InventoryUtils.setMetaBoolean(this.item, "locked", true);
            InventoryUtils.setMeta(this.item, "magic_key", key);
        }
        if ((categoriesList = ConfigurationUtils.getStringList(configuration, "categories")) != null) {
            this.categories = ImmutableSet.copyOf(categoriesList);
        }
    }

    public ItemData(String key, ItemStack item, double worth) throws Exception {
        if (item == null) {
            throw new Exception("Invalid item");
        }
        this.key = key;
        this.item = item;
        this.worth = worth;
    }

    public ItemData createVariant(String key, short damage) throws Exception {
        ItemData copy = new ItemData(key, this.item.clone(), this.worth);
        copy.categories = this.categories;
        copy.item.setDurability(damage);
        return copy;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public double getWorth() {
        return this.worth;
    }

    @Override
    public double getEarns() {
        return this.earns == null ? this.worth * EARN_SCALE : this.earns;
    }

    @Override
    public boolean hasCustomEarns() {
        return this.earns != null;
    }

    @Override
    public Set<String> getCategories() {
        return this.categories;
    }

    @Override
    @Nullable
    public ItemStack getItemStack(int amount) {
        ItemStack newItem = InventoryUtils.getCopy(this.item);
        if (newItem == null) {
            return null;
        }
        newItem.setAmount(amount);
        return newItem;
    }

    @Override
    @Nullable
    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    public Material getType() {
        return this.item == null ? Material.AIR : this.item.getType();
    }

    @Override
    @Nullable
    @Deprecated
    public MaterialData getMaterialData() {
        if (this.item == null) {
            return null;
        }
        MaterialData materialData = this.item.getData();
        materialData.setData((byte)this.item.getDurability());
        return materialData;
    }

    @Override
    public int getDurability() {
        return this.item == null ? 0 : (int)this.item.getDurability();
    }

    @Override
    @Nullable
    public ItemMeta getItemMeta() {
        return this.item == null ? null : this.item.getItemMeta();
    }

    @Override
    @Nullable
    public MaterialAndData getMaterialAndData() {
        if (this.item == null) {
            return null;
        }
        return new MaterialAndData(this.item);
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }
}

