/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityAnimalData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Entity;

public class EntityAbstractHorseData
extends EntityAnimalData {
    public Integer domestication;
    public Integer maxDomestication;
    public Double jumpStrength;

    public EntityAbstractHorseData() {
    }

    public EntityAbstractHorseData(ConfigurationSection parameters, MageController controller) {
        super(parameters, controller);
        if (parameters.contains("horse_jump_strength")) {
            this.jumpStrength = parameters.getDouble("horse_jump_strength");
        }
        if (parameters.contains("jump_strength")) {
            this.jumpStrength = parameters.getDouble("jump_strength");
        }
        if (parameters.contains("domestication")) {
            this.domestication = parameters.getInt("domestication");
        }
        if (parameters.contains("max_domestication")) {
            this.maxDomestication = parameters.getInt("max_domestication");
        }
    }

    public EntityAbstractHorseData(Entity entity) {
        super(entity);
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            this.domestication = horse.getDomestication();
            this.maxDomestication = horse.getMaxDomestication();
            this.jumpStrength = horse.getJumpStrength();
        }
    }

    @Override
    public void apply(Entity entity) {
        super.apply(entity);
        if (entity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)entity;
            if (this.domestication != null) {
                horse.setDomestication(this.domestication.intValue());
            }
            if (this.maxDomestication != null) {
                horse.setMaxDomestication(this.maxDomestication.intValue());
            }
            if (this.jumpStrength != null) {
                horse.setJumpStrength(this.jumpStrength.doubleValue());
            }
        }
    }
}

