/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect;

import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.effect.EffectLibPlay;
import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.slikey.effectlib.Effect;
import com.elmakers.mine.bukkit.slikey.effectlib.EffectManager;
import com.elmakers.mine.bukkit.slikey.effectlib.util.DynamicLocation;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EffectLibManager {
    private static EffectManager effectManager;
    private final Plugin plugin;

    public EffectLibManager(Plugin plugin) {
        this.plugin = plugin;
    }

    public static EffectLibManager initialize(Plugin plugin, Logger logger) {
        if (effectManager == null) {
            effectManager = new EffectManager(plugin, logger);
            effectManager.setImageCacheFolder(new File(plugin.getDataFolder(), "data/imagemapcache"));
            effectManager.enableStackTraces(false);
        }
        return new EffectLibManager(plugin);
    }

    public void enableDebug(boolean debug) {
        if (effectManager != null) {
            effectManager.enableDebug(debug);
        }
    }

    public boolean isDebugEnabled() {
        return effectManager != null ? effectManager.isDebugEnabled() : false;
    }

    public void setParticleRange(int range) {
        if (effectManager != null) {
            effectManager.setParticleRange(range);
        }
    }

    @Nullable
    public EffectLibPlay play(ConfigurationSection configuration, EffectPlayer player, DynamicLocation origin, DynamicLocation target, ConfigurationSection parameterMap) {
        return this.loadEffect(true, configuration, player, origin, target, parameterMap);
    }

    @Nullable
    public EffectLibPlay validate(ConfigurationSection configuration, EffectPlayer player, DynamicLocation origin, DynamicLocation target, ConfigurationSection parameterMap) {
        return this.loadEffect(false, configuration, player, origin, target, parameterMap);
    }

    @Nullable
    public EffectLibPlay loadEffect(boolean play, ConfigurationSection configuration, EffectPlayer player, DynamicLocation origin, DynamicLocation target, ConfigurationSection parameterMap) {
        String radiusOverrideName;
        String colorOverrideName;
        Entity targetEntity;
        Entity originEntity;
        Player targetPlayer = null;
        switch (player.getVisibility()) {
            case TARGET: {
                if (target != null && target.getEntity() instanceof Player) {
                    targetPlayer = (Player)target.getEntity();
                }
                if (targetPlayer != null) break;
                return null;
            }
            case ORIGIN: {
                if (origin != null && origin.getEntity() instanceof Player) {
                    targetPlayer = (Player)origin.getEntity();
                }
                if (targetPlayer != null) break;
                return null;
            }
        }
        if (parameterMap == null) {
            parameterMap = new MemoryConfiguration();
        }
        Entity entity = originEntity = origin == null ? null : origin.getEntity();
        if (originEntity != null && originEntity instanceof Player) {
            parameterMap.set("$name", (Object)originEntity.getName());
        } else if (originEntity != null) {
            parameterMap.set("$name", (Object)originEntity.getCustomName());
        } else {
            parameterMap.set("$name", (Object)"Unknown");
        }
        Entity entity2 = targetEntity = target == null ? null : target.getEntity();
        if (targetEntity != null && targetEntity instanceof Player) {
            parameterMap.set("$target", (Object)targetEntity.getName());
        } else if (targetEntity != null) {
            parameterMap.set("$target", (Object)targetEntity.getCustomName());
        } else {
            parameterMap.set("$target", (Object)"Unknown");
        }
        Effect effect = null;
        String effectClass = configuration.getString("class");
        if (effectClass == null) {
            this.plugin.getLogger().warning("An effectlib effect is defined without a class property");
            return null;
        }
        Particle particleEffect = player.overrideParticle(null);
        String effectOverride = player.getParticleOverrideName();
        if (effectOverride != null && effectOverride.isEmpty()) {
            effectOverride = null;
        }
        if ((colorOverrideName = player.getColorOverrideName()) != null && colorOverrideName.isEmpty()) {
            colorOverrideName = null;
        }
        if ((radiusOverrideName = player.getRadiusOverrideName()) != null && radiusOverrideName.isEmpty()) {
            radiusOverrideName = null;
        }
        ConfigurationSection parameters = configuration;
        Color colorOverride = player.getColor1();
        if (colorOverrideName != null && colorOverride != null || effectOverride != null && particleEffect != null || radiusOverrideName != null) {
            parameters = new MemoryConfiguration();
            Set keys = configuration.getKeys(false);
            for (String key : keys) {
                parameters.set(key, configuration.get(key));
            }
            if (effectOverride != null && particleEffect != null) {
                parameters.set(effectOverride, (Object)particleEffect.name());
            }
            if (radiusOverrideName != null) {
                parameters.set(radiusOverrideName, (Object)player.getRadius());
            }
            if (colorOverride != null && colorOverrideName != null) {
                String hexColor = Integer.toHexString(colorOverride.asRGB());
                parameters.set(colorOverrideName, (Object)hexColor);
            }
        }
        try {
            MaterialAndData mat;
            effect = effectManager.getEffect(effectClass, parameters, origin, target, parameterMap, targetPlayer);
            if (effect != null && play) {
                effect.start();
            }
            if (!parameters.contains("material") && (mat = player.getWorkingMaterial()) != null) {
                Byte data = mat.getBlockData();
                effect.material = mat.getMaterial();
                effect.materialData = data == null ? (byte)0 : data;
            }
        }
        catch (Throwable ex) {
            this.plugin.getLogger().log(Level.WARNING, "Error playing effects of class: " + effectClass, ex);
        }
        return effect == null ? null : new EffectLibPlay(effect);
    }

    public void cancel(Collection<Effect> effects) {
        for (Effect effect : effects) {
            try {
                effect.cancel();
            }
            catch (Throwable ex) {
                this.plugin.getLogger().log(Level.WARNING, "Error cancelling effects", ex);
            }
        }
    }

    public void displayParticle(Particle particle, Location center, float offsetX, float offsetY, float offsetZ, float speed, int amount, float size, Color color, Material material, byte materialData, double range) {
        effectManager.display(particle, center, offsetX, offsetY, offsetZ, speed, amount, size, color, material, materialData, range, null);
    }
}

