/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.data.UndoData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.block.UndoList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.block.Block;

public class UndoQueue
implements com.elmakers.mine.bukkit.api.block.UndoQueue {
    private final Mage owner;
    private UndoList head = null;
    private UndoList tail = null;
    private int scheduledSize = 0;
    private int size = 0;
    private int maxSize = 0;

    public UndoQueue(Mage mage) {
        this.owner = mage;
    }

    @Override
    public void add(com.elmakers.mine.bukkit.api.block.UndoList blocks) {
        if (!(blocks instanceof UndoList)) {
            return;
        }
        UndoList addList = (UndoList)blocks;
        if (addList.hasUndoQueue()) {
            return;
        }
        addList.setMage(this.owner);
        int iterations = 100;
        while (this.owner != null && !this.owner.isLoading() && this.maxSize > 0 && this.size > this.maxSize && iterations-- > 0) {
            UndoList expired = this.tail;
            if (expired == null) continue;
            if (expired.isScheduled()) {
                expired.undoScheduled();
                continue;
            }
            expired.commit();
        }
        addList.setUndoQueue(this);
        if (addList.isScheduled()) {
            ++this.scheduledSize;
        }
        ++this.size;
        if (this.head == null) {
            this.head = addList;
            this.tail = addList;
        } else {
            addList.setPrevious(this.head);
            this.head.setNext(addList);
            this.head = addList;
        }
    }

    public void removed(UndoList list) {
        if (list == this.head) {
            this.head = list.getPrevious();
        }
        if (list == this.tail) {
            this.tail = list.getNext();
        }
        if (list.isScheduled()) {
            --this.scheduledSize;
        }
        --this.size;
    }

    @Override
    public boolean hasScheduled() {
        return this.scheduledSize > 0;
    }

    public int undoScheduled(String spellKey) {
        int undid = 0;
        UndoList nextList = this.tail;
        while (nextList != null) {
            UndoList checkList = nextList;
            nextList = nextList.getNext();
            if (!checkList.isScheduled() || spellKey != null && checkList.getSpell() != null && (!checkList.hasBeenScheduled() || !checkList.getSpell().getSpellKey().getBaseKey().equals(spellKey))) continue;
            checkList.undoScheduled(true);
            ++undid;
        }
        return undid;
    }

    @Override
    public int undoScheduled() {
        return this.undoScheduled(null);
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    @Nullable
    public UndoList getLast() {
        return this.head;
    }

    @Override
    @Nullable
    public UndoList getLast(Block target) {
        for (UndoList checkList = this.head; checkList != null; checkList = checkList.getPrevious()) {
            if (!checkList.contains(target)) continue;
            return checkList;
        }
        return null;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    @Nullable
    public UndoList undo() {
        return this.undoRecent(0);
    }

    @Nullable
    public UndoList undo(Block target) {
        return this.undoRecent(target, 0);
    }

    @Override
    @Nullable
    public UndoList undoRecent(int timeout) {
        return this.undoRecent(timeout, null);
    }

    @Override
    @Nullable
    public UndoList undoRecent(int timeout, String spellKey) {
        UndoList undo = this.head;
        while (undo != null) {
            Spell spell;
            if (timeout > 0 && System.currentTimeMillis() - (long)timeout > undo.getModifiedTime()) {
                return null;
            }
            if (!(spellKey == null || (spell = undo.getSpell()) != null && spell.getSpellKey().getBaseKey().equalsIgnoreCase(spellKey))) {
                undo = this.head.getNext();
                continue;
            }
            undo.undo();
            return undo;
        }
        return null;
    }

    @Override
    @Nullable
    public UndoList undoRecent(Block block, int timeout) {
        UndoList lastActionOnTarget = this.getLast(block);
        if (lastActionOnTarget == null) {
            return null;
        }
        if (timeout > 0 && System.currentTimeMillis() - (long)timeout > lastActionOnTarget.getModifiedTime()) {
            return null;
        }
        lastActionOnTarget.undo();
        return lastActionOnTarget;
    }

    @Override
    public void load(UndoData data) {
        try {
            if (data == null) {
                return;
            }
            List<com.elmakers.mine.bukkit.api.block.UndoList> undoList = data.getBlockList();
            if (undoList != null) {
                for (com.elmakers.mine.bukkit.api.block.UndoList list : undoList) {
                    this.add(list);
                    if (!list.isScheduled() || !list.hasChanges()) continue;
                    this.owner.getController().scheduleUndo(list);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.owner.getController().getLogger().warning("Failed to load undo data: " + ex.getMessage());
        }
    }

    @Override
    public void save(UndoData data) {
        MageController controller = this.owner.getController();
        int maxSize = controller.getMaxUndoPersistSize();
        try {
            int discarded = 0;
            List<com.elmakers.mine.bukkit.api.block.UndoList> undoList = data.getBlockList();
            for (UndoList list = this.tail; list != null; list = list.getNext()) {
                if (maxSize > 0 && list.size() > maxSize) {
                    ++discarded;
                    continue;
                }
                if (list.size() <= 0) continue;
                undoList.add(list);
            }
            if (discarded > 0) {
                controller.getLogger().info("Not saving " + discarded + " undo batches for mage " + this.owner.getName() + ", over max size of " + maxSize);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            controller.getLogger().warning("Failed to save undo data: " + ex.getMessage());
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean commit() {
        for (UndoList nextList = this.tail; nextList != null; nextList = nextList.getNext()) {
            UndoList list = nextList;
            list.commit();
        }
        this.head = null;
        this.tail = null;
        this.size = 0;
        return true;
    }

    @Override
    public Collection<com.elmakers.mine.bukkit.api.block.UndoList> getAll() {
        ArrayList<com.elmakers.mine.bukkit.api.block.UndoList> list = new ArrayList<com.elmakers.mine.bukkit.api.block.UndoList>();
        for (UndoList current = this.tail; current != null; current = current.getPrevious()) {
            list.add(current);
        }
        return list;
    }

    public void skippedUndo(com.elmakers.mine.bukkit.api.block.UndoList undoList) {
        --this.scheduledSize;
    }
}

