/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.batch;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.BlockData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.MaterialSetManager;
import com.elmakers.mine.bukkit.block.UndoList;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.block.BlockState;

public class UndoBatch
implements com.elmakers.mine.bukkit.api.batch.UndoBatch {
    protected final MageController controller;
    protected boolean finished = false;
    protected boolean applyPhysics = false;
    protected UndoList undoList;
    protected int listSize;
    protected int listProcessed;
    protected double partialWork = 0.0;
    private Set<Chunk> affectedChunks = new HashSet<Chunk>();
    private final MaterialSet attachables;

    public UndoBatch(UndoList blockList) {
        Mage mage = blockList.getOwner();
        this.controller = mage.getController();
        this.undoList = blockList;
        this.applyPhysics = blockList.getApplyPhysics();
        CastContext context = this.undoList.getContext();
        if (context != null) {
            context.playEffects("undo");
        }
        MaterialSetManager materialSets = this.controller.getMaterialSetManager();
        this.attachables = materialSets.getMaterialSet("all_attachable");
        this.undoList.sort(this.attachables);
        this.listSize = this.undoList.size();
    }

    @Override
    public int size() {
        return this.listSize;
    }

    @Override
    public int remaining() {
        return this.undoList == null ? 0 : this.undoList.size();
    }

    @Override
    public int process(int maxWork) {
        if (this.finished) {
            return 0;
        }
        int workPerformed = 0;
        double undoSpeed = this.undoList.getUndoSpeed();
        if (undoSpeed > 0.0 && this.listProcessed < this.listSize && maxWork >= 0) {
            this.partialWork += undoSpeed;
            if (this.partialWork > 1.0) {
                maxWork = (int)Math.floor(this.partialWork);
                this.partialWork -= (double)maxWork;
            } else {
                return 0;
            }
        }
        while (this.undoList.size() > 0 && (workPerformed < maxWork || maxWork < 0)) {
            Mage mage;
            BlockData undone;
            BlockData next;
            BlockState prior = null;
            if (!this.undoList.isScheduled() && (next = this.undoList.getBlockList().iterator().next()) != null) {
                prior = next.getBlock().getState();
            }
            if ((undone = this.undoList.undoNext(this.applyPhysics)) == null) {
                workPerformed += 20;
                break;
            }
            Chunk chunk = undone.getChunk();
            if (this.affectedChunks.add(chunk)) {
                this.controller.lockChunk(chunk);
            }
            if (prior != null && (mage = this.undoList.getOwner()) != null) {
                this.controller.logBlockChange(mage, prior, undone.getBlock().getState());
            }
            workPerformed += 10;
            ++this.listProcessed;
        }
        if (this.undoList.size() == 0) {
            this.finish();
        }
        return workPerformed;
    }

    @Override
    public void cancel() {
        this.finish();
    }

    @Override
    public void finish() {
        if (!this.finished) {
            CastContext context;
            this.finished = true;
            this.undoList.unregisterWatched();
            this.undoList.undoEntityEffects();
            this.undoList.finish();
            if (!this.undoList.isScheduled()) {
                this.controller.update(this.undoList);
            }
            if ((context = this.undoList.getContext()) != null) {
                context.playEffects("undo_finished");
            }
            for (Chunk chunk : this.affectedChunks) {
                this.controller.unlockChunk(chunk);
            }
            this.affectedChunks.clear();
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public String getName() {
        return "Undo " + this.undoList.getName();
    }

    @Override
    public UndoList getUndoList() {
        return this.undoList;
    }

    @Override
    public void complete() {
        while (!this.isFinished()) {
            this.process(-1);
        }
    }
}

